/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.db;

import com.db4o.Db4oEmbedded;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.config.EmbeddedConfiguration;
import com.db4o.query.Constraint;
import com.db4o.query.Query;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.Version;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.ourfilesystem.db.DataBaseCoreInterface;
import org.ourfilesystem.db.DataBaseQueryImpl;
import org.ourfilesystem.db.DataBaseQueryInterface;
import org.ourfilesystem.db.OFSAnalyzer;
import org.ourfilesystem.db.so.FileReference;
import org.ourfilesystem.db.so.FileStatus;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.db.so.LocalPost;
import org.ourfilesystem.db.so.LocalPublicPost;
import org.ourfilesystem.db.so.MyPeerDataSO;
import org.ourfilesystem.db.so.Network;
import org.ourfilesystem.db.so.NetworkAuthHoles;
import org.ourfilesystem.db.so.NetworkAuthorization;
import org.ourfilesystem.db.so.NetworkHoles;
import org.ourfilesystem.db.so.Peer;
import org.ourfilesystem.db.so.PeerExclude;
import org.ourfilesystem.db.so.PeerHasFile;
import org.ourfilesystem.db.so.PeerInclude;
import org.ourfilesystem.db.so.Post;
import org.ourfilesystem.db.so.PostHoles;
import org.ourfilesystem.db.so.PostMessage;
import org.ourfilesystem.db.so.PostTemplate;
import org.ourfilesystem.db.so.PublicPost;
import org.ourfilesystem.db.so.PublicPostHoles;
import org.ourfilesystem.db.so.SearchQuery;
import org.ourfilesystem.security.KeySet;
import org.ourfilesystem.security.PublicKeySet;
import org.ourfilesystem.security.SignedDigest;
import org.ourfilesystem.utilities.BBytes;

public class DataBaseCoreImpl
implements DataBaseCoreInterface,
Runnable {
    public static final Logger Log = Logger.getLogger(DataBaseCoreImpl.class.getName());
    public static String INDEX_DIR = "standard-indexer";
    public static String PUBLIC_POST_DATE = "ppdate";
    public static String PUBLIC_POST_ID0 = "ppostid0";
    public static String PUBLIC_POST_ID1 = "ppostid1";
    public static String PUBLIC_POST_PEERID0 = "ppostpeer0";
    public static String PUBLIC_POST_PEERID1 = "ppostpeer1";
    public static String PUBLIC_POST_DECODED_MESSAGE = "ppdecodedmessage";
    public static String PUBLIC_POST_MESSAGE = "ppmessage";
    public static String PUBLIC_POST_PRIVATE = "ppprivate";
    public static String PUBLIC_POST_ENCRYPTED = "ppencrypt";
    public static String NETWORK_DATE = "netdate";
    public static String NETWORK_TITLE = "nettitle";
    public static String NETWORK_DESCRIPTION = "netdesc";
    public static String NETWORK_PEERID0 = "netpeerid0";
    public static String NETWORK_PEERID1 = "netpeerid1";
    public static String NETWORK_ID0 = "netid0";
    public static String NETWORK_ID1 = "netid1";
    public static String NETWORK_AUTH = "netauth";
    public static String NETWORK_AUTH_NUM = "netauthnum";
    public static String POST_POSTNUM = "postnum";
    public static String POST_NETID0 = "pnetid0";
    public static String POST_NETID1 = "pnetid1";
    public static String POST_DATE = "pdate";
    public static String POST_ID0 = "postid0";
    public static String POST_ID1 = "postid1";
    public static String POST_PEERID0 = "postpeer0";
    public static String POST_PEERID1 = "postpeer1";
    public static String POST_COMMENT = "comment";
    public static String POST_STRING0 = "string0";
    public static String POST_STRING1 = "string1";
    public static String POST_STRING2 = "string2";
    public static String POST_STRING3 = "string3";
    public static String POST_STRING4 = "string4";
    public static String POST_STRING5 = "string5";
    public static String POST_STRING6 = "string6";
    public static String POST_STRING7 = "string7";
    public static String POST_FILENAME = "filename";
    public static String POST_SUBJECT = "subject";
    public static String POST_FILEREF0 = "fileref0";
    public static String POST_FILEREF1 = "fileref1";
    public static String POST_REF00 = "ref00";
    public static String POST_REF01 = "ref01";
    public static String POST_REF10 = "ref10";
    public static String POST_REF11 = "ref11";
    public static String POST_REF20 = "ref20";
    public static String POST_REF21 = "ref21";
    public static String POST_USETEMPLATE0 = "usetemp0";
    public static String POST_USETEMPLATE1 = "usetemp1";
    public static String POST_NUM0 = "num0";
    public static String POST_NUM1 = "num1";
    public static String POST_NUM2 = "num2";
    public static String POST_NUM3 = "num3";
    public static String POST_NUM4 = "num4";
    public static String POST_NUM5 = "num5";
    public static String POST_NUM6 = "num6";
    public static String POST_NUM7 = "num7";
    public static String POST_NUM8 = "num8";
    public static String POST_NUM9 = "num9";
    public static String POST_DOUBLE0 = "double0";
    public static String POST_DOUBLE1 = "double1";
    public static String POST_DOUBLE2 = "double2";
    public static String POST_DOUBLE3 = "double3";
    public static String POST_DOUBLE4 = "double4";
    public static String POST_DOUBLE5 = "double5";
    public static String POST_DOUBLE6 = "double6";
    public static String POST_DOUBLE7 = "double7";
    public static String POST_DOUBLE8 = "double8";
    public static String POST_DOUBLE9 = "double9";
    public static String POST_BOOL0 = "bool0";
    public static String POST_BOOL1 = "bool1";
    public static String POST_BOOL2 = "bool2";
    public static String POST_BOOL3 = "bool3";
    public static String POST_BOOL4 = "bool4";
    public static String POST_BOOL5 = "bool5";
    public static String POST_BOOL6 = "bool6";
    public static String POST_BOOL7 = "bool7";
    public static String POST_BOOL8 = "bool8";
    public static String POST_BOOL9 = "bool9";
    public static String POST_TEMP = "temp";
    public static String POST_PEERRANK = "postrank";
    public static String PEER_DATE = "prdate";
    public static String PEER_INTRO = "intro";
    public static String PEER_NICKNAME = "nick";
    public static String PEER_RANK = "peerrank";
    public static String PEER_ID0 = "peerid0";
    public static String PEER_ID1 = "peerid1";
    private File BaseDir;
    private ObjectContainer DB;
    private IndexWriter Indexer;
    private FieldType PostIdType;
    private boolean Closed;
    private boolean PendingIndex;
    private DataBaseQueryImpl DBQuery;

    public DataBaseCoreImpl(String basedir) throws IOException {
        this.BaseDir = new File(basedir);
        if (!this.BaseDir.exists()) {
            this.BaseDir.mkdirs();
        } else if (!this.BaseDir.isDirectory()) {
            throw new RuntimeException("Expecting a directory: " + basedir);
        }
        String file = String.valueOf(basedir) + File.separator + "mainstore.dat";
        EmbeddedConfiguration db4oconfig = Db4oEmbedded.newConfiguration();
        db4oconfig.common().activationDepth(10);
        db4oconfig.common().updateDepth(10);
        db4oconfig.common().objectClass(BBytes.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(BBytes.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(BBytes.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(BBytes.class).objectField("Index0").indexed(true);
        db4oconfig.common().objectClass(BBytes.class).objectField("Index1").indexed(true);
        db4oconfig.common().objectClass(BBytes.class).objectField("Index2").indexed(true);
        db4oconfig.common().objectClass(BBytes.class).objectField("Index3").indexed(true);
        db4oconfig.common().objectClass(BBytes.class).objectField("Index4").indexed(true);
        db4oconfig.common().objectClass(BBytes.class).objectField("Index5").indexed(true);
        db4oconfig.common().objectClass(BBytes.class).objectField("Index6").indexed(true);
        db4oconfig.common().objectClass(BBytes.class).objectField("Index7").indexed(true);
        db4oconfig.common().objectClass(SignedDigest.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(SignedDigest.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(SignedDigest.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(SignedDigest.class).objectField("Digest").indexed(true);
        db4oconfig.common().objectClass(SignedDigest.class).objectField("PeerIdentifier").indexed(true);
        db4oconfig.common().objectClass(RSAKeyParameters.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(RSAKeyParameters.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(RSAKeyParameters.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(RSAPrivateCrtKeyParameters.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(RSAPrivateCrtKeyParameters.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(RSAPrivateCrtKeyParameters.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(PublicKeySet.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(PublicKeySet.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(PublicKeySet.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(KeySet.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(KeySet.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(KeySet.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(Peer.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(Peer.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(Peer.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(Peer.class).objectField("Identity").indexed(true);
        db4oconfig.common().objectClass(File.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(File.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(File.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(LocalPeer.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(LocalPeer.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(LocalPeer.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("Peer").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("LocalDate").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("ConnectionAttempts").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("SuccessfulConnectionAttempts").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("LastConnectionTime").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("Requests").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("SuccessfulRequests").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("LastSuccessRequest").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("NumberOfNewPeers").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("LastNewPeer").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("RequestPeers").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("RequestPeersTime").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("RequestPeersPriority").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("NumberOfNewNetworks").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("LastNewNetwork").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("RequestNetworks").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("RequestNetworksTime").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("RequestNetworksPriority").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("RequestNetworksDispatched").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("RequestNetworksDispatchedTime").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("NumberOfNewPublicPosts").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("LastNewPublicPost").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("RequestPublicPosts").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("RequestPublicPostsTime").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("RequestPublicPostsPriority").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("RequestPublicPostsDispatched").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("RequestPublicPostsDispatchedTime").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("LastPublicPostNumber").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("LastNetworkNumber").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("PushRequested").indexed(true);
        db4oconfig.common().objectClass(LocalPeer.class).objectField("ReceivedFromPeer").indexed(true);
        db4oconfig.common().objectClass(MyPeerDataSO.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(MyPeerDataSO.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(MyPeerDataSO.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(MyPeerDataSO.class).objectField("Peer").indexed(true);
        db4oconfig.common().objectClass(FileReference.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(FileReference.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(FileReference.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(FileReference.class).objectField("UserRequested").indexed(true);
        db4oconfig.common().objectClass(FileReference.class).objectField("UserRequestTime").indexed(true);
        db4oconfig.common().objectClass(FileReference.class).objectField("UserRequestPriority").indexed(true);
        db4oconfig.common().objectClass(FileReference.class).objectField("UserRequestDispatched").indexed(true);
        db4oconfig.common().objectClass(FileReference.class).objectField("UserRequestDispatchTime").indexed(true);
        db4oconfig.common().objectClass(FileReference.class).objectField("NetworkId").indexed(true);
        db4oconfig.common().objectClass(FileReference.class).objectField("UnsignedDigest").indexed(true);
        db4oconfig.common().objectClass(FileReference.class).objectField("File").indexed(true);
        db4oconfig.common().objectClass(Network.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(Network.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(Network.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(Network.class).objectField("NetworkNumber").indexed(true);
        db4oconfig.common().objectClass(Network.class).objectField("Signature").indexed(true);
        db4oconfig.common().objectClass(LocalNetwork.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(LocalNetwork.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(LocalNetwork.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(LocalNetwork.class).objectField("Network").indexed(true);
        db4oconfig.common().objectClass(LocalNetwork.class).objectField("PushRequested").indexed(true);
        db4oconfig.common().objectClass(NetworkHoles.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(NetworkHoles.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(NetworkHoles.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(NetworkHoles.class).objectField("PeerId").indexed(true);
        db4oconfig.common().objectClass(NetworkHoles.class).objectField("FirstNumber").indexed(true);
        db4oconfig.common().objectClass(NetworkHoles.class).objectField("LastNumber").indexed(true);
        db4oconfig.common().objectClass(NetworkAuthorization.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(NetworkAuthorization.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(NetworkAuthorization.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(NetworkAuthorization.class).objectField("PeerId").indexed(true);
        db4oconfig.common().objectClass(NetworkAuthorization.class).objectField("NetworkId").indexed(true);
        db4oconfig.common().objectClass(NetworkAuthorization.class).objectField("SignatureNumber").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("NetworkAuthorization").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("LocalDate").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("MarkedBad").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("MarkedBadDate").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("NumberOfNewPosts").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("LastNewPost").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("RequestPosts").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("RequestPostsTime").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("RequestPostsPriority").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("RequestPostsDispatched").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("RequestPostsDispatchedTime").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("LastPostNumber").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("NumberOfNewAuths").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("LastNewAuths").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("RequestAuths").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("RequestAuthsTime").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("RequestAuthsPriority").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("RequestAuthsDispatched").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("RequestAuthsDispatchedTime").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("LastNetworkAuthNumber").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("NumberOfFiles").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("LastNewFile").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("PushRequested").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("ReceivedFromPeer").indexed(true);
        db4oconfig.common().objectClass(LocalNetworkAuthorization.class).objectField("PeerRank").indexed(true);
        db4oconfig.common().objectClass(NetworkAuthHoles.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(NetworkAuthHoles.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(NetworkAuthHoles.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(NetworkAuthHoles.class).objectField("PeerId").indexed(true);
        db4oconfig.common().objectClass(NetworkAuthHoles.class).objectField("NetworkId").indexed(true);
        db4oconfig.common().objectClass(NetworkAuthHoles.class).objectField("FirstNumber").indexed(true);
        db4oconfig.common().objectClass(NetworkAuthHoles.class).objectField("LastNumber").indexed(true);
        db4oconfig.common().objectClass(PublicPost.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(PublicPost.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(PublicPost.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(PublicPost.class).objectField("NetworkId").indexed(true);
        db4oconfig.common().objectClass(PublicPost.class).objectField("Signature").indexed(true);
        db4oconfig.common().objectClass(PublicPost.class).objectField("PostNumber").indexed(true);
        db4oconfig.common().objectClass(LocalPublicPost.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(LocalPublicPost.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(LocalPublicPost.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(LocalPublicPost.class).objectField("PublicPost").indexed(true);
        db4oconfig.common().objectClass(LocalPublicPost.class).objectField("LocalDate").indexed(true);
        db4oconfig.common().objectClass(PublicPostHoles.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(PublicPostHoles.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(PublicPostHoles.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(PublicPostHoles.class).objectField("PeerId").indexed(true);
        db4oconfig.common().objectClass(PublicPostHoles.class).objectField("FirstNumber").indexed(true);
        db4oconfig.common().objectClass(PublicPostHoles.class).objectField("LastNumber").indexed(true);
        db4oconfig.common().objectClass(Post.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(Post.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(Post.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(Post.class).objectField("NetworkId").indexed(true);
        db4oconfig.common().objectClass(Post.class).objectField("FileReferenceDigest").indexed(true);
        db4oconfig.common().objectClass(Post.class).objectField("PosterHasFile").indexed(true);
        db4oconfig.common().objectClass(Post.class).objectField("PostNumber").indexed(true);
        db4oconfig.common().objectClass(Post.class).objectField("SignedDigest").indexed(true);
        db4oconfig.common().objectClass(LocalPost.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(LocalPost.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(LocalPost.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(LocalPost.class).objectField("Post").indexed(true);
        db4oconfig.common().objectClass(LocalPost.class).objectField("LocalDate").indexed(true);
        db4oconfig.common().objectClass(LocalPost.class).objectField("PushRequested").indexed(true);
        db4oconfig.common().objectClass(LocalPost.class).objectField("PeerRank").indexed(true);
        db4oconfig.common().objectClass(PostHoles.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(PostHoles.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(PostHoles.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(PostHoles.class).objectField("PeerId").indexed(true);
        db4oconfig.common().objectClass(PostHoles.class).objectField("NetworkId").indexed(true);
        db4oconfig.common().objectClass(PostHoles.class).objectField("FirstNumber").indexed(true);
        db4oconfig.common().objectClass(PostHoles.class).objectField("LastNumber").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(PostMessage.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(PostMessage.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Ref0").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Ref1").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Ref2").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Ref3").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Bool0").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Bool1").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Bool2").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Bool3").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Bool4").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Bool5").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Bool6").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Bool7").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Bool8").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Bool9").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Num0").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Num1").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Num2").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Num3").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Num4").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Num5").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Num6").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Num7").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Num8").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Num9").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Double0").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Double1").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Double2").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Double3").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Double4").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Double5").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Double6").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Double7").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Double8").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Double9").indexed(true);
        db4oconfig.common().objectClass(PostMessage.class).objectField("Template").indexed(true);
        db4oconfig.common().objectClass(PeerHasFile.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(PeerHasFile.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(PeerHasFile.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(PeerHasFile.class).objectField("PeerId").indexed(true);
        db4oconfig.common().objectClass(PeerHasFile.class).objectField("NetworkId").indexed(true);
        db4oconfig.common().objectClass(PeerHasFile.class).objectField("Digest").indexed(true);
        db4oconfig.common().objectClass(PeerHasFile.class).objectField("LastMessage").indexed(true);
        db4oconfig.common().objectClass(PeerHasFile.class).objectField("PeerHasFile").indexed(true);
        db4oconfig.common().objectClass(PeerExclude.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(PeerExclude.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(PeerExclude.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(PeerExclude.class).objectField("NetworkId").indexed(true);
        db4oconfig.common().objectClass(PeerExclude.class).objectField("PeerId").indexed(true);
        db4oconfig.common().objectClass(PeerInclude.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(PeerInclude.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(PeerInclude.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(PeerInclude.class).objectField("NetworkId").indexed(true);
        db4oconfig.common().objectClass(PeerInclude.class).objectField("PeerId").indexed(true);
        db4oconfig.common().objectClass(FileStatus.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(FileStatus.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(FileStatus.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(FileStatus.class).objectField("NetworkId").indexed(true);
        db4oconfig.common().objectClass(FileStatus.class).objectField("File").indexed(true);
        db4oconfig.common().objectClass(FileStatus.class).objectField("MetaFileDigest").indexed(true);
        db4oconfig.common().objectClass(FileStatus.class).objectField("CompleteDigest").indexed(true);
        db4oconfig.common().objectClass(FileStatus.class).objectField("PeerId").indexed(true);
        db4oconfig.common().objectClass(FileStatus.class).objectField("MasterPost").indexed(true);
        db4oconfig.common().objectClass(PostTemplate.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(PostTemplate.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(PostTemplate.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(PostTemplate.class).objectField("NetworkId").indexed(true);
        db4oconfig.common().objectClass(SearchQuery.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(SearchQuery.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(SearchQuery.class).cascadeOnUpdate(true);
        this.DB = Db4oEmbedded.openFile((EmbeddedConfiguration)db4oconfig, (String)file);
        FieldType ft = LongField.TYPE_STORED;
        Log.info("LongField: indexed? " + ft.indexed());
        this.PostIdType = new FieldType();
        this.PostIdType.setDocValueType(ft.docValueType());
        this.PostIdType.setIndexOptions(ft.indexOptions());
        this.PostIdType.setNumericPrecisionStep(ft.numericPrecisionStep());
        this.PostIdType.setNumericType(ft.numericType());
        this.PostIdType.setOmitNorms(ft.omitNorms());
        this.PostIdType.setStoreTermVectorOffsets(ft.storeTermVectorOffsets());
        this.PostIdType.setStoreTermVectorPayloads(ft.storeTermVectorPayloads());
        this.PostIdType.setStoreTermVectorPositions(ft.storeTermVectorPositions());
        this.PostIdType.setStoreTermVectors(ft.storeTermVectors());
        this.PostIdType.setTokenized(ft.tokenized());
        this.PostIdType.setIndexed(true);
        this.PostIdType.setStored(true);
        this.PostIdType.freeze();
        File idxdir = new File(String.valueOf(this.BaseDir.getPath()) + File.separator + INDEX_DIR);
        if (!idxdir.exists()) {
            idxdir.mkdirs();
        } else if (!idxdir.isDirectory()) {
            throw new RuntimeException("standard-indexer is not a dir!");
        }
        this.PendingIndex = false;
        IndexWriterConfig idxconf = new IndexWriterConfig(Version.LUCENE_44, (Analyzer)new OFSAnalyzer(Version.LUCENE_44));
        SimpleFSDirectory fsdir = new SimpleFSDirectory(idxdir);
        this.Indexer = new IndexWriter((Directory)fsdir, idxconf);
        this.Indexer.commit();
        this.DBQuery = new DataBaseQueryImpl(this.BaseDir.getPath(), this.DB);
        this.Closed = false;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                DataBaseCoreImpl.this.Close();
            }
        });
        Thread t = new Thread(this);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.Closed) {
            try {
                Thread.sleep(2000L);
                if (!this.PendingIndex) continue;
                IndexWriter indexWriter = this.Indexer;
                synchronized (indexWriter) {
                    this.Indexer.commit();
                    this.PendingIndex = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Close() {
        this.Closed = true;
        this.DB.close();
        this.DBQuery.Close();
        try {
            IndexWriter indexWriter = this.Indexer;
            synchronized (indexWriter) {
                this.Indexer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public DataBaseQueryInterface getDBQuery() {
        return this.DBQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexPublicPost(LocalPublicPost lp) {
        Object m;
        boolean allnull = true;
        Document d = new Document();
        if (lp.getDecodedMessage() != null) {
            allnull = false;
            String str = (String)lp.getDecodedMessage();
            d.add((IndexableField)new TextField(PUBLIC_POST_DECODED_MESSAGE, str, Field.Store.NO));
        }
        if ((m = lp.getPublicPost().getMessage()) != null && m instanceof String) {
            allnull = false;
            d.add((IndexableField)new TextField(PUBLIC_POST_MESSAGE, (String)m, Field.Store.NO));
        }
        if (!allnull) {
            d.add((IndexableField)new StringField(PUBLIC_POST_PRIVATE, lp.isPrivateMessage() ? "1" : "0", Field.Store.NO));
            d.add((IndexableField)new StringField(PUBLIC_POST_ENCRYPTED, lp.getPublicPost().isEncrypted() ? "1" : "0", Field.Store.NO));
            d.add((IndexableField)new LongField(PUBLIC_POST_DATE, lp.getLocalDate().getTime(), Field.Store.NO));
            d.add((IndexableField)new LongField(PUBLIC_POST_PEERID0, lp.getPublicPost().getSignature().getPeerIdentifier().getIndex0(), Field.Store.NO));
            d.add((IndexableField)new LongField(PUBLIC_POST_PEERID1, lp.getPublicPost().getSignature().getPeerIdentifier().getIndex1(), Field.Store.NO));
            d.add((IndexableField)new LongField(PUBLIC_POST_ID0, lp.getPublicPost().getSignature().getDigest().getIndex0(), this.PostIdType));
            d.add((IndexableField)new LongField(PUBLIC_POST_ID1, lp.getPublicPost().getSignature().getDigest().getIndex1(), this.PostIdType));
            try {
                IndexWriter indexWriter = this.Indexer;
                synchronized (indexWriter) {
                    this.Indexer.addDocument((Iterable)d);
                    this.PendingIndex = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexNetwork(LocalNetwork ln, boolean update) {
        boolean allnull = true;
        Document d = new Document();
        String titl = ln.getNetwork().getTitle();
        String desc = ln.getNetwork().getDescription();
        if (titl != null) {
            allnull = false;
            d.add((IndexableField)new TextField(NETWORK_TITLE, titl, Field.Store.NO));
        }
        if (desc != null) {
            allnull = false;
            d.add((IndexableField)new TextField(NETWORK_DESCRIPTION, desc, Field.Store.NO));
        }
        if (!allnull) {
            d.add((IndexableField)new LongField(NETWORK_DATE, ln.getLocalDate().getTime(), Field.Store.NO));
            d.add((IndexableField)new LongField(NETWORK_PEERID0, ln.getNetwork().getSignature().getPeerIdentifier().getIndex0(), Field.Store.NO));
            d.add((IndexableField)new LongField(NETWORK_PEERID1, ln.getNetwork().getSignature().getPeerIdentifier().getIndex1(), Field.Store.NO));
            d.add((IndexableField)new LongField(NETWORK_ID0, ln.getNetwork().getSignature().getDigest().getIndex0(), this.PostIdType));
            d.add((IndexableField)new LongField(NETWORK_ID1, ln.getNetwork().getSignature().getDigest().getIndex1(), this.PostIdType));
            d.add((IndexableField)new StringField(NETWORK_AUTH, ln.isAuthorized() ? "1" : "0", Field.Store.NO));
            d.add((IndexableField)new LongField(NETWORK_AUTH_NUM, (long)ln.getAuthorization(), Field.Store.NO));
            try {
                IndexWriter indexWriter = this.Indexer;
                synchronized (indexWriter) {
                    if (update) {
                        this.deleteNetworkFromIndex(ln);
                    }
                    this.Indexer.addDocument((Iterable)d);
                    this.PendingIndex = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexPeer(LocalPeer lp, boolean update) {
        boolean allnull = true;
        Peer p = lp.getPeer();
        Document d = new Document();
        if (p.getIntroduction() != null) {
            allnull = false;
            d.add((IndexableField)new TextField(PEER_INTRO, p.getIntroduction(), Field.Store.NO));
        }
        if (p.getNickname() != null) {
            allnull = false;
            d.add((IndexableField)new TextField(PEER_NICKNAME, p.getNickname(), Field.Store.NO));
        }
        if (!allnull) {
            d.add((IndexableField)new LongField(PEER_DATE, lp.getLocalDate().getTime(), Field.Store.NO));
            d.add((IndexableField)new LongField(PEER_ID0, p.getIdentity().getIndex0(), this.PostIdType));
            d.add((IndexableField)new LongField(PEER_ID1, p.getIdentity().getIndex1(), this.PostIdType));
            try {
                IndexWriter indexWriter = this.Indexer;
                synchronized (indexWriter) {
                    if (update) {
                        this.deletePeerFromIndex(lp);
                    }
                    Log.info("INDEX PERE!");
                    this.Indexer.addDocument((Iterable)d);
                    this.PendingIndex = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void deletePeerFromIndex(LocalPeer lp) throws IOException {
        BytesRef bytes = new BytesRef();
        NumericUtils.longToPrefixCoded((long)lp.getPeer().getIdentity().getIndex0(), (int)0, (BytesRef)bytes);
        TermQuery id0 = new TermQuery(new Term(PEER_ID0, bytes));
        BytesRef bytes1 = new BytesRef();
        NumericUtils.longToPrefixCoded((long)lp.getPeer().getIdentity().getIndex1(), (int)0, (BytesRef)bytes1);
        TermQuery id1 = new TermQuery(new Term(PEER_ID1, bytes1));
        BooleanQuery bq = new BooleanQuery();
        bq.add((org.apache.lucene.search.Query)id0, BooleanClause.Occur.MUST);
        bq.add((org.apache.lucene.search.Query)id1, BooleanClause.Occur.MUST);
        this.Indexer.deleteDocuments((org.apache.lucene.search.Query)bq);
    }

    private void deletePostFromIndex(LocalPost lp) throws IOException {
        BytesRef bytes = new BytesRef();
        NumericUtils.longToPrefixCoded((long)lp.getPost().getSignedDigest().getDigest().getIndex0(), (int)0, (BytesRef)bytes);
        TermQuery id0 = new TermQuery(new Term(POST_ID0, bytes));
        BytesRef bytes1 = new BytesRef();
        NumericUtils.longToPrefixCoded((long)lp.getPost().getSignedDigest().getDigest().getIndex1(), (int)0, (BytesRef)bytes1);
        TermQuery id1 = new TermQuery(new Term(POST_ID1, bytes1));
        BooleanQuery bq = new BooleanQuery();
        bq.add((org.apache.lucene.search.Query)id0, BooleanClause.Occur.MUST);
        bq.add((org.apache.lucene.search.Query)id1, BooleanClause.Occur.MUST);
        this.Indexer.deleteDocuments((org.apache.lucene.search.Query)bq);
    }

    private void deleteNetworkFromIndex(LocalNetwork ln) throws IOException {
        BytesRef bytes = new BytesRef();
        NumericUtils.longToPrefixCoded((long)ln.getNetwork().getSignature().getDigest().getIndex0(), (int)0, (BytesRef)bytes);
        TermQuery id0 = new TermQuery(new Term(NETWORK_ID0, bytes));
        BytesRef bytes1 = new BytesRef();
        NumericUtils.longToPrefixCoded((long)ln.getNetwork().getSignature().getDigest().getIndex1(), (int)0, (BytesRef)bytes1);
        TermQuery id1 = new TermQuery(new Term(NETWORK_ID1, bytes1));
        BooleanQuery bq = new BooleanQuery();
        bq.add((org.apache.lucene.search.Query)id0, BooleanClause.Occur.MUST);
        bq.add((org.apache.lucene.search.Query)id1, BooleanClause.Occur.MUST);
        this.Indexer.deleteDocuments((org.apache.lucene.search.Query)bq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexPost(LocalPost lp, boolean update) {
        Post p = lp.getPost();
        Object m = p.getMessage();
        if (m != null && m instanceof PostMessage) {
            PostMessage pm = (PostMessage)m;
            boolean useful = false;
            Document d = new Document();
            if (pm.getComment() != null) {
                d.add((IndexableField)new TextField(POST_COMMENT, pm.getComment(), Field.Store.NO));
                useful = true;
            }
            if (pm.getString0() != null) {
                d.add((IndexableField)new TextField(POST_STRING0, pm.getString0(), Field.Store.NO));
                useful = true;
            }
            if (pm.getString1() != null) {
                d.add((IndexableField)new TextField(POST_STRING1, pm.getString1(), Field.Store.NO));
                useful = true;
            }
            if (pm.getString2() != null) {
                d.add((IndexableField)new TextField(POST_STRING2, pm.getString2(), Field.Store.NO));
                useful = true;
            }
            if (pm.getString3() != null) {
                d.add((IndexableField)new TextField(POST_STRING3, pm.getString3(), Field.Store.NO));
                useful = true;
            }
            if (pm.getString4() != null) {
                d.add((IndexableField)new TextField(POST_STRING4, pm.getString4(), Field.Store.NO));
                useful = true;
            }
            if (pm.getString5() != null) {
                d.add((IndexableField)new TextField(POST_STRING5, pm.getString5(), Field.Store.NO));
                useful = true;
            }
            if (pm.getString6() != null) {
                d.add((IndexableField)new TextField(POST_STRING6, pm.getString6(), Field.Store.NO));
                useful = true;
            }
            if (pm.getString7() != null) {
                d.add((IndexableField)new TextField(POST_STRING7, pm.getString7(), Field.Store.NO));
                useful = true;
            }
            if (pm.getFileName() != null) {
                d.add((IndexableField)new TextField(POST_FILENAME, pm.getFileName(), Field.Store.NO));
                useful = true;
            }
            if (pm.getSubject() != null) {
                d.add((IndexableField)new TextField(POST_SUBJECT, pm.getSubject(), Field.Store.NO));
                useful = true;
            }
            if (p.getFileReferenceDigest() != null) {
                useful = true;
                d.add((IndexableField)new LongField(POST_FILEREF0, p.getFileReferenceDigest().getIndex0(), Field.Store.YES));
                d.add((IndexableField)new LongField(POST_FILEREF1, p.getFileReferenceDigest().getIndex1(), Field.Store.YES));
            }
            if (pm.getRef0() != null) {
                useful = true;
                d.add((IndexableField)new LongField(POST_REF00, pm.getRef0().getIndex0(), Field.Store.YES));
                d.add((IndexableField)new LongField(POST_REF01, pm.getRef0().getIndex1(), Field.Store.YES));
            }
            if (pm.getRef1() != null) {
                useful = true;
                d.add((IndexableField)new LongField(POST_REF10, pm.getRef1().getIndex0(), Field.Store.YES));
                d.add((IndexableField)new LongField(POST_REF11, pm.getRef1().getIndex1(), Field.Store.YES));
            }
            if (pm.getRef2() != null) {
                useful = true;
                d.add((IndexableField)new LongField(POST_REF20, pm.getRef2().getIndex0(), Field.Store.YES));
                d.add((IndexableField)new LongField(POST_REF21, pm.getRef2().getIndex1(), Field.Store.YES));
            }
            if (pm.getUseTemplate() != null) {
                useful = true;
                d.add((IndexableField)new LongField(POST_USETEMPLATE0, pm.getUseTemplate().getIndex0(), Field.Store.NO));
                d.add((IndexableField)new LongField(POST_USETEMPLATE1, pm.getUseTemplate().getIndex1(), Field.Store.NO));
            }
            if (useful) {
                d.add((IndexableField)new LongField(POST_PEERRANK, lp.getPeerRank(), Field.Store.NO));
                d.add((IndexableField)new LongField(POST_POSTNUM, lp.getPost().getPostNumber(), Field.Store.NO));
                d.add((IndexableField)new LongField(POST_PEERID0, lp.getPost().getSignedDigest().getPeerIdentifier().getIndex0(), Field.Store.NO));
                d.add((IndexableField)new LongField(POST_PEERID1, lp.getPost().getSignedDigest().getPeerIdentifier().getIndex1(), Field.Store.NO));
                d.add((IndexableField)new LongField(POST_DATE, lp.getLocalDate().getTime(), Field.Store.NO));
                d.add((IndexableField)new LongField(POST_NETID0, lp.getPost().getNetworkId().getIndex0(), Field.Store.NO));
                d.add((IndexableField)new LongField(POST_NETID1, lp.getPost().getNetworkId().getIndex1(), Field.Store.NO));
                d.add((IndexableField)new LongField(POST_NUM0, pm.getNum0(), Field.Store.NO));
                d.add((IndexableField)new LongField(POST_NUM1, pm.getNum1(), Field.Store.NO));
                d.add((IndexableField)new LongField(POST_NUM2, pm.getNum2(), Field.Store.NO));
                d.add((IndexableField)new LongField(POST_NUM3, pm.getNum3(), Field.Store.NO));
                d.add((IndexableField)new LongField(POST_NUM4, pm.getNum4(), Field.Store.NO));
                d.add((IndexableField)new LongField(POST_NUM5, pm.getNum5(), Field.Store.NO));
                d.add((IndexableField)new LongField(POST_NUM6, pm.getNum6(), Field.Store.NO));
                d.add((IndexableField)new LongField(POST_NUM7, pm.getNum7(), Field.Store.NO));
                d.add((IndexableField)new LongField(POST_NUM8, pm.getNum8(), Field.Store.NO));
                d.add((IndexableField)new LongField(POST_NUM9, pm.getNum9(), Field.Store.NO));
                d.add((IndexableField)new DoubleField(POST_DOUBLE0, pm.getDouble0(), Field.Store.NO));
                d.add((IndexableField)new DoubleField(POST_DOUBLE1, pm.getDouble1(), Field.Store.NO));
                d.add((IndexableField)new DoubleField(POST_DOUBLE2, pm.getDouble2(), Field.Store.NO));
                d.add((IndexableField)new DoubleField(POST_DOUBLE3, pm.getDouble3(), Field.Store.NO));
                d.add((IndexableField)new DoubleField(POST_DOUBLE4, pm.getDouble4(), Field.Store.NO));
                d.add((IndexableField)new DoubleField(POST_DOUBLE5, pm.getDouble5(), Field.Store.NO));
                d.add((IndexableField)new DoubleField(POST_DOUBLE6, pm.getDouble6(), Field.Store.NO));
                d.add((IndexableField)new DoubleField(POST_DOUBLE7, pm.getDouble7(), Field.Store.NO));
                d.add((IndexableField)new DoubleField(POST_DOUBLE8, pm.getDouble8(), Field.Store.NO));
                d.add((IndexableField)new DoubleField(POST_DOUBLE9, pm.getDouble9(), Field.Store.NO));
                d.add((IndexableField)new StringField(POST_BOOL0, pm.isBool0() ? "1" : "0", Field.Store.NO));
                d.add((IndexableField)new StringField(POST_BOOL1, pm.isBool1() ? "1" : "0", Field.Store.NO));
                d.add((IndexableField)new StringField(POST_BOOL2, pm.isBool2() ? "1" : "0", Field.Store.NO));
                d.add((IndexableField)new StringField(POST_BOOL3, pm.isBool3() ? "1" : "0", Field.Store.NO));
                d.add((IndexableField)new StringField(POST_BOOL4, pm.isBool4() ? "1" : "0", Field.Store.NO));
                d.add((IndexableField)new StringField(POST_BOOL5, pm.isBool5() ? "1" : "0", Field.Store.NO));
                d.add((IndexableField)new StringField(POST_BOOL6, pm.isBool6() ? "1" : "0", Field.Store.NO));
                d.add((IndexableField)new StringField(POST_BOOL7, pm.isBool7() ? "1" : "0", Field.Store.NO));
                d.add((IndexableField)new StringField(POST_BOOL8, pm.isBool8() ? "1" : "0", Field.Store.NO));
                d.add((IndexableField)new StringField(POST_BOOL9, pm.isBool9() ? "1" : "0", Field.Store.NO));
                d.add((IndexableField)new StringField(POST_TEMP, pm.isTemplate() ? "1" : "0", Field.Store.NO));
                d.add((IndexableField)new LongField(POST_ID0, p.getSignedDigest().getDigest().getIndex0(), this.PostIdType));
                d.add((IndexableField)new LongField(POST_ID1, p.getSignedDigest().getDigest().getIndex1(), this.PostIdType));
                try {
                    IndexWriter indexWriter = this.Indexer;
                    synchronized (indexWriter) {
                        if (update) {
                            this.deletePostFromIndex(lp);
                        }
                        this.Indexer.addDocument((Iterable)d);
                        this.PendingIndex = true;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void savePeerHasFile(PeerHasFile ph) {
        this.DB.store((Object)ph);
    }

    @Override
    public PeerHasFile getPeerHasFile(BBytes networkid, BBytes peerid, BBytes dig) {
        Query q = this.DB.query();
        q.constrain(PeerHasFile.class);
        Constraint i0 = q.descend("PeerId").descend("Index0").constrain((Object)peerid.getIndex0());
        Constraint i1 = q.descend("PeerId").descend("Index1").constrain((Object)peerid.getIndex1());
        Constraint i2 = q.descend("PeerId").descend("Index2").constrain((Object)peerid.getIndex2());
        Constraint i3 = q.descend("PeerId").descend("Index3").constrain((Object)peerid.getIndex3());
        Constraint n0 = q.descend("NetworkId").descend("Index0").constrain((Object)networkid.getIndex0());
        Constraint n1 = q.descend("NetworkId").descend("Index1").constrain((Object)networkid.getIndex1());
        Constraint n2 = q.descend("NetworkId").descend("Index2").constrain((Object)networkid.getIndex2());
        Constraint n3 = q.descend("NetworkId").descend("Index3").constrain((Object)networkid.getIndex3());
        Constraint d0 = q.descend("Digest").descend("Index0").constrain((Object)dig.getIndex0());
        Constraint d1 = q.descend("Digest").descend("Index1").constrain((Object)dig.getIndex1());
        Constraint d2 = q.descend("Digest").descend("Index2").constrain((Object)dig.getIndex2());
        q.descend("Digest").descend("Index3").constrain((Object)dig.getIndex3()).and(d0).and(d1).and(d2).and(n0).and(n1).and(n2).and(n3).and(i0).and(i1).and(i2).and(i3);
        ObjectSet osa = q.execute();
        if (osa.size() > 0) {
            return (PeerHasFile)osa.get(0);
        }
        return null;
    }

    @Override
    public List<PeerHasFile> getPeersHaveFile(BBytes networkid, BBytes dig) {
        Query q = this.DB.query();
        q.constrain(PeerHasFile.class);
        Constraint n0 = q.descend("NetworkId").descend("Index0").constrain((Object)networkid.getIndex0());
        Constraint n1 = q.descend("NetworkId").descend("Index1").constrain((Object)networkid.getIndex1());
        Constraint n2 = q.descend("NetworkId").descend("Index2").constrain((Object)networkid.getIndex2());
        Constraint n3 = q.descend("NetworkId").descend("Index3").constrain((Object)networkid.getIndex3());
        Constraint d0 = q.descend("Digest").descend("Index0").constrain((Object)dig.getIndex0());
        Constraint d1 = q.descend("Digest").descend("Index1").constrain((Object)dig.getIndex1());
        Constraint d2 = q.descend("Digest").descend("Index2").constrain((Object)dig.getIndex2());
        q.descend("Digest").descend("Index3").constrain((Object)dig.getIndex3()).and(d0).and(d1).and(d2).and(n0).and(n1).and(n2).and(n3);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public List<LocalNetworkAuthorization> getOrderedMostFilesMostPostsLastDate(BBytes networkid, Date lastupdate) {
        try {
            Query q = this.DB.query();
            q.constrain(LocalNetworkAuthorization.class);
            Constraint dc = q.descend("LastNewFile").constrain((Object)lastupdate).greater().equal();
            Constraint n0 = q.descend("NetworkAuthorization").descend("NetworkId").descend("Index0").constrain((Object)networkid.getIndex0());
            Constraint n1 = q.descend("NetworkAuthorization").descend("NetworkId").descend("Index1").constrain((Object)networkid.getIndex1());
            Constraint n2 = q.descend("NetworkAuthorization").descend("NetworkId").descend("Index2").constrain((Object)networkid.getIndex2());
            q.descend("NetworkAuthorization").descend("NetworkId").descend("Index3").constrain((Object)networkid.getIndex3()).and(n0).and(n1).and(n2).and(dc);
            q.descend("NumberOfFiles").orderDescending();
            q.descend("NumberOfNewPosts").orderDescending();
            ObjectSet osa = q.execute();
            return osa;
        }
        catch (Exception exception) {
            return new LinkedList<LocalNetworkAuthorization>();
        }
    }

    @Override
    public List<LocalNetworkAuthorization> getOrderedMostPostsLastDate(BBytes networkid, Date lastupdate) {
        try {
            Query q = this.DB.query();
            q.constrain(LocalNetworkAuthorization.class);
            Constraint dc = q.descend("LastNewPost").constrain((Object)lastupdate).greater().equal();
            Constraint n0 = q.descend("NetworkAuthorization").descend("NetworkId").descend("Index0").constrain((Object)networkid.getIndex0());
            Constraint n1 = q.descend("NetworkAuthorization").descend("NetworkId").descend("Index1").constrain((Object)networkid.getIndex1());
            Constraint n2 = q.descend("NetworkAuthorization").descend("NetworkId").descend("Index2").constrain((Object)networkid.getIndex2());
            q.descend("NetworkAuthorization").descend("NetworkId").descend("Index3").constrain((Object)networkid.getIndex3()).and(n0).and(n1).and(n2).and(dc);
            q.descend("NumberOfNewPosts").orderDescending();
            ObjectSet osa = q.execute();
            return osa;
        }
        catch (Exception exception) {
            return new LinkedList<LocalNetworkAuthorization>();
        }
    }

    @Override
    public List<LocalPeer> getOrderedMostNetworksLastDate(Date lastupdate) {
        try {
            Query q = this.DB.query();
            q.constrain(LocalPeer.class);
            q.descend("LastNewNetwork").constrain((Object)lastupdate).greater().equal();
            q.descend("NumberOfNewNetworks").orderDescending();
            ObjectSet osa = q.execute();
            return osa;
        }
        catch (Exception exception) {
            return new LinkedList<LocalPeer>();
        }
    }

    @Override
    public List<LocalPeer> getOrderedMostPublicPostsLastDate(Date lastupdate) {
        try {
            Query q = this.DB.query();
            q.constrain(LocalPeer.class);
            q.descend("LastNewPublicPost").constrain((Object)lastupdate).greater().equal();
            q.descend("NumberOfNewPublicPosts").orderDescending();
            ObjectSet osa = q.execute();
            return osa;
        }
        catch (Exception exception) {
            return new LinkedList<LocalPeer>();
        }
    }

    @Override
    public List<LocalPeer> getOrderedMostPeersLastDate(Date lastupdate) {
        try {
            Query q = this.DB.query();
            q.constrain(LocalPeer.class);
            q.descend("LastNewPeer").constrain((Object)lastupdate).greater().equal();
            q.descend("NumberOfNewPeers").orderDescending();
            ObjectSet osa = q.execute();
            return osa;
        }
        catch (Exception exception) {
            return new LinkedList<LocalPeer>();
        }
    }

    @Override
    public void saveMyPeerData(MyPeerDataSO mp) {
        MyPeerDataSO os = this.getMyPeerData();
        this.DB.store((Object)mp);
        this.indexPeer(mp.getPeer(), os != null);
    }

    @Override
    public MyPeerDataSO getMyPeerData() {
        Query q = this.DB.query();
        q.constrain(MyPeerDataSO.class);
        ObjectSet osa = q.execute();
        if (osa.size() > 0) {
            return (MyPeerDataSO)osa.get(0);
        }
        return null;
    }

    @Override
    public List<FileReference> getFiles(BBytes network, BBytes digest) {
        Query q = this.DB.query();
        q.constrain(FileReference.class);
        Constraint n0 = q.descend("NetworkId").descend("Index0").constrain((Object)network.getIndex0());
        Constraint n1 = q.descend("NetworkId").descend("Index1").constrain((Object)network.getIndex1());
        Constraint n2 = q.descend("NetworkId").descend("Index2").constrain((Object)network.getIndex2());
        Constraint n3 = q.descend("NetworkId").descend("Index3").constrain((Object)network.getIndex3());
        Constraint d0 = q.descend("UnsignedDigest").descend("Index0").constrain((Object)digest.getIndex0());
        Constraint d1 = q.descend("UnsignedDigest").descend("Index1").constrain((Object)digest.getIndex1());
        Constraint d2 = q.descend("UnsignedDigest").descend("Index2").constrain((Object)digest.getIndex2());
        q.descend("UnsignedDigest").descend("Index3").constrain((Object)digest.getIndex3()).and(n0).and(n1).and(n2).and(n3).and(d0).and(d1).and(d2);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public FileReference getFile(BBytes network, BBytes digest, File f, long offset, long size) {
        Query q = this.DB.query();
        q.constrain(FileReference.class);
        Constraint n0 = q.descend("NetworkId").descend("Index0").constrain((Object)network.getIndex0());
        Constraint n1 = q.descend("NetworkId").descend("Index1").constrain((Object)network.getIndex1());
        Constraint n2 = q.descend("NetworkId").descend("Index2").constrain((Object)network.getIndex2());
        Constraint n3 = q.descend("NetworkId").descend("Index3").constrain((Object)network.getIndex3());
        Constraint d0 = q.descend("UnsignedDigest").descend("Index0").constrain((Object)digest.getIndex0());
        Constraint d1 = q.descend("UnsignedDigest").descend("Index1").constrain((Object)digest.getIndex1());
        Constraint d2 = q.descend("UnsignedDigest").descend("Index2").constrain((Object)digest.getIndex2());
        Constraint d3 = q.descend("UnsignedDigest").descend("Index3").constrain((Object)digest.getIndex3());
        Constraint f0 = q.descend("File").constrain((Object)f).byExample();
        Constraint o0 = q.descend("Offset").constrain((Object)offset);
        q.descend("Size").constrain((Object)size).and(n0).and(n1).and(n2).and(n3).and(d0).and(d1).and(d2).and(d3).and(f0).and(o0);
        ObjectSet osa = q.execute();
        if (osa.size() > 0) {
            return (FileReference)osa.get(0);
        }
        return null;
    }

    @Override
    public List<FileReference> getFilesRequested(BBytes digest) {
        Query q = this.DB.query();
        q.constrain(FileReference.class);
        Constraint rs = q.descend("UserRequested").constrain((Object)true);
        Constraint d0 = q.descend("UnsignedDigest").descend("Index0").constrain((Object)digest.getIndex0());
        Constraint d1 = q.descend("UnsignedDigest").descend("Index1").constrain((Object)digest.getIndex1());
        Constraint d2 = q.descend("UnsignedDigest").descend("Index2").constrain((Object)digest.getIndex2());
        q.descend("UnsignedDigest").descend("Index3").constrain((Object)digest.getIndex3()).and(d0).and(d1).and(d2).and(rs);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public List<FileReference> getFilesForFile(File f) {
        Query q = this.DB.query();
        q.constrain(FileReference.class);
        q.descend("File").constrain((Object)f).byExample();
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public void saveFileReference(FileReference fr) {
        this.DB.store((Object)fr);
    }

    @Override
    public List<FileReference> getOrderedFilesRequestedNotDispatched() {
        try {
            Query q = this.DB.query();
            q.constrain(FileReference.class);
            Constraint ur = q.descend("UserRequested").constrain((Object)true);
            q.descend("UserRequestDispatched").constrain((Object)false).and(ur);
            q.descend("UserRequestPriority").orderDescending();
            q.descend("UserRequestTime").orderAscending();
            ObjectSet osa = q.execute();
            return osa;
        }
        catch (Exception exception) {
            return new LinkedList<FileReference>();
        }
    }

    @Override
    public LocalPost getPost(BBytes networkid, BBytes peerid, long pid) {
        Query q = this.DB.query();
        q.constrain(LocalPost.class);
        Constraint i0 = q.descend("Post").descend("SignedDigest").descend("PeerIdentifier").descend("Index0").constrain((Object)peerid.getIndex0());
        Constraint i1 = q.descend("Post").descend("SignedDigest").descend("PeerIdentifier").descend("Index1").constrain((Object)peerid.getIndex1());
        Constraint i2 = q.descend("Post").descend("SignedDigest").descend("PeerIdentifier").descend("Index2").constrain((Object)peerid.getIndex2());
        Constraint i3 = q.descend("Post").descend("SignedDigest").descend("PeerIdentifier").descend("Index3").constrain((Object)peerid.getIndex3());
        Constraint n0 = q.descend("Post").descend("NetworkId").descend("Index0").constrain((Object)networkid.getIndex0());
        Constraint n1 = q.descend("Post").descend("NetworkId").descend("Index1").constrain((Object)networkid.getIndex1());
        Constraint n2 = q.descend("Post").descend("NetworkId").descend("Index2").constrain((Object)networkid.getIndex2());
        Constraint n3 = q.descend("Post").descend("NetworkId").descend("Index3").constrain((Object)networkid.getIndex3());
        q.descend("Post").descend("PostNumber").constrain((Object)pid).and(i0).and(i1).and(i2).and(i3).and(n0).and(n1).and(n2).and(n3);
        ObjectSet osa = q.execute();
        if (osa.size() > 0) {
            return (LocalPost)osa.get(0);
        }
        return null;
    }

    @Override
    public List<LocalPeer> getNextPeerPush() {
        Query q = this.DB.query();
        q.constrain(LocalPeer.class);
        q.descend("PushRequested").constrain((Object)true);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public List<LocalNetwork> getNextNetworkPush() {
        Query q = this.DB.query();
        q.constrain(LocalNetwork.class);
        q.descend("PushRequested").constrain((Object)true);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public List<LocalPublicPost> getNextPublicPostPush() {
        Query q = this.DB.query();
        q.constrain(LocalPublicPost.class);
        q.descend("PushRequested").constrain((Object)true);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public List<LocalNetworkAuthorization> getNextNetworkAuthPush(BBytes networkid) {
        Query q = this.DB.query();
        q.constrain(LocalNetworkAuthorization.class);
        Constraint n0 = q.descend("NetworkAuthorization").descend("NetworkId").descend("Index0").constrain((Object)networkid.getIndex0());
        Constraint n1 = q.descend("NetworkAuthorization").descend("NetworkId").descend("Index1").constrain((Object)networkid.getIndex1());
        Constraint n2 = q.descend("NetworkAuthorization").descend("NetworkId").descend("Index2").constrain((Object)networkid.getIndex2());
        Constraint n3 = q.descend("NetworkAuthorization").descend("NetworkId").descend("Index3").constrain((Object)networkid.getIndex3());
        q.descend("PushRequested").constrain((Object)true).and(n0).and(n1).and(n2).and(n3);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public List<LocalPost> getNextPostPush(BBytes networkid) {
        Query q = this.DB.query();
        q.constrain(LocalPost.class);
        Constraint n0 = q.descend("Post").descend("NetworkId").descend("Index0").constrain((Object)networkid.getIndex0());
        Constraint n1 = q.descend("Post").descend("NetworkId").descend("Index1").constrain((Object)networkid.getIndex1());
        Constraint n2 = q.descend("Post").descend("NetworkId").descend("Index2").constrain((Object)networkid.getIndex2());
        Constraint n3 = q.descend("Post").descend("NetworkId").descend("Index3").constrain((Object)networkid.getIndex3());
        q.descend("PushRequested").constrain((Object)true).and(n0).and(n1).and(n2).and(n3);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public LocalPeer getPeer(BBytes id) {
        Query q = this.DB.query();
        q.constrain(LocalPeer.class);
        Constraint p0 = q.descend("Peer").descend("Identity").descend("Index0").constrain((Object)id.getIndex0());
        Constraint p1 = q.descend("Peer").descend("Identity").descend("Index1").constrain((Object)id.getIndex1());
        Constraint p2 = q.descend("Peer").descend("Identity").descend("Index2").constrain((Object)id.getIndex2());
        q.descend("Peer").descend("Identity").descend("Index3").constrain((Object)id.getIndex3()).and(p0).and(p1).and(p2);
        ObjectSet osa = q.execute();
        if (osa.size() > 0) {
            return (LocalPeer)osa.get(0);
        }
        return null;
    }

    @Override
    public List<LocalPeer> getLocalPeers() {
        Query q = this.DB.query();
        q.constrain(LocalPeer.class);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public List<Peer> getPeers() {
        Query q = this.DB.query();
        q.constrain(Peer.class);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public void saveLocalPeer(LocalPeer lp) {
        LocalPeer op = this.getPeer(lp.getPeer().getIdentity());
        Log.info("Do peer update: " + (op != null));
        this.indexPeer(lp, op != null);
        this.DB.store((Object)lp);
    }

    @Override
    public LocalPeer getHighestPriorityNeteworkRequest() {
        try {
            Query q = this.DB.query();
            q.constrain(LocalPeer.class);
            Constraint r = q.descend("RequestNetworks").constrain((Object)true);
            q.descend("RequestNetworksDispatched").constrain((Object)false).and(r);
            q.descend("RequestNetworksPriority").orderDescending();
            q.descend("RequestNetworksTime").orderAscending();
            ObjectSet osa = q.execute();
            if (osa.size() > 0) {
                return (LocalPeer)osa.get(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public List<NetworkHoles> getPeerNetworkHoles(BBytes id) {
        Query q = this.DB.query();
        q.constrain(NetworkHoles.class);
        Constraint p0 = q.descend("PeerId").descend("Index0").constrain((Object)id.getIndex0());
        Constraint p1 = q.descend("PeerId").descend("Index1").constrain((Object)id.getIndex1());
        Constraint p2 = q.descend("PeerId").descend("Index2").constrain((Object)id.getIndex2());
        q.descend("PeerId").descend("Index3").constrain((Object)id.getIndex3()).and(p0).and(p1).and(p2);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public void saveNetworkHoles(NetworkHoles nh) {
        this.DB.store((Object)nh);
    }

    @Override
    public void deleteNetworkHoles(NetworkHoles nh) {
        this.DB.delete((Object)nh);
    }

    @Override
    public LocalPeer getHighestPriorityPublicPostRequest() {
        try {
            Query q = this.DB.query();
            q.constrain(LocalPeer.class);
            Constraint r = q.descend("RequestPublicPosts").constrain((Object)true);
            q.descend("RequestPublicPostsDispatched").constrain((Object)false).and(r);
            q.descend("RequestPublicPostsPriority").orderDescending();
            q.descend("RequestPublicPostsTime").orderAscending();
            ObjectSet osa = q.execute();
            if (osa.size() > 0) {
                return (LocalPeer)osa.get(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public List<PublicPostHoles> getPublicPostHoles(BBytes id) {
        Query q = this.DB.query();
        q.constrain(PublicPostHoles.class);
        Constraint p0 = q.descend("PeerId").descend("Index0").constrain((Object)id.getIndex0());
        Constraint p1 = q.descend("PeerId").descend("Index1").constrain((Object)id.getIndex1());
        Constraint p2 = q.descend("PeerId").descend("Index2").constrain((Object)id.getIndex2());
        q.descend("PeerId").descend("Index3").constrain((Object)id.getIndex3()).and(p0).and(p1).and(p2);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public void savePublicPostHoles(PublicPostHoles pph) {
        this.DB.store((Object)pph);
    }

    @Override
    public void deletePublicPostHoles(PublicPostHoles pph) {
        this.DB.delete((Object)pph);
    }

    @Override
    public LocalPublicPost getLocalPublicPost(BBytes peerid, long postid) {
        Query q = this.DB.query();
        q.constrain(LocalPublicPost.class);
        Constraint i0 = q.descend("PublicPost").descend("Signature").descend("PeerIdentifier").descend("Index0").constrain((Object)peerid.getIndex0());
        Constraint i1 = q.descend("PublicPost").descend("Signature").descend("PeerIdentifier").descend("Index1").constrain((Object)peerid.getIndex1());
        Constraint i2 = q.descend("PublicPost").descend("Signature").descend("PeerIdentifier").descend("Index2").constrain((Object)peerid.getIndex2());
        Constraint i3 = q.descend("PublicPost").descend("Signature").descend("PeerIdentifier").descend("Index3").constrain((Object)peerid.getIndex3());
        q.descend("PublicPost").descend("PostNumber").constrain((Object)postid).and(i0).and(i1).and(i2).and(i3);
        ObjectSet osa = q.execute();
        if (osa.size() > 0) {
            return (LocalPublicPost)osa.get(0);
        }
        return null;
    }

    @Override
    public LocalPeer getHighestPriorityPeerRequest() {
        try {
            Query q = this.DB.query();
            q.constrain(LocalPeer.class);
            q.descend("RequestPeers").constrain((Object)true);
            q.descend("RequestPeersPriority").orderDescending();
            q.descend("RequestPeersTime").orderAscending();
            ObjectSet osa = q.execute();
            if (osa.size() > 0) {
                return (LocalPeer)osa.get(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public LocalNetworkAuthorization getNetworkAuth(BBytes networkid, BBytes peerid) {
        Query q = this.DB.query();
        q.constrain(LocalNetworkAuthorization.class);
        Constraint n0 = q.descend("NetworkAuthorization").descend("NetworkId").descend("Index0").constrain((Object)networkid.getIndex0());
        Constraint n1 = q.descend("NetworkAuthorization").descend("NetworkId").descend("Index1").constrain((Object)networkid.getIndex1());
        Constraint n2 = q.descend("NetworkAuthorization").descend("NetworkId").descend("Index2").constrain((Object)networkid.getIndex2());
        Constraint n3 = q.descend("NetworkAuthorization").descend("NetworkId").descend("Index3").constrain((Object)networkid.getIndex3());
        Constraint i0 = q.descend("NetworkAuthorization").descend("PeerId").descend("Index0").constrain((Object)peerid.getIndex0());
        Constraint i1 = q.descend("NetworkAuthorization").descend("PeerId").descend("Index1").constrain((Object)peerid.getIndex1());
        Constraint i2 = q.descend("NetworkAuthorization").descend("PeerId").descend("Index2").constrain((Object)peerid.getIndex2());
        q.descend("NetworkAuthorization").descend("PeerId").descend("Index3").constrain((Object)peerid.getIndex3()).and(n0).and(n1).and(n2).and(n3).and(i0).and(i1).and(i2);
        ObjectSet osa = q.execute();
        if (osa.size() > 0) {
            return (LocalNetworkAuthorization)osa.get(0);
        }
        return null;
    }

    @Override
    public List<LocalNetworkAuthorization> getNetworkAuths(BBytes networkid) {
        Query q = this.DB.query();
        q.constrain(LocalNetworkAuthorization.class);
        Constraint n0 = q.descend("NetworkAuthorization").descend("NetworkId").descend("Index0").constrain((Object)networkid.getIndex0());
        Constraint n1 = q.descend("NetworkAuthorization").descend("NetworkId").descend("Index1").constrain((Object)networkid.getIndex1());
        Constraint n2 = q.descend("NetworkAuthorization").descend("NetworkId").descend("Index2").constrain((Object)networkid.getIndex2());
        q.descend("NetworkAuthorization").descend("NetworkId").descend("Index3").constrain((Object)networkid.getIndex3()).and(n0).and(n1).and(n2);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public List<LocalNetworkAuthorization> getPeerNetworkAuths(BBytes peerid) {
        Query q = this.DB.query();
        q.constrain(LocalNetworkAuthorization.class);
        Constraint n0 = q.descend("NetworkAuthorization").descend("PeerId").descend("Index0").constrain((Object)peerid.getIndex0());
        Constraint n1 = q.descend("NetworkAuthorization").descend("PeerId").descend("Index1").constrain((Object)peerid.getIndex1());
        Constraint n2 = q.descend("NetworkAuthorization").descend("PeerId").descend("Index2").constrain((Object)peerid.getIndex2());
        q.descend("NetworkAuthorization").descend("PeerId").descend("Index3").constrain((Object)peerid.getIndex3()).and(n0).and(n1).and(n2);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public List<LocalNetworkAuthorization> getNetworkAuthsSignedBy(BBytes networkid, BBytes peerid) {
        Query q = this.DB.query();
        q.constrain(LocalNetworkAuthorization.class);
        Constraint n0 = q.descend("NetworkAuthorization").descend("NetworkId").descend("Index0").constrain((Object)networkid.getIndex0());
        Constraint n1 = q.descend("NetworkAuthorization").descend("NetworkId").descend("Index1").constrain((Object)networkid.getIndex1());
        Constraint n2 = q.descend("NetworkAuthorization").descend("NetworkId").descend("Index2").constrain((Object)networkid.getIndex2());
        Constraint n3 = q.descend("NetworkAuthorization").descend("NetworkId").descend("Index3").constrain((Object)networkid.getIndex3());
        Constraint p0 = q.descend("NetworkAuthorization").descend("Signature").descend("PeerIdentifier").descend("Index0").constrain((Object)peerid.getIndex0());
        Constraint p1 = q.descend("NetworkAuthorization").descend("Signature").descend("PeerIdentifier").descend("Index1").constrain((Object)peerid.getIndex1());
        Constraint p2 = q.descend("NetworkAuthorization").descend("Signature").descend("PeerIdentifier").descend("Index2").constrain((Object)peerid.getIndex2());
        q.descend("NetworkAuthorization").descend("Signature").descend("PeerIdentifier").descend("Index3").constrain((Object)peerid.getIndex3()).and(n0).and(n1).and(n2).and(n3).and(p0).and(p1).and(p2);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public void saveLocalNetworkAuth(LocalNetworkAuthorization auth) {
        this.DB.store((Object)auth);
    }

    @Override
    public List<LocalNetworkAuthorization> getOrderedNetworkAuthsRequestedNotDispatched() {
        try {
            Query q = this.DB.query();
            q.constrain(LocalNetworkAuthorization.class);
            Constraint r = q.descend("RequestAuths").constrain((Object)true);
            q.descend("RequestAuthsDispatched").constrain((Object)false).and(r);
            q.descend("RequestAuthsPriority").orderDescending();
            q.descend("RequestAuthsTime").orderAscending();
            ObjectSet osa = q.execute();
            return osa;
        }
        catch (Exception exception) {
            return new LinkedList<LocalNetworkAuthorization>();
        }
    }

    @Override
    public void saveNetworkAuthHoles(NetworkAuthHoles h) {
        this.DB.store((Object)h);
    }

    @Override
    public void deleteNetworkAuthHoles(NetworkAuthHoles h) {
        this.DB.delete((Object)h);
    }

    @Override
    public List<NetworkAuthHoles> getPeerNetworkAuthHoles(BBytes networkid, BBytes peerid) {
        Query q = this.DB.query();
        q.constrain(NetworkAuthHoles.class);
        Constraint n0 = q.descend("NetworkId").descend("Index0").constrain((Object)networkid.getIndex0());
        Constraint n1 = q.descend("NetworkId").descend("Index1").constrain((Object)networkid.getIndex1());
        Constraint n2 = q.descend("NetworkId").descend("Index2").constrain((Object)networkid.getIndex2());
        Constraint n3 = q.descend("NetworkId").descend("Index3").constrain((Object)networkid.getIndex3());
        Constraint i0 = q.descend("PeerId").descend("Index0").constrain((Object)peerid.getIndex0());
        Constraint i1 = q.descend("PeerId").descend("Index1").constrain((Object)peerid.getIndex1());
        Constraint i2 = q.descend("PeerId").descend("Index2").constrain((Object)peerid.getIndex2());
        q.descend("PeerId").descend("Index3").constrain((Object)peerid.getIndex3()).and(n0).and(n1).and(n2).and(n3).and(i0).and(i1).and(i2);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public List<LocalNetworkAuthorization> getOrderedPostsRequestedNotDispatched() {
        try {
            Query q = this.DB.query();
            q.constrain(LocalNetworkAuthorization.class);
            Constraint r = q.descend("RequestPosts").constrain((Object)true);
            q.descend("RequestPostsDispatched").constrain((Object)false).and(r);
            q.descend("RequestPostsPriority").orderDescending();
            q.descend("RequestPostsTime").orderAscending();
            ObjectSet osa = q.execute();
            return osa;
        }
        catch (Exception exception) {
            return new LinkedList<LocalNetworkAuthorization>();
        }
    }

    @Override
    public void savePostHoles(PostHoles ph) {
        this.DB.store((Object)ph);
    }

    @Override
    public void deletePostHoles(PostHoles h) {
        this.DB.delete((Object)h);
    }

    @Override
    public List<PostHoles> getPostHoles(BBytes networkid, BBytes peerid) {
        Query q = this.DB.query();
        q.constrain(PostHoles.class);
        Constraint n0 = q.descend("NetworkId").descend("Index0").constrain((Object)networkid.getIndex0());
        Constraint n1 = q.descend("NetworkId").descend("Index1").constrain((Object)networkid.getIndex1());
        Constraint n2 = q.descend("NetworkId").descend("Index2").constrain((Object)networkid.getIndex2());
        Constraint n3 = q.descend("NetworkId").descend("Index3").constrain((Object)networkid.getIndex3());
        Constraint i0 = q.descend("PeerId").descend("Index0").constrain((Object)peerid.getIndex0());
        Constraint i1 = q.descend("PeerId").descend("Index1").constrain((Object)peerid.getIndex1());
        Constraint i2 = q.descend("PeerId").descend("Index2").constrain((Object)peerid.getIndex2());
        q.descend("PeerId").descend("Index3").constrain((Object)peerid.getIndex3()).and(n0).and(n1).and(n2).and(n3).and(i0).and(i1).and(i2);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public List<Network> getNetworks(BBytes peerid, long fromnum, long tonum) {
        Query q = this.DB.query();
        q.constrain(Network.class);
        Constraint p0 = q.descend("Signature").descend("PeerIdentifier").descend("Index0").constrain((Object)peerid.getIndex0());
        Constraint p1 = q.descend("Signature").descend("PeerIdentifier").descend("Index1").constrain((Object)peerid.getIndex1());
        Constraint p2 = q.descend("Signature").descend("PeerIdentifier").descend("Index2").constrain((Object)peerid.getIndex2());
        Constraint p3 = q.descend("Signature").descend("PeerIdentifier").descend("Index3").constrain((Object)peerid.getIndex3());
        Constraint g0 = q.descend("NetworkNumber").constrain((Object)fromnum).greater().equal();
        q.descend("NetworkNumber").constrain((Object)tonum).smaller().equal().and(p0).and(p1).and(p2).and(p3).and(g0);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public List<PublicPost> getPublicPosts(BBytes peerid, long fromnum, long tonum) {
        Query q = this.DB.query();
        q.constrain(PublicPost.class);
        Constraint p0 = q.descend("Signature").descend("PeerIdentifier").descend("Index0").constrain((Object)peerid.getIndex0());
        Constraint p1 = q.descend("Signature").descend("PeerIdentifier").descend("Index1").constrain((Object)peerid.getIndex1());
        Constraint p2 = q.descend("Signature").descend("PeerIdentifier").descend("Index2").constrain((Object)peerid.getIndex2());
        Constraint p3 = q.descend("Signature").descend("PeerIdentifier").descend("Index3").constrain((Object)peerid.getIndex3());
        Constraint g0 = q.descend("PostNumber").constrain((Object)fromnum).greater().equal();
        q.descend("PostNumber").constrain((Object)tonum).smaller().equal().and(p0).and(p1).and(p2).and(p3).and(g0);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public List<NetworkAuthorization> getNetworkAuthorizations(BBytes peerid, BBytes netid, long fromnum, long tonum) {
        Query q = this.DB.query();
        q.constrain(NetworkAuthorization.class);
        Constraint p0 = q.descend("Signature").descend("PeerIdentifier").descend("Index0").constrain((Object)peerid.getIndex0());
        Constraint p1 = q.descend("Signature").descend("PeerIdentifier").descend("Index1").constrain((Object)peerid.getIndex1());
        Constraint p2 = q.descend("Signature").descend("PeerIdentifier").descend("Index2").constrain((Object)peerid.getIndex2());
        Constraint p3 = q.descend("Signature").descend("PeerIdentifier").descend("Index3").constrain((Object)peerid.getIndex3());
        Constraint n0 = q.descend("NetworkId").descend("Index0").constrain((Object)netid.getIndex0());
        Constraint n1 = q.descend("NetworkId").descend("Index1").constrain((Object)netid.getIndex1());
        Constraint n2 = q.descend("NetworkId").descend("Index2").constrain((Object)netid.getIndex2());
        Constraint n3 = q.descend("NetworkId").descend("Index3").constrain((Object)netid.getIndex3());
        Constraint g0 = q.descend("SignatureNumber").constrain((Object)fromnum).greater().equal();
        q.descend("SignatureNumber").constrain((Object)tonum).smaller().equal().and(p0).and(p1).and(p2).and(p3).and(n0).and(n1).and(n2).and(n3).and(g0);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public List<Post> getPosts(BBytes peerid, BBytes netid, long fromnum, long tonum) {
        Query q = this.DB.query();
        q.constrain(Post.class);
        Constraint p0 = q.descend("SignedDigest").descend("PeerIdentifier").descend("Index0").constrain((Object)peerid.getIndex0());
        Constraint p1 = q.descend("SignedDigest").descend("PeerIdentifier").descend("Index1").constrain((Object)peerid.getIndex1());
        Constraint p2 = q.descend("SignedDigest").descend("PeerIdentifier").descend("Index2").constrain((Object)peerid.getIndex2());
        Constraint p3 = q.descend("SignedDigest").descend("PeerIdentifier").descend("Index3").constrain((Object)peerid.getIndex3());
        Constraint n0 = q.descend("NetworkId").descend("Index0").constrain((Object)netid.getIndex0());
        Constraint n1 = q.descend("NetworkId").descend("Index1").constrain((Object)netid.getIndex1());
        Constraint n2 = q.descend("NetworkId").descend("Index2").constrain((Object)netid.getIndex2());
        Constraint n3 = q.descend("NetworkId").descend("Index3").constrain((Object)netid.getIndex3());
        Constraint g0 = q.descend("PostNumber").constrain((Object)fromnum).greater().equal();
        q.descend("PostNumber").constrain((Object)tonum).smaller().equal().and(p0).and(p1).and(p2).and(p3).and(n0).and(n1).and(n2).and(n3).and(g0);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public void saveLocalPost(LocalPost post) {
        LocalPost lp = this.getPost(post.getPost().getNetworkId(), post.getPost().getSignedDigest().getPeerIdentifier(), post.getPost().getPostNumber());
        this.indexPost(post, lp != null);
        this.DB.store((Object)post);
    }

    @Override
    public void saveLocalNetwork(LocalNetwork nw) {
        LocalNetwork t = this.getLocalNetwork(nw.getNetwork().getSignature().getDigest());
        this.indexNetwork(nw, t != null);
        this.DB.store((Object)nw);
    }

    @Override
    public LocalNetwork getLocalNetwork(BBytes id) {
        Query q = this.DB.query();
        q.constrain(LocalNetwork.class);
        Constraint i0 = q.descend("Network").descend("Signature").descend("Digest").descend("Index0").constrain((Object)id.getIndex0());
        Constraint i1 = q.descend("Network").descend("Signature").descend("Digest").descend("Index1").constrain((Object)id.getIndex1());
        Constraint i2 = q.descend("Network").descend("Signature").descend("Digest").descend("Index2").constrain((Object)id.getIndex2());
        q.descend("Network").descend("Signature").descend("Digest").descend("Index3").constrain((Object)id.getIndex3()).and(i0).and(i1).and(i2);
        ObjectSet osa = q.execute();
        if (osa.size() > 0) {
            return (LocalNetwork)osa.get(0);
        }
        return null;
    }

    @Override
    public void saveLocalPublicPost(LocalPublicPost pp) {
        LocalPublicPost lp = this.getLocalPublicPost(pp.getPublicPost().getSignature().getPeerIdentifier(), pp.getPublicPost().getPostNumber());
        if (lp == null) {
            this.indexPublicPost(pp);
        }
        this.DB.store((Object)pp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePost(LocalPost p) {
        this.DB.delete((Object)p);
        IndexWriter indexWriter = this.Indexer;
        synchronized (indexWriter) {
            try {
                this.deletePostFromIndex(p);
                this.PendingIndex = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void deleteReferencelessPosts(Date olderthan) {
        Query q = this.DB.query();
        q.constrain(LocalPost.class);
        Constraint dc = q.descend("LocalDate").constrain((Object)olderthan).smaller();
        q.descend("Post").descend("FileReferenceDigest").constrain(null).and(dc);
        ObjectSet osa = q.execute();
        for (LocalPost lp : osa) {
            this.deletePost(lp);
        }
    }

    @Override
    public void deletePeer(Peer p, boolean poststoo) {
        if (poststoo) {
            Query q = this.DB.query();
            q.constrain(LocalPost.class);
            Constraint i0 = q.descend("Post").descend("SignedDigest").descend("PeerIdentifier").descend("Index0").constrain((Object)p.getIdentity().getIndex0());
            Constraint i1 = q.descend("Post").descend("SignedDigest").descend("PeerIdentifier").descend("Index1").constrain((Object)p.getIdentity().getIndex1());
            Constraint i2 = q.descend("Post").descend("SignedDigest").descend("PeerIdentifier").descend("Index2").constrain((Object)p.getIdentity().getIndex2());
            q.descend("Post").descend("SignedDigest").descend("PeerIdentifier").descend("Index3").constrain((Object)p.getIdentity().getIndex3()).and(i0).and(i1).and(i2);
            ObjectSet osa = q.execute();
            for (LocalPost lp : osa) {
                this.deletePost(lp);
            }
        }
        this.DB.delete((Object)p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePublicPost(LocalPublicPost p) {
        this.DB.delete((Object)p);
        BytesRef bytes = new BytesRef();
        NumericUtils.longToPrefixCoded((long)p.getPublicPost().getSignature().getDigest().getIndex0(), (int)0, (BytesRef)bytes);
        TermQuery id0 = new TermQuery(new Term("ppostid0", bytes));
        BytesRef bytes1 = new BytesRef();
        NumericUtils.longToPrefixCoded((long)p.getPublicPost().getSignature().getDigest().getIndex1(), (int)0, (BytesRef)bytes1);
        TermQuery id1 = new TermQuery(new Term("ppostid1", bytes1));
        BooleanQuery bq = new BooleanQuery();
        bq.add((org.apache.lucene.search.Query)id0, BooleanClause.Occur.MUST);
        bq.add((org.apache.lucene.search.Query)id1, BooleanClause.Occur.MUST);
        IndexWriter indexWriter = this.Indexer;
        synchronized (indexWriter) {
            try {
                this.Indexer.deleteDocuments((org.apache.lucene.search.Query)bq);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void deletePublicPosts(Date olderthan) {
        Query q = this.DB.query();
        q.constrain(LocalPublicPost.class);
        q.descend("LocalDate").constrain((Object)olderthan).smaller();
        ObjectSet osa = q.execute();
        for (LocalPublicPost lp : osa) {
            this.deletePublicPost(lp);
        }
    }

    @Override
    public void saveFileStatus(FileStatus f) {
        this.DB.store((Object)f);
        this.DB.commit();
    }

    @Override
    public List<FileStatus> getFileStatusList() {
        Query q = this.DB.query();
        q.constrain(FileStatus.class);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public FileStatus getFileStatus(File f) {
        Query q = this.DB.query();
        q.constrain(FileStatus.class);
        q.descend("File").constrain((Object)f).byExample();
        ObjectSet osa = q.execute();
        if (osa.size() > 0) {
            return (FileStatus)osa.get(0);
        }
        return null;
    }

    @Override
    public FileStatus getFileStatus(BBytes networkid, BBytes metafiledig) {
        Query q = this.DB.query();
        q.constrain(FileStatus.class);
        Constraint n0 = q.descend("NetworkId").descend("Index0").constrain((Object)networkid.getIndex0());
        Constraint n1 = q.descend("NetworkId").descend("Index1").constrain((Object)networkid.getIndex1());
        Constraint n2 = q.descend("NetworkId").descend("Index2").constrain((Object)networkid.getIndex2());
        Constraint n3 = q.descend("NetworkId").descend("Index3").constrain((Object)networkid.getIndex3());
        Constraint c0 = q.descend("MetaFileDigest").descend("Index0").constrain((Object)metafiledig.getIndex0());
        Constraint c1 = q.descend("MetaFileDigest").descend("Index1").constrain((Object)metafiledig.getIndex1());
        Constraint c2 = q.descend("MetaFileDigest").descend("Index2").constrain((Object)metafiledig.getIndex2());
        q.descend("MetaFileDigest").descend("Index3").constrain((Object)metafiledig.getIndex3()).and(n0).and(n1).and(n2).and(n3).and(c0).and(c1).and(c2);
        ObjectSet osa = q.execute();
        if (osa.size() > 0) {
            return (FileStatus)osa.get(0);
        }
        return null;
    }

    @Override
    public void deleteFileStatus(FileStatus fs) {
        this.DB.delete((Object)fs);
    }

    @Override
    public void saveTemplate(PostTemplate pt) {
        this.DB.store((Object)pt);
    }

    @Override
    public List<PostTemplate> getPostTemplates(BBytes networkid) {
        Query q = this.DB.query();
        q.constrain(PostTemplate.class);
        Constraint c0 = q.descend("NetworkId").descend("Index0").constrain((Object)networkid.getIndex0());
        Constraint c1 = q.descend("NetworkId").descend("Index1").constrain((Object)networkid.getIndex1());
        Constraint c2 = q.descend("NetworkId").descend("Index2").constrain((Object)networkid.getIndex2());
        q.descend("NetworkId").descend("Index3").constrain((Object)networkid.getIndex3()).and(c0).and(c1).and(c2);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public PostTemplate getPostTemplate(BBytes dig) {
        Query q = this.DB.query();
        q.constrain(PostTemplate.class);
        Constraint c0 = q.descend("Digest").descend("Index0").constrain((Object)dig.getIndex0());
        Constraint c1 = q.descend("Digest").descend("Index1").constrain((Object)dig.getIndex1());
        Constraint c2 = q.descend("Digest").descend("Index2").constrain((Object)dig.getIndex2());
        q.descend("Digest").descend("Index3").constrain((Object)dig.getIndex3()).and(c0).and(c1).and(c2);
        ObjectSet osa = q.execute();
        if (osa.size() > 0) {
            return (PostTemplate)osa.get(0);
        }
        return null;
    }

    @Override
    public void saveSearchQuery(SearchQuery s) {
        this.DB.store((Object)s);
    }

    @Override
    public void deleteSearchQuery(SearchQuery s) {
        this.DB.delete((Object)s);
    }

    @Override
    public List<SearchQuery> getSearchQuerys(BBytes networkid) {
        Query q = this.DB.query();
        q.constrain(SearchQuery.class);
        Constraint c0 = q.descend("Network").descend("Index0").constrain((Object)networkid.getIndex0());
        Constraint c1 = q.descend("Network").descend("Index1").constrain((Object)networkid.getIndex1());
        Constraint c2 = q.descend("Network").descend("Index2").constrain((Object)networkid.getIndex2());
        q.descend("Network").descend("Index3").constrain((Object)networkid.getIndex3()).and(c0).and(c1).and(c2);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public List<LocalPost> getPostsReferencingFile(BBytes networkid, BBytes dig) {
        Query q = this.DB.query();
        q.constrain(LocalPost.class);
        Constraint i0 = q.descend("Post").descend("FileReferenceDigest").descend("Index0").constrain((Object)dig.getIndex0());
        Constraint i1 = q.descend("Post").descend("FileReferenceDigest").descend("Index1").constrain((Object)dig.getIndex1());
        Constraint i2 = q.descend("Post").descend("FileReferenceDigest").descend("Index2").constrain((Object)dig.getIndex2());
        Constraint i3 = q.descend("Post").descend("FileReferenceDigest").descend("Index3").constrain((Object)dig.getIndex3());
        Constraint n0 = q.descend("Post").descend("NetworkId").descend("Index0").constrain((Object)networkid.getIndex0());
        Constraint n1 = q.descend("Post").descend("NetworkId").descend("Index1").constrain((Object)networkid.getIndex1());
        Constraint n2 = q.descend("Post").descend("NetworkId").descend("Index2").constrain((Object)networkid.getIndex2());
        q.descend("Post").descend("NetworkId").descend("Index3").constrain((Object)networkid.getIndex3()).and(i0).and(i1).and(i2).and(i3).and(n0).and(n1).and(n2);
        ObjectSet osa = q.execute();
        return osa;
    }

    @Override
    public List<FileReference> getOrderedFilesRequestedAndDispatched() {
        try {
            Query q = this.DB.query();
            q.constrain(FileReference.class);
            Constraint r = q.descend("UserRequested").constrain((Object)true);
            q.descend("UserRequestDispatched").constrain((Object)true).and(r);
            q.descend("UserRequestDispatchTime").orderAscending();
            ObjectSet osa = q.execute();
            return osa;
        }
        catch (Exception exception) {
            return new LinkedList<FileReference>();
        }
    }

    @Override
    public List<LocalPeer> getOrderedPublicPostsRequestedAndDispatched() {
        try {
            Query q = this.DB.query();
            q.constrain(LocalPeer.class);
            Constraint r = q.descend("RequestPublicPosts").constrain((Object)true);
            q.descend("RequestPublicPostsDispatched").constrain((Object)true).and(r);
            q.descend("RequestPublicPostsDispatchedTime").orderAscending();
            ObjectSet osa = q.execute();
            return osa;
        }
        catch (Exception exception) {
            return new LinkedList<LocalPeer>();
        }
    }

    @Override
    public List<LocalPeer> getOrderedNetworksRequestedAndDispatched() {
        try {
            Query q = this.DB.query();
            q.constrain(LocalPeer.class);
            Constraint r = q.descend("RequestNetworks").constrain((Object)true);
            q.descend("RequestNetworksDispatched").constrain((Object)true).and(r);
            q.descend("RequestNetworksDispatchedTime").orderAscending();
            ObjectSet osa = q.execute();
            return osa;
        }
        catch (Exception exception) {
            return new LinkedList<LocalPeer>();
        }
    }

    @Override
    public List<LocalNetworkAuthorization> getOrderedPostsRequestedAndDispatched() {
        try {
            Query q = this.DB.query();
            q.constrain(LocalNetworkAuthorization.class);
            Constraint r = q.descend("RequestPosts").constrain((Object)true);
            q.descend("RequestPostsDispatched").constrain((Object)true).and(r);
            q.descend("RequestPostsDispatchedTime").orderAscending();
            ObjectSet osa = q.execute();
            return osa;
        }
        catch (Exception exception) {
            return new LinkedList<LocalNetworkAuthorization>();
        }
    }

    @Override
    public List<LocalNetworkAuthorization> getOrderedNetworkAuthsRequestedAndDispatched() {
        try {
            Query q = this.DB.query();
            q.constrain(LocalNetworkAuthorization.class);
            Constraint r = q.descend("RequestAuths").constrain((Object)true);
            q.descend("RequestAuthsDispatched").constrain((Object)true).and(r);
            q.descend("RequestAuthsDispatchedTime").orderAscending();
            ObjectSet osa = q.execute();
            return osa;
        }
        catch (Exception exception) {
            return new LinkedList<LocalNetworkAuthorization>();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void dumpPostInfo() {
        q = this.DB.query();
        q.constrain(LocalNetwork.class);
        netos = q.execute();
        q = this.DB.query();
        q.constrain(LocalPeer.class);
        peeros = q.execute();
        q = this.DB.query();
        q.constrain(LocalPost.class);
        allposts = q.execute();
        System.out.println("********************************************************");
        System.out.println("Total all posts: " + allposts.size());
        for (LocalNetwork net : netos) {
            System.out.println("===========================================================");
            System.out.println("NETWORK: " + net.getNetwork().getTitleSig());
            for (LocalPeer peer : peeros) {
                postlst = this.getPosts(peer.getPeer().getIdentity(), net.getNetwork().getSignature().getDigest(), 0L, 0x7FFFFFFFFFFFFFFFL);
                plst = new long[postlst.size()];
                cnt = 0;
                for (Post pst : postlst) {
                    plst[cnt] = pst.getPostNumber();
                    ++cnt;
                }
                Arrays.sort(plst);
                missing = new LinkedList<Long>();
                pnum = 0L;
                cnt = 0;
                ** GOTO lbl38
                {
                    missing.add(pnum);
                    ++pnum;
                    do {
                        if (plst[cnt] > pnum) continue block3;
                        ++pnum;
                        ++cnt;
lbl38:
                        // 2 sources

                    } while (cnt < plst.length);
                }
                System.out.println("----------------------------------------------------------");
                System.out.println("Peer:     " + peer.getPeer().getNickSig());
                if (plst.length > 0) {
                    System.out.println("Min Post: " + plst[0]);
                    System.out.println("Max Post: " + plst[plst.length - 1]);
                    System.out.println("Missing:  ");
                    cnt = 0;
                    while (cnt < missing.size()) {
                        System.out.print(missing.get(cnt));
                        System.out.print(",");
                        ++cnt;
                    }
                    System.out.println();
                } else {
                    System.out.println("No posts.");
                }
                System.out.println("------------------------");
                lph = this.getPostHoles(net.getNetwork().getSignature().getDigest(), peer.getPeer().getIdentity());
                for (PostHoles ph : lph) {
                    System.out.println(String.valueOf(ph.getFirstNumber()) + " - " + ph.getLastNumber());
                }
            }
        }
    }
}

