/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import org.ourfilesystem.core.CoreUserInterface;
import org.ourfilesystem.db.DataBaseCoreInterface;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.TimeInterface;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;

public class Updater
implements Runnable {
    public static long DEFAULT_PERIOD = 28800000L;
    public static int DEFAULT_PRIORITY = 10;
    private CoreUserInterface CoreUser;
    private DataBaseCoreInterface CoreDB;
    private TimeInterface Time;
    private boolean Closed;
    private long PeerUpdatePeriod = DEFAULT_PERIOD;
    private long PostUpdatePeriod = DEFAULT_PERIOD;
    private long NetworkUpdatePeriod = DEFAULT_PERIOD;
    private long PublicPostUpdatePeriod = DEFAULT_PERIOD;
    private long NetworkAuthUpdatePeriod = DEFAULT_PERIOD;
    private long LastPeerUpdate = 0L;
    private long LastPostUpdate = 0L;
    private long LastNetworkUpdate = 0L;
    private long LastPublicPostUpdate = 0L;
    private long LastNetworkAuthUpdate = 0L;

    public Updater(CoreUserInterface core, DataBaseCoreInterface db, TimeInterface time) {
        long curtime;
        this.CoreUser = core;
        this.CoreDB = db;
        this.Time = time;
        this.Closed = false;
        this.LastPeerUpdate = curtime = 0L;
        this.LastPostUpdate = curtime;
        this.LastNetworkUpdate = curtime;
        this.LastPublicPostUpdate = curtime;
        this.LastNetworkAuthUpdate = curtime;
        Thread t = new Thread(this);
        t.start();
    }

    public synchronized void Close() {
        this.Closed = true;
        this.notifyAll();
    }

    public synchronized void updateAllNow() {
        this.LastPeerUpdate = 0L;
        this.LastPostUpdate = 0L;
        this.LastNetworkUpdate = 0L;
        this.LastPublicPostUpdate = 0L;
        this.LastNetworkAuthUpdate = 0L;
        this.notifyAll();
    }

    public synchronized void updatePeersNow() {
        this.LastPeerUpdate = 0L;
        this.notifyAll();
    }

    public synchronized void updatePostsNow() {
        this.LastPostUpdate = 0L;
        this.notifyAll();
    }

    public synchronized void updateNetworksNow() {
        this.LastNetworkUpdate = 0L;
        this.notifyAll();
    }

    public synchronized void updatePublicPostsNow() {
        this.LastPublicPostUpdate = 0L;
        this.notifyAll();
    }

    public synchronized void updateNetworkAuthsNow() {
        this.LastNetworkAuthUpdate = 0L;
        this.notifyAll();
    }

    private void processLoop() {
        long curtime = this.Time.getTime().getTime();
        if (curtime > this.NetworkAuthUpdatePeriod + this.LastNetworkAuthUpdate) {
            this.updateNetworkAuths();
        }
        if (curtime > this.NetworkUpdatePeriod + this.LastNetworkUpdate) {
            this.updateNetworks();
        }
        if (curtime > this.PublicPostUpdatePeriod + this.LastPublicPostUpdate) {
            this.updatePublicPosts();
        }
        if (curtime > this.PostUpdatePeriod + this.LastPostUpdate) {
            this.updatePosts();
        }
        if (curtime > this.PeerUpdatePeriod + this.LastPeerUpdate) {
            this.updatePeers();
        }
    }

    private void updateNetworkAuths() {
        QueryResultsInterface l = this.CoreDB.getDBQuery().queryMyNetworkAuths(null);
        int c = 0;
        while (c < l.size()) {
            LocalNetworkAuthorization a = (LocalNetworkAuthorization)l.get(c);
            this.CoreUser.updateNetworkAuths(a.getNetworkAuthorization().getNetworkId(), DEFAULT_PRIORITY);
            ++c;
        }
        this.LastNetworkAuthUpdate = this.Time.getTime().getTime();
    }

    private void updatePosts() {
        QueryResultsInterface l = this.CoreDB.getDBQuery().queryMyNetworkAuths(null);
        int c = 0;
        while (c < l.size()) {
            LocalNetworkAuthorization a = (LocalNetworkAuthorization)l.get(c);
            this.CoreUser.updatePosts(a.getNetworkAuthorization().getNetworkId(), DEFAULT_PRIORITY);
            ++c;
        }
    }

    private void updatePublicPosts() {
        this.CoreUser.updatePublicPosts(DEFAULT_PRIORITY);
    }

    private void updateNetworks() {
        this.CoreUser.updateNetworks(DEFAULT_PRIORITY);
    }

    private void updatePeers() {
        this.CoreUser.updatePeers(DEFAULT_PRIORITY);
    }

    public long getPeerUpdatePeriod() {
        return this.PeerUpdatePeriod;
    }

    public synchronized void setPeerUpdatePeriod(long peerUpdatePeriod) {
        this.PeerUpdatePeriod = peerUpdatePeriod;
        this.notifyAll();
    }

    public long getPostUpdatePeriod() {
        return this.PostUpdatePeriod;
    }

    public synchronized void setPostUpdatePeriod(long postUpdatePeriod) {
        this.PostUpdatePeriod = postUpdatePeriod;
        this.notifyAll();
    }

    public long getNetworkUpdatePeriod() {
        return this.NetworkUpdatePeriod;
    }

    public synchronized void setNetworkUpdatePeriod(long networkUpdatePeriod) {
        this.NetworkUpdatePeriod = networkUpdatePeriod;
        this.notifyAll();
    }

    public long getPublicPostUpdatePeriod() {
        return this.PublicPostUpdatePeriod;
    }

    public synchronized void setPublicPostUpdatePeriod(long publicPostUpdatePeriod) {
        this.PublicPostUpdatePeriod = publicPostUpdatePeriod;
        this.notifyAll();
    }

    public long getNetworkAuthUpdatePeriod() {
        return this.NetworkAuthUpdatePeriod;
    }

    public synchronized void setNetworkAuthUpdatePeriod(long networkAuthUpdatePeriod) {
        this.NetworkAuthUpdatePeriod = networkAuthUpdatePeriod;
        this.notifyAll();
    }

    public long getLastPeerUpdate() {
        return this.LastPeerUpdate;
    }

    public long getLastPostUpdate() {
        return this.LastPostUpdate;
    }

    public long getLastNetworkUpdate() {
        return this.LastNetworkUpdate;
    }

    public long getLastPublicPostUpdate() {
        return this.LastPublicPostUpdate;
    }

    public long getLastNetworkAuthUpdate() {
        return this.LastNetworkAuthUpdate;
    }

    private synchronized void Wait() {
        long minval = this.PeerUpdatePeriod;
        minval = Math.min(minval, this.PostUpdatePeriod);
        minval = Math.min(minval, this.NetworkUpdatePeriod);
        minval = Math.min(minval, this.PublicPostUpdatePeriod);
        minval = Math.min(minval, this.NetworkAuthUpdatePeriod);
        try {
            this.wait(minval);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (!this.Closed) {
            this.processLoop();
            this.Wait();
        }
    }
}

