/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.db.DataBaseCoreImpl;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalPublicPost;
import org.ourfilesystem.ui.Main;
import org.ourfilesystem.ui.NewPeerMessageDialog;
import org.ourfilesystem.ui.PrivateMessageTableModel;
import org.ourfilesystem.ui.SignDialogs;
import org.ourfilesystem.utilities.BBytes;

public class PrivatePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField textField;
    private JTable table;
    private NewPeerMessageDialog Dialog;
    private PrivateMessageTableModel Model;
    private Main Mn;
    private SignDialogs SignDialogs;

    public PrivatePanel(Main m) {
        this.Mn = m;
        this.Model = new PrivateMessageTableModel();
        this.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOrientation(0);
        this.add((Component)splitPane, "Center");
        JPanel panel = new JPanel();
        splitPane.setLeftComponent(panel);
        panel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][]"));
        JButton btnUpdateMessages = new JButton("Update Messages");
        panel.add((Component)btnUpdateMessages, "flowx,cell 1 0,alignx right");
        btnUpdateMessages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PrivatePanel.this.Mn.getUpdater().updatePublicPostsNow();
            }
        });
        JLabel lblSearch = new JLabel("Search");
        panel.add((Component)lblSearch, "cell 0 1,alignx trailing");
        this.textField = new JTextField();
        panel.add((Component)this.textField, "flowx,cell 1 1,growx");
        this.textField.setColumns(10);
        JButton btnSearch = new JButton("Search");
        panel.add((Component)btnSearch, "cell 1 1");
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String terms = PrivatePanel.this.textField.getText();
                QueryResultsInterface qr = PrivatePanel.this.Mn.getCoreDB().getDBQuery().searchPublicPosts(terms, true, DataBaseCoreImpl.PUBLIC_POST_DATE, 1000, true);
                PrivatePanel.this.Model.setPrivateMessages(qr);
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        splitPane.setRightComponent(scrollPane);
        this.table = new JTable(this.Model);
        this.table.setAutoCreateRowSorter(true);
        this.table.setSelectionMode(0);
        scrollPane.setViewportView(this.table);
        this.SignDialogs = new SignDialogs(this.Mn, this.table);
        JPopupMenu mnu = new JPopupMenu();
        JMenuItem vi = new JMenuItem("View");
        mnu.add(vi);
        vi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PrivatePanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PrivatePanel.this.table.getSelectedRow();
                    r = PrivatePanel.this.table.convertRowIndexToModel(r);
                    LocalPublicPost lp = PrivatePanel.this.Model.getPrivateMessage(r);
                    if (lp != null) {
                        PrivatePanel.this.Dialog.viewMessage(lp);
                    }
                }
            }
        });
        JMenuItem rp = new JMenuItem("Reply");
        mnu.add(rp);
        rp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PrivatePanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PrivatePanel.this.table.getSelectedRow();
                    r = PrivatePanel.this.table.convertRowIndexToModel(r);
                    LocalPublicPost lp = PrivatePanel.this.Model.getPrivateMessage(r);
                    if (lp != null) {
                        PrivatePanel.this.Dialog.replyToMessage(lp);
                    }
                }
            }
        });
        JMenuItem grantacs = new JMenuItem("Grant Peer Group Access");
        mnu.add(grantacs);
        grantacs.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!PrivatePanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PrivatePanel.this.table.getSelectedRow();
                    r = PrivatePanel.this.table.convertRowIndexToModel(r);
                    LocalPublicPost lp = PrivatePanel.this.Model.getPrivateMessage(r);
                    if (lp == null || lp.getPublicPost().getNetworkId() == null) {
                        JOptionPane.showMessageDialog(PrivatePanel.this.table, "There's no network assocated with this post", "No Network", 2);
                        return;
                    }
                    DataBaseCoreImpl dataBaseCoreImpl = PrivatePanel.this.Mn.getCoreDB();
                    synchronized (dataBaseCoreImpl) {
                        BBytes me = PrivatePanel.this.Mn.getCoreDB().getMyPeerData().getPeer().getPeer().getIdentity();
                        PrivatePanel.this.SignDialogs.setPeer(PrivatePanel.this.Mn.getCoreDB().getPeer(lp.getPublicPost().getSignature().getPeerIdentifier()));
                        PrivatePanel.this.SignDialogs.setCurAuth(PrivatePanel.this.Mn.getCoreDB().getNetworkAuth(lp.getPublicPost().getNetworkId(), me));
                    }
                    PrivatePanel.this.SignDialogs.sign();
                } else {
                    JOptionPane.showMessageDialog(PrivatePanel.this.table, "Select a message first.", "No message selected", 2);
                }
            }
        });
        this.table.setComponentPopupMenu(mnu);
    }

    public NewPeerMessageDialog getDialog() {
        return this.Dialog;
    }

    public void setDialog(NewPeerMessageDialog dialog) {
        this.Dialog = dialog;
    }
}

