/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.util.Date;
import javax.swing.table.AbstractTableModel;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalPublicPost;
import org.ourfilesystem.ui.NewPublicPostDialog;

public class PrivateMessageTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private QueryResultsInterface PublicPosts;
    private String[] Columnnames = new String[]{"From", "To", "Subject", "Network", "Date"};

    @Override
    public String getColumnName(int col) {
        return this.Columnnames[col];
    }

    public Class getColumnClass(int col) {
        if (col == 4) {
            return Date.class;
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.Columnnames.length;
    }

    @Override
    public synchronized int getRowCount() {
        if (this.PublicPosts != null) {
            return this.PublicPosts.size();
        }
        return 0;
    }

    public synchronized LocalPublicPost getPrivateMessage(int r) {
        if (this.PublicPosts != null && r < this.PublicPosts.size()) {
            return (LocalPublicPost)this.PublicPosts.get(r);
        }
        return null;
    }

    @Override
    public Object getValueAt(int r, int c) {
        LocalPublicPost lp = this.getPrivateMessage(r);
        if (lp != null) {
            String m;
            String[] parts;
            if (c == 0) {
                return lp.getCreator();
            }
            if (c == 1) {
                return lp.getToPeer();
            }
            if (c == 2 && lp.getDecodedMessage() instanceof String && (parts = (m = (String)lp.getDecodedMessage()).split(NewPublicPostDialog.SUBJECTBODY)).length > 0) {
                return parts[0];
            }
            if (c == 3) {
                return lp.getNetworkTitle();
            }
            if (c == 4) {
                return lp.getLocalDate();
            }
        }
        return null;
    }

    public synchronized void setPrivateMessages(QueryResultsInterface l) {
        if (this.PublicPosts != null) {
            this.PublicPosts.Close();
        }
        this.PublicPosts = l;
        this.fireTableDataChanged();
    }
}

