/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.util.Date;
import javax.swing.table.AbstractTableModel;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalPost;
import org.ourfilesystem.db.so.PostMessage;
import org.ourfilesystem.filehandler.FileHandler;
import org.ourfilesystem.utilities.HumReadFileSize;

public class PostTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private QueryResultsInterface Posts;
    private String[] Columnnames = new String[]{"Creator", "Peer Rank", "Subject", "Date", "File Name", "Local File", "Size"};

    @Override
    public String getColumnName(int col) {
        return this.Columnnames[col];
    }

    public Class getColumnClass(int col) {
        if (col == 1) {
            return Long.class;
        }
        if (col == 3) {
            return Date.class;
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.Columnnames.length;
    }

    @Override
    public synchronized int getRowCount() {
        if (this.Posts != null) {
            return this.Posts.size();
        }
        return 0;
    }

    public synchronized LocalPost getPost(int r) {
        if (this.Posts != null && r < this.Posts.size()) {
            return (LocalPost)this.Posts.get(r);
        }
        return null;
    }

    @Override
    public Object getValueAt(int r, int c) {
        LocalPost lp = this.getPost(r);
        if (lp != null && lp.getPost().getMessage() instanceof PostMessage) {
            PostMessage pm = (PostMessage)lp.getPost().getMessage();
            if (c == 0) {
                return lp.getCreator();
            }
            if (c == 1) {
                return lp.getPeerRank();
            }
            if (c == 2) {
                return pm.getSubject();
            }
            if (c == 3) {
                return lp.getLocalDate();
            }
            if (c == 4) {
                return pm.getFileName();
            }
            if (c == 5) {
                return lp.getLocalFile();
            }
            if (c == 6 && FileHandler.MASTER_VALUE.equals(pm.getString0())) {
                return HumReadFileSize.fileSize(pm.getNum1());
            }
        }
        return null;
    }

    public synchronized void setPosts(QueryResultsInterface p) {
        if (this.Posts != null) {
            this.Posts.Close();
        }
        this.Posts = p;
        this.fireTableDataChanged();
    }
}

