/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.db.DataBaseCoreImpl;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.LocalPost;
import org.ourfilesystem.db.so.PostTemplate;
import org.ourfilesystem.db.so.SearchQuery;
import org.ourfilesystem.ui.Main;
import org.ourfilesystem.ui.NetworkAuthTableModel;
import org.ourfilesystem.ui.NetworkSelectInterface;
import org.ourfilesystem.ui.NewNetworkDialog;
import org.ourfilesystem.ui.NewPostDialog;
import org.ourfilesystem.ui.NewTemplateDialog;
import org.ourfilesystem.ui.PostTableModel;
import org.ourfilesystem.ui.QueryTableModel;
import org.ourfilesystem.ui.TemplateTableModel;

public class PostSearchPanel
extends JPanel
implements NetworkSelectInterface {
    private static final long serialVersionUID = 1L;
    private JTextField textQueryName;
    private JLabel lblGeneralSearch;
    private JTextField textGeneral;
    private JCheckBox chckbxUseGeneral;
    private JTextField textFileName;
    private JCheckBox chckbxUseFileName;
    private JTextField textSubject;
    private JCheckBox chckbxUseSubject;
    private JTextField textComment;
    private JCheckBox chckbxUseComment;
    private JTextField textMinRank;
    private JCheckBox chckbxUseMinRank;
    private JCheckBox[] chckbxBool;
    private JLabel[] lblNumLessThan;
    private JTextField[] txtNumLessThan;
    private JCheckBox[] chckbxNumLessThan;
    private JLabel[] lblNumGreaterThan;
    private JTextField[] txtNumGreaterThan;
    private JCheckBox[] chckbxNumGreaterThan;
    private JLabel[] lblDoubleLessThan;
    private JTextField[] txtDoubleLessThan;
    private JCheckBox[] chckbxDoubleLessThan;
    private JLabel[] lblDoubleGreaterThan;
    private JTextField[] txtDoubleGreaterThan;
    private JCheckBox[] chckbxDoubleGreaterThan;
    private JLabel[] lblString;
    private JTextField[] textString;
    private JCheckBox[] chckbxUseString;
    private JSplitPane mainSplitPane;
    private JScrollPane mainScroll;
    private Main Mn;
    private JLabel lblGroupSel;
    private JLabel lblTemplateSel;
    private JTable table;
    private JTable table_1;
    private QueryTableModel QueryTableModel;
    private TemplateTableModel TemplateTableModel;
    private NetworkAuthTableModel NetworkAuthTableModel;
    private NewTemplateDialog NewTemplateDialog;
    private NewPostDialog NewPostDialog;
    private PostTemplate SelectedTemplate;
    private LocalNetwork SelectedNetwork;
    private LocalPost SelectedPost;
    private SearchQuery SelectedQuery;
    private JButton btnSearch;
    private PostTableModel PostTableModel;
    private JButton btnRefreshTemplates;
    private JButton btnNewGroup;
    private JSplitPane splitPane;
    private JPanel panel_1;
    private JTextField textGrpSearch;
    private JButton btnSearch_1;
    private JPanel panel_2;
    private JScrollPane scrollPane_2;
    private JTable table_2;
    private NewNetworkDialog Dialog;

    public PostSearchPanel(Main m, PostTableModel tm) {
        this.Mn = m;
        this.PostTableModel = tm;
        this.QueryTableModel = new QueryTableModel(this.Mn);
        this.TemplateTableModel = new TemplateTableModel(this.Mn);
        this.NetworkAuthTableModel = new NetworkAuthTableModel();
        this.NetworkAuthTableModel.setSimple(true);
        this.Dialog = new NewNetworkDialog(this.Mn);
        this.setLayout(new BorderLayout(0, 0));
        this.NewTemplateDialog = new NewTemplateDialog(this.TemplateTableModel);
        this.NewPostDialog = new NewPostDialog(this.Mn);
        this.mainSplitPane = new JSplitPane();
        this.add((Component)this.mainSplitPane, "Center");
        JSplitPane splitPane_1 = new JSplitPane();
        this.mainSplitPane.setLeftComponent(splitPane_1);
        JSplitPane splitPane_2 = new JSplitPane();
        splitPane_1.setLeftComponent(splitPane_2);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(100, 2));
        splitPane_2.setLeftComponent(scrollPane);
        JPopupMenu querymenu = new JPopupMenu();
        JMenuItem usequery = new JMenuItem("Select Query");
        querymenu.add(usequery);
        usequery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!PostSearchPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PostSearchPanel.this.table.getSelectedRow();
                    r = PostSearchPanel.this.table.convertRowIndexToModel(r);
                    PostSearchPanel.this.SelectedQuery = PostSearchPanel.this.QueryTableModel.getSearchQuery(r);
                    PostSearchPanel.this.updateFromSelectedQuery();
                }
            }
        });
        JMenuItem delquery = new JMenuItem("Delete Query");
        querymenu.add(delquery);
        delquery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!PostSearchPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PostSearchPanel.this.table.getSelectedRow();
                    r = PostSearchPanel.this.table.convertRowIndexToModel(r);
                    PostSearchPanel.this.QueryTableModel.deleteSearchQuery(r);
                }
            }
        });
        this.table = new JTable(this.QueryTableModel);
        this.table.setComponentPopupMenu(querymenu);
        this.table.setAutoCreateRowSorter(true);
        scrollPane.setViewportView(this.table);
        this.splitPane = new JSplitPane();
        this.splitPane.setPreferredSize(new Dimension(100, 2));
        this.splitPane.setOrientation(0);
        splitPane_2.setRightComponent(this.splitPane);
        this.panel_1 = new JPanel();
        this.splitPane.setLeftComponent(this.panel_1);
        this.panel_1.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][][]"));
        this.textGrpSearch = new JTextField();
        this.panel_1.add((Component)this.textGrpSearch, "flowx,cell 0 1,growx");
        this.textGrpSearch.setColumns(10);
        this.panel_1.setPreferredSize(new Dimension(100, 2));
        this.btnSearch_1 = new JButton("Search");
        this.panel_1.add((Component)this.btnSearch_1, "cell 0 2");
        this.btnSearch_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PostSearchPanel.this.doSearch();
            }
        });
        this.panel_2 = new JPanel();
        this.splitPane.setRightComponent(this.panel_2);
        this.panel_2.setLayout(new BorderLayout(0, 0));
        this.panel_2.setPreferredSize(new Dimension(100, 2));
        this.scrollPane_2 = new JScrollPane();
        this.scrollPane_2.setPreferredSize(new Dimension(100, 2));
        this.panel_2.add((Component)this.scrollPane_2, "Center");
        this.table_2 = new JTable(this.NetworkAuthTableModel);
        this.table_2.setSelectionMode(0);
        this.table_2.setAutoCreateRowSorter(true);
        this.scrollPane_2.setViewportView(this.table_2);
        this.table_2.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                if (!PostSearchPanel.this.table_2.getSelectionModel().isSelectionEmpty()) {
                    int r = PostSearchPanel.this.table_2.getSelectedRow();
                    r = PostSearchPanel.this.table_2.convertRowIndexToModel(r);
                    LocalNetworkAuthorization lna = PostSearchPanel.this.NetworkAuthTableModel.getNetworkAuth(r);
                    if (lna != null) {
                        LocalNetwork ln = PostSearchPanel.this.Mn.getCoreDB().getLocalNetwork(lna.getNetworkAuthorization().getNetworkId());
                        PostSearchPanel.this.Mn.getGui().setNewNetwork(ln, lna);
                    }
                }
            }
        });
        JScrollPane scrollPane_1 = new JScrollPane();
        scrollPane_1.setPreferredSize(new Dimension(100, 2));
        JSplitPane splitPane_3 = new JSplitPane();
        splitPane_3.setOrientation(0);
        splitPane_1.setRightComponent(splitPane_3);
        this.btnRefreshTemplates = new JButton("Refresh");
        splitPane_3.setLeftComponent(this.btnRefreshTemplates);
        this.btnRefreshTemplates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PostSearchPanel.this.TemplateTableModel.refresh();
            }
        });
        splitPane_3.setRightComponent(scrollPane_1);
        this.table_1 = new JTable(this.TemplateTableModel);
        this.table_1.setAutoCreateRowSorter(true);
        this.table_1.setSelectionMode(0);
        scrollPane_1.setViewportView(this.table_1);
        this.table_1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                if (!PostSearchPanel.this.table_1.getSelectionModel().isSelectionEmpty()) {
                    int r = PostSearchPanel.this.table_1.getSelectedRow();
                    r = PostSearchPanel.this.table_1.convertRowIndexToModel(r);
                    PostSearchPanel.this.SelectedTemplate = PostSearchPanel.this.TemplateTableModel.getTemplate(r);
                    PostSearchPanel.this.buildSearchPane();
                }
            }
        });
        this.mainScroll = new JScrollPane();
        this.mainSplitPane.setRightComponent(this.mainScroll);
        this.mainSplitPane.setDividerLocation(350);
        splitPane_1.setDividerLocation(250);
        splitPane_2.setDividerLocation(100);
        this.buildSearchPane();
        this.doSearch();
    }

    public void doSearch() {
        String s = this.textGrpSearch.getText();
        QueryResultsInterface qr = this.Mn.getCoreDB().getDBQuery().queryMyNetworkAuths(s);
        this.NetworkAuthTableModel.setNetworkAuths(qr);
    }

    private void buildSearchPane() {
        final JPanel panel = new JPanel();
        this.mainScroll.setViewportView(panel);
        panel.setLayout((LayoutManager)new MigLayout("", "[][grow][]", "[][][][][][][][][][][]"));
        String grpname = "none";
        if (this.SelectedNetwork != null) {
            grpname = this.SelectedNetwork.getNetwork().getTitleSig();
        }
        String tempname = "none";
        if (this.SelectedTemplate != null) {
            tempname = this.SelectedTemplate.getTemplateName();
        }
        JButton btnNewPost = new JButton("New Post");
        panel.add((Component)btnNewPost, "flowx,cell 1 2,alignx left");
        btnNewPost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (PostSearchPanel.this.SelectedTemplate != null) {
                    if (PostSearchPanel.this.SelectedNetwork != null) {
                        PostSearchPanel.this.NewPostDialog.showDialog(PostSearchPanel.this.SelectedTemplate, PostSearchPanel.this.SelectedPost, PostSearchPanel.this.SelectedNetwork.getNetwork().getTitleSig());
                    } else {
                        JOptionPane.showMessageDialog(panel, "Select a group first.", "Select group", 2);
                    }
                } else {
                    JOptionPane.showMessageDialog(panel, "Select a template first.", "Select template", 2);
                }
            }
        });
        JButton btnUpdatePosts = new JButton("Update Posts");
        panel.add((Component)btnUpdatePosts, "cell 1 2,alignx right");
        btnUpdatePosts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PostSearchPanel.this.Mn.getUpdater().updatePostsNow();
            }
        });
        this.btnSearch = new JButton("Search");
        panel.add((Component)this.btnSearch, "cell 2 2");
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PostSearchPanel.this.SelectedNetwork == null) {
                    JOptionPane.showMessageDialog(panel, "No Group is selected.", "No Group", 2);
                    return;
                }
                if (PostSearchPanel.this.SelectedTemplate == null) {
                    JOptionPane.showMessageDialog(panel, "No template is selected.", "No template", 2);
                    return;
                }
                SearchQuery sq = PostSearchPanel.this.buildQuery();
                if (sq != null && PostSearchPanel.this.Mn != null && PostSearchPanel.this.PostTableModel != null) {
                    QueryResultsInterface qr = PostSearchPanel.this.Mn.getCoreDB().getDBQuery().searchPosts(sq);
                    PostSearchPanel.this.PostTableModel.setPosts(qr);
                }
            }
        });
        JLabel lblQueryName = new JLabel("Query name");
        panel.add((Component)lblQueryName, "cell 0 3,alignx trailing");
        this.textQueryName = new JTextField();
        panel.add((Component)this.textQueryName, "cell 1 3,growx");
        this.textQueryName.setColumns(10);
        JButton btnSaveQuery = new JButton("Save Query");
        panel.add((Component)btnSaveQuery, "cell 2 3");
        btnSaveQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SearchQuery sq = PostSearchPanel.this.buildQuery();
                Matcher m = Pattern.compile("\\S+").matcher(sq.QueryName);
                if (m.find()) {
                    PostSearchPanel.this.SelectedQuery = sq;
                    PostSearchPanel.this.QueryTableModel.saveSearchQuery(sq);
                } else {
                    JOptionPane.showMessageDialog(panel, "You must name the query.", "Name Query", 2);
                }
            }
        });
        this.lblGeneralSearch = new JLabel("General Search");
        panel.add((Component)this.lblGeneralSearch, "cell 0 4,alignx trailing");
        this.textGeneral = new JTextField();
        panel.add((Component)this.textGeneral, "cell 1 4,growx");
        this.textGeneral.setColumns(10);
        this.chckbxUseGeneral = new JCheckBox("Use");
        panel.add((Component)this.chckbxUseGeneral, "cell 2 4");
        JLabel lblFileName = new JLabel("File name");
        panel.add((Component)lblFileName, "cell 0 5,alignx trailing");
        this.textFileName = new JTextField();
        panel.add((Component)this.textFileName, "cell 1 5,growx");
        this.textFileName.setColumns(10);
        this.chckbxUseFileName = new JCheckBox("Use");
        panel.add((Component)this.chckbxUseFileName, "cell 2 5");
        JLabel lblSubject = new JLabel("Subject");
        panel.add((Component)lblSubject, "cell 0 6,alignx trailing");
        this.textSubject = new JTextField();
        panel.add((Component)this.textSubject, "cell 1 6,growx");
        this.textSubject.setColumns(10);
        this.chckbxUseSubject = new JCheckBox("Use");
        panel.add((Component)this.chckbxUseSubject, "cell 2 6");
        JLabel lblComment = new JLabel("Comment");
        panel.add((Component)lblComment, "cell 0 7,alignx trailing");
        this.textComment = new JTextField();
        panel.add((Component)this.textComment, "cell 1 7,growx");
        this.textComment.setColumns(10);
        this.chckbxUseComment = new JCheckBox("Use");
        panel.add((Component)this.chckbxUseComment, "cell 2 7");
        JLabel lblMinPeerRank = new JLabel("Min Peer Rank");
        panel.add((Component)lblMinPeerRank, "cell 0 8,alignx trailing");
        this.textMinRank = new JTextField();
        panel.add((Component)this.textMinRank, "cell 1 8,growx");
        this.textMinRank.setColumns(10);
        this.chckbxUseMinRank = new JCheckBox("Use");
        panel.add((Component)this.chckbxUseMinRank, "cell 2 8");
        JButton btnNewTemplate = new JButton("New Template");
        panel.add((Component)btnNewTemplate, "flowx,cell 1 1,alignx left");
        JLabel lblTemplate = new JLabel("Current Template:");
        panel.add((Component)lblTemplate, "cell 1 1,alignx trailing");
        this.lblTemplateSel = new JLabel(tempname);
        panel.add((Component)this.lblTemplateSel, "cell 1 1,alignx left");
        this.btnNewGroup = new JButton("New Group");
        panel.add((Component)this.btnNewGroup, "flowx,cell 1 0");
        this.btnNewGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PostSearchPanel.this.Dialog.showDialog();
            }
        });
        JLabel lblGroup = new JLabel("Current Group:");
        panel.add((Component)lblGroup, "cell 1 0,alignx left");
        this.lblGroupSel = new JLabel(grpname);
        panel.add((Component)this.lblGroupSel, "cell 1 0");
        btnNewTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (PostSearchPanel.this.NewTemplateDialog != null) {
                    if (PostSearchPanel.this.SelectedNetwork != null) {
                        PostSearchPanel.this.NewTemplateDialog.showDialog(PostSearchPanel.this.SelectedNetwork);
                    } else {
                        JOptionPane.showMessageDialog(panel, "Group must be selected first.\nUse the Group tab.", "Select Group", 2);
                    }
                }
            }
        });
        this.lblNumLessThan = new JLabel[10];
        this.txtNumLessThan = new JTextField[10];
        this.chckbxNumLessThan = new JCheckBox[10];
        this.lblNumGreaterThan = new JLabel[10];
        this.txtNumGreaterThan = new JTextField[10];
        this.chckbxNumGreaterThan = new JCheckBox[10];
        this.lblDoubleLessThan = new JLabel[10];
        this.txtDoubleLessThan = new JTextField[10];
        this.chckbxDoubleLessThan = new JCheckBox[10];
        this.lblDoubleGreaterThan = new JLabel[10];
        this.txtDoubleGreaterThan = new JTextField[10];
        this.chckbxDoubleGreaterThan = new JCheckBox[10];
        this.chckbxBool = new JCheckBox[10];
        this.textString = new JTextField[8];
        this.chckbxUseString = new JCheckBox[8];
        int r = 9;
        if (this.SelectedTemplate != null) {
            int c3;
            JButton btnMin;
            int c2;
            JButton btnMax;
            String nv;
            int numinserted = 0;
            int c = 0;
            while (c < 10) {
                nv = this.SelectedTemplate.getBool(c);
                if (nv != null) {
                    this.chckbxBool[c] = new JCheckBox(nv);
                    panel.add((Component)this.chckbxBool[c], "cell 1 " + r);
                    if (++numinserted % 2 == 0) {
                        ++r;
                    }
                }
                ++c;
            }
            if (numinserted % 2 != 0) {
                ++r;
            }
            c = 0;
            while (c < 10) {
                nv = this.SelectedTemplate.getNum(c);
                if (nv != null) {
                    this.lblNumLessThan[c] = new JLabel(String.valueOf(nv) + " <");
                    panel.add((Component)this.lblNumLessThan[c], "cell 0 " + r + ",alignx trailing");
                    this.txtNumLessThan[c] = new JTextField();
                    panel.add((Component)this.txtNumLessThan[c], "flowx,cell 1 " + r + ",growx");
                    this.txtNumLessThan[c].setColumns(10);
                    btnMax = new JButton("Max");
                    panel.add((Component)btnMax, "cell 1 " + r);
                    c2 = c;
                    btnMax.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            PostSearchPanel.this.txtNumLessThan[c2].setText(Long.toString(Long.MAX_VALUE));
                        }
                    });
                    this.chckbxNumLessThan[c] = new JCheckBox("Use");
                    panel.add((Component)this.chckbxNumLessThan[c], "cell 2 " + r);
                    this.lblNumGreaterThan[c] = new JLabel(String.valueOf(nv) + " >");
                    panel.add((Component)this.lblNumGreaterThan[c], "cell 0 " + ++r + ",alignx trailing");
                    this.txtNumGreaterThan[c] = new JTextField();
                    panel.add((Component)this.txtNumGreaterThan[c], "flowx,cell 1 " + r + ",growx");
                    this.txtNumGreaterThan[c].setColumns(10);
                    btnMin = new JButton("Min");
                    panel.add((Component)btnMin, "cell 1 " + r);
                    c3 = c;
                    btnMin.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PostSearchPanel.this.txtNumGreaterThan[c3].setText(Long.toString(Long.MIN_VALUE));
                        }
                    });
                    this.chckbxNumGreaterThan[c] = new JCheckBox("Use");
                    panel.add((Component)this.chckbxNumGreaterThan[c], "cell 2 " + r);
                    ++r;
                }
                ++c;
            }
            c = 0;
            while (c < 10) {
                nv = this.SelectedTemplate.getDouble(c);
                if (nv != null) {
                    this.lblDoubleLessThan[c] = new JLabel(String.valueOf(nv) + " <");
                    panel.add((Component)this.lblDoubleLessThan[c], "cell 0 " + r + ",alignx trailing");
                    this.txtDoubleLessThan[c] = new JTextField();
                    panel.add((Component)this.txtDoubleLessThan[c], "flowx,cell 1 " + r + ",growx");
                    this.txtDoubleLessThan[c].setColumns(10);
                    btnMax = new JButton("Max");
                    panel.add((Component)btnMax, "cell 1 " + r);
                    c2 = c;
                    btnMax.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            PostSearchPanel.this.txtDoubleLessThan[c2].setText(Double.toString(9.223372036854776E18));
                        }
                    });
                    this.chckbxDoubleLessThan[c] = new JCheckBox("Use");
                    panel.add((Component)this.chckbxDoubleLessThan[c], "cell 2 " + r);
                    this.lblDoubleGreaterThan[c] = new JLabel(String.valueOf(nv) + " >");
                    panel.add((Component)this.lblDoubleGreaterThan[c], "cell 0 " + ++r + ",alignx trailing");
                    this.txtDoubleGreaterThan[c] = new JTextField();
                    panel.add((Component)this.txtDoubleGreaterThan[c], "flowx,cell 1 " + r + ",growx");
                    this.txtDoubleGreaterThan[c].setColumns(10);
                    btnMin = new JButton("Min");
                    panel.add((Component)btnMin, "cell 1 " + r);
                    c3 = c;
                    btnMin.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PostSearchPanel.this.txtDoubleGreaterThan[c3].setText(Double.toString(-9.223372036854776E18));
                        }
                    });
                    this.chckbxDoubleGreaterThan[c] = new JCheckBox("Use");
                    panel.add((Component)this.chckbxDoubleGreaterThan[c], "cell 2 " + r);
                    ++r;
                }
                ++c;
            }
            c = 0;
            while (c < 8) {
                nv = this.SelectedTemplate.getString(c);
                if (nv != null) {
                    this.lblString[c] = new JLabel(nv);
                    panel.add((Component)this.lblString[c], "cell 0 " + r + ",alignx trailing");
                    this.textString[c] = new JTextField();
                    panel.add((Component)this.textString[c], "flowx,cell 1 " + r + ",growx");
                    this.textString[c].setColumns(10);
                    this.chckbxUseString[c] = new JCheckBox("Use");
                    panel.add((Component)this.chckbxUseString[c], "cell 2 " + r);
                    ++r;
                }
                ++c;
            }
        }
    }

    private void updateFromSelectedQuery() {
        if (this.SelectedQuery != null) {
            SearchQuery s = this.SelectedQuery;
            if (s.UseTemplate != null) {
                this.SelectedTemplate = this.Mn.getCoreDB().getPostTemplate(s.UseTemplate);
            }
            this.buildSearchPane();
            this.textQueryName.setText(s.QueryName);
            if (s.Generalterms != null) {
                this.textGeneral.setText(s.Generalterms);
                this.chckbxUseGeneral.setSelected(true);
            }
            if (s.Searchterms != null) {
                Double v;
                Map<String, Double> dl;
                Long v2;
                int c;
                Map<String, Long> l;
                Long mr;
                String n = s.Searchterms.get(DataBaseCoreImpl.POST_FILENAME);
                if (n != null) {
                    this.chckbxUseFileName.setSelected(true);
                    this.textFileName.setText(n);
                }
                if ((n = s.Searchterms.get(DataBaseCoreImpl.POST_SUBJECT)) != null) {
                    this.chckbxUseSubject.setSelected(true);
                    this.textSubject.setText(n);
                }
                if ((n = s.Searchterms.get(DataBaseCoreImpl.POST_COMMENT)) != null) {
                    this.chckbxUseComment.setSelected(true);
                    this.textComment.setText(n);
                }
                if ((mr = s.Minpeerrank) != null) {
                    this.chckbxUseMinRank.setSelected(true);
                    this.textMinRank.setText(Long.toString(mr));
                }
                int c2 = 0;
                while (c2 < 8) {
                    n = s.Searchterms.get(PostTemplate.getStringKey(c2));
                    if (n != null) {
                        this.chckbxUseString[c2].setSelected(true);
                        this.textString[c2].setText(n);
                    }
                    ++c2;
                }
                Set<String> b = s.Andtruebools;
                if (b != null) {
                    int c3 = 0;
                    while (c3 < 10) {
                        if (b.contains(PostTemplate.getBoolKey(c3))) {
                            this.chckbxBool[c3].setSelected(true);
                        }
                        ++c3;
                    }
                }
                if ((l = s.Lessthan) != null) {
                    c = 0;
                    while (c < 10) {
                        v2 = l.get(PostTemplate.getNumKey(c));
                        if (v2 != null) {
                            this.chckbxNumLessThan[c].setSelected(true);
                            this.txtNumLessThan[c].setText(Long.toString(v2));
                        }
                        ++c;
                    }
                }
                if ((l = s.Greaterthan) != null) {
                    c = 0;
                    while (c < 10) {
                        v2 = l.get(PostTemplate.getNumKey(c));
                        if (v2 != null) {
                            this.chckbxNumGreaterThan[c].setSelected(true);
                            this.txtNumGreaterThan[c].setText(Long.toString(v2));
                        }
                        ++c;
                    }
                }
                if ((dl = s.Dlessthan) != null) {
                    int c4 = 0;
                    while (c4 < 10) {
                        v = dl.get(PostTemplate.getDoubleKey(c4));
                        if (v != null) {
                            this.chckbxDoubleLessThan[c4].setSelected(true);
                            this.txtDoubleLessThan[c4].setText(Double.toString(v));
                        }
                        ++c4;
                    }
                }
                if ((dl = s.Dgreaterthan) != null) {
                    int c5 = 0;
                    while (c5 < 10) {
                        v = dl.get(PostTemplate.getDoubleKey(c5));
                        if (v != null) {
                            this.chckbxDoubleGreaterThan[c5].setSelected(true);
                            this.txtDoubleGreaterThan[c5].setText(Double.toString(v));
                        }
                        ++c5;
                    }
                }
            }
        }
    }

    private SearchQuery buildQuery() {
        if (this.SelectedTemplate != null) {
            long v2;
            SearchQuery sq = new SearchQuery();
            sq.UseTemplate = this.SelectedTemplate.getDigest();
            sq.Network = this.SelectedTemplate.getNetworkId();
            sq.QueryName = this.textQueryName.getText();
            if (this.chckbxUseGeneral.isSelected()) {
                sq.Generalterms = this.textGeneral.getText();
            }
            if (this.chckbxUseSubject.isSelected()) {
                if (sq.Searchterms == null) {
                    sq.Searchterms = new HashMap<String, String>();
                }
                sq.Searchterms.put(DataBaseCoreImpl.POST_SUBJECT, this.textSubject.getText());
            }
            if (this.chckbxUseFileName.isSelected()) {
                if (sq.Searchterms == null) {
                    sq.Searchterms = new HashMap<String, String>();
                }
                sq.Searchterms.put(DataBaseCoreImpl.POST_FILENAME, this.textFileName.getText());
            }
            if (this.chckbxUseComment.isSelected()) {
                if (sq.Searchterms == null) {
                    sq.Searchterms = new HashMap<String, String>();
                }
                sq.Searchterms.put(DataBaseCoreImpl.POST_COMMENT, this.textComment.getText());
            }
            if (this.chckbxUseMinRank.isSelected()) {
                try {
                    long minr = Long.valueOf(this.textMinRank.getText());
                    sq.Minpeerrank = minr;
                }
                catch (Exception minr) {
                    // empty catch block
                }
            }
            int cnt = 0;
            while (cnt < 8) {
                if (this.chckbxUseString[cnt] != null && this.chckbxUseString[cnt].isSelected()) {
                    if (sq.Searchterms == null) {
                        sq.Searchterms = new HashMap<String, String>();
                    }
                    sq.Searchterms.put(PostTemplate.getStringKey(cnt), this.textString[cnt].getText());
                }
                ++cnt;
            }
            cnt = 0;
            while (cnt < 10) {
                if (this.chckbxBool[cnt] != null && this.chckbxBool[cnt].isSelected()) {
                    if (sq.Andtruebools == null) {
                        sq.Andtruebools = new HashSet<String>();
                    }
                    sq.Andtruebools.add(PostTemplate.getBoolKey(cnt));
                }
                ++cnt;
            }
            cnt = 0;
            while (cnt < 10) {
                if (this.chckbxNumLessThan[cnt] != null && this.chckbxNumLessThan[cnt].isSelected()) {
                    if (sq.Lessthan == null) {
                        sq.Lessthan = new HashMap<String, Long>();
                    }
                    try {
                        v2 = Long.valueOf(this.txtNumLessThan[cnt].getText());
                        sq.Lessthan.put(PostTemplate.getNumKey(cnt), v2);
                    }
                    catch (Exception v2) {
                        // empty catch block
                    }
                }
                ++cnt;
            }
            cnt = 0;
            while (cnt < 10) {
                if (this.chckbxNumGreaterThan[cnt] != null && this.chckbxNumGreaterThan[cnt].isSelected()) {
                    if (sq.Greaterthan == null) {
                        sq.Greaterthan = new HashMap<String, Long>();
                    }
                    try {
                        v2 = Long.valueOf(this.txtNumGreaterThan[cnt].getText());
                        sq.Greaterthan.put(PostTemplate.getNumKey(cnt), v2);
                    }
                    catch (Exception v3) {
                        // empty catch block
                    }
                }
                ++cnt;
            }
            cnt = 0;
            while (cnt < 10) {
                if (this.chckbxDoubleLessThan[cnt] != null && this.chckbxDoubleLessThan[cnt].isSelected()) {
                    if (sq.Dlessthan == null) {
                        sq.Dlessthan = new HashMap<String, Double>();
                    }
                    try {
                        double v4 = Double.valueOf(this.txtDoubleLessThan[cnt].getText());
                        sq.Dlessthan.put(PostTemplate.getDoubleKey(cnt), v4);
                    }
                    catch (Exception v4) {
                        // empty catch block
                    }
                }
                ++cnt;
            }
            cnt = 0;
            while (cnt < 10) {
                if (this.chckbxDoubleGreaterThan[cnt] != null && this.chckbxDoubleGreaterThan[cnt].isSelected()) {
                    if (sq.Dgreaterthan == null) {
                        sq.Dgreaterthan = new HashMap<String, Double>();
                    }
                    try {
                        double v5 = Double.valueOf(this.txtDoubleGreaterThan[cnt].getText());
                        sq.Dgreaterthan.put(PostTemplate.getDoubleKey(cnt), v5);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++cnt;
            }
            return sq;
        }
        return null;
    }

    @Override
    public void setSelectedNetwork(LocalNetwork network, LocalNetworkAuthorization auth) {
        this.SelectedNetwork = network;
        this.lblGroupSel.setText(network.getNetwork().getTitleSig());
        this.QueryTableModel.setSelectedNetwork(network, auth);
        this.TemplateTableModel.setSelectedNetwork(network, auth);
        this.SelectedTemplate = null;
        this.buildSearchPane();
    }

    public NewPostDialog getNewPostDialog() {
        return this.NewPostDialog;
    }

    public void setNewPostDialog(NewPostDialog newPostDialog) {
        this.NewPostDialog = newPostDialog;
    }
}

