/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import org.ourfilesystem.db.DataBaseCoreImpl;
import org.ourfilesystem.db.so.FileStatus;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.LocalPost;
import org.ourfilesystem.ui.Main;
import org.ourfilesystem.ui.NetworkSelectInterface;
import org.ourfilesystem.ui.NewPeerMessageDialog;
import org.ourfilesystem.ui.PostSearchPanel;
import org.ourfilesystem.ui.PostTableModel;

public class PostPanel
extends JPanel
implements NetworkSelectInterface {
    private static final long serialVersionUID = 1L;
    private JTable table;
    private PostSearchPanel SearchPanel;
    private PostTableModel PostTableModel;
    private NewPeerMessageDialog MessageDialog;
    private Main Mn;

    public PostPanel(Main m) {
        this.Mn = m;
        this.PostTableModel = new PostTableModel();
        this.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOrientation(0);
        this.add((Component)splitPane, "Center");
        this.SearchPanel = new PostSearchPanel(this.Mn, this.PostTableModel);
        splitPane.setLeftComponent(this.SearchPanel);
        JScrollPane scrollPane = new JScrollPane();
        splitPane.setRightComponent(scrollPane);
        splitPane.setDividerLocation(200);
        this.table = new JTable(this.PostTableModel);
        this.table.setAutoCreateRowSorter(true);
        this.table.setSelectionMode(2);
        scrollPane.setViewportView(this.table);
        JPopupMenu mnu = new JPopupMenu();
        JMenuItem view = new JMenuItem("View");
        mnu.add(view);
        view.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!PostPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PostPanel.this.table.getSelectedRow();
                    r = PostPanel.this.table.convertRowIndexToModel(r);
                    LocalPost lp = PostPanel.this.PostTableModel.getPost(r);
                    if (lp != null) {
                        PostPanel.this.SearchPanel.getNewPostDialog().showPost(lp);
                    }
                }
            }
        });
        JMenuItem download = new JMenuItem("Download Files");
        mnu.add(download);
        download.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int[] selr = PostPanel.this.table.getSelectedRows();
                int c = 0;
                while (c < selr.length) {
                    int r = selr[c];
                    r = PostPanel.this.table.convertRowIndexToModel(r);
                    LocalPost lp = PostPanel.this.PostTableModel.getPost(r);
                    if (lp != null) {
                        PostPanel.this.Mn.getFileHandler().downloadFile(lp);
                    }
                    ++c;
                }
            }
        });
        JMenuItem reply = new JMenuItem("Reply");
        mnu.add(reply);
        reply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!PostPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PostPanel.this.table.getSelectedRow();
                    r = PostPanel.this.table.convertRowIndexToModel(r);
                    LocalPost lp = PostPanel.this.PostTableModel.getPost(r);
                    if (lp != null) {
                        PostPanel.this.SearchPanel.getNewPostDialog().replyToPost(lp);
                    }
                }
            }
        });
        JMenuItem priv = new JMenuItem("Send Private Message");
        mnu.add(priv);
        priv.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!PostPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PostPanel.this.table.getSelectedRow();
                    r = PostPanel.this.table.convertRowIndexToModel(r);
                    LocalPost lp = PostPanel.this.PostTableModel.getPost(r);
                    if (lp != null) {
                        LocalNetwork ln = null;
                        DataBaseCoreImpl dataBaseCoreImpl = PostPanel.this.Mn.getCoreDB();
                        synchronized (dataBaseCoreImpl) {
                            ln = PostPanel.this.Mn.getCoreDB().getLocalNetwork(lp.getPost().getNetworkId());
                        }
                        if (ln != null) {
                            PostPanel.this.MessageDialog.showDialog(lp.getPost().getSignedDigest().getPeerIdentifier(), lp.getCreator(), lp.getPost().getNetworkId(), ln.getNetwork().getTitleSig());
                        }
                    }
                }
            }
        });
        JMenuItem redownload = new JMenuItem("Reset Downloads");
        mnu.add(redownload);
        redownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int[] selr = PostPanel.this.table.getSelectedRows();
                int c = 0;
                while (c < selr.length) {
                    FileStatus fs;
                    int r = selr[c];
                    r = PostPanel.this.table.convertRowIndexToModel(r);
                    LocalPost lp = PostPanel.this.PostTableModel.getPost(r);
                    if (lp != null && (fs = PostPanel.this.Mn.getCoreDB().getFileStatus(lp.getPost().getNetworkId(), lp.getPost().getFileReferenceDigest())) != null) {
                        PostPanel.this.Mn.getFileHandler().reDownloadFile(fs);
                    }
                    ++c;
                }
            }
        });
        this.table.setComponentPopupMenu(mnu);
    }

    @Override
    public void setSelectedNetwork(LocalNetwork network, LocalNetworkAuthorization auth) {
        this.SearchPanel.setSelectedNetwork(network, auth);
    }

    public NewPeerMessageDialog getMessageDialog() {
        return this.MessageDialog;
    }

    public void setMessageDialog(NewPeerMessageDialog messageDialog) {
        this.MessageDialog = messageDialog;
    }
}

