/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.sql.Date;
import javax.swing.table.AbstractTableModel;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalPeer;

public class PeerTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private QueryResultsInterface Peers;
    private String[] ColumnNames = new String[]{"Nickname", "Introduction", "Date"};

    @Override
    public String getColumnName(int col) {
        return this.ColumnNames[col];
    }

    public Class getColumnClass(int col) {
        if (col == 2) {
            return Date.class;
        }
        if (col == 3) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.ColumnNames.length;
    }

    @Override
    public synchronized int getRowCount() {
        if (this.Peers != null) {
            return this.Peers.size();
        }
        return 0;
    }

    public synchronized LocalPeer getPeer(int r) {
        if (this.Peers != null && r < this.Peers.size()) {
            return (LocalPeer)this.Peers.get(r);
        }
        return null;
    }

    @Override
    public Object getValueAt(int r, int c) {
        LocalPeer lp = this.getPeer(r);
        if (lp != null) {
            if (c == 0) {
                return lp.getPeer().getNickSig();
            }
            if (c == 1) {
                return lp.getPeer().getIntroduction();
            }
            if (c == 2) {
                return lp.getLocalDate();
            }
        }
        return null;
    }

    public synchronized void setPeers(QueryResultsInterface p) {
        if (this.Peers != null) {
            this.Peers.Close();
        }
        this.Peers = p;
        this.fireTableDataChanged();
    }
}

