/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.ui.Main;
import org.ourfilesystem.ui.NetworkSelectInterface;
import org.ourfilesystem.ui.NewPeerMessageDialog;
import org.ourfilesystem.ui.PeerTableModel;
import org.ourfilesystem.ui.SignDialogs;

public class PeerPanel
extends JPanel
implements NetworkSelectInterface {
    private static final long serialVersionUID = 1L;
    private JTextField textField;
    private PeerTableModel Model;
    private Main Mn;
    private JTable table;
    private JLabel lblSelected;
    private LocalNetwork CurNetwork;
    private LocalNetworkAuthorization CurAuth;
    private NewPeerMessageDialog PeerMessageDialog;
    private SignDialogs SignDialogs;

    public void doSearch() {
        QueryResultsInterface qr = this.Mn.getCoreDB().getDBQuery().searchPeers(this.textField.getText(), null, 1000, true);
        this.Model.setPeers(qr);
    }

    public PeerPanel(Main m) {
        this.Mn = m;
        this.Model = new PeerTableModel();
        this.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOrientation(0);
        this.add((Component)splitPane, "Center");
        JPanel panel = new JPanel();
        splitPane.setLeftComponent(panel);
        panel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][]"));
        JLabel lblSel = new JLabel("Selected group:");
        panel.add((Component)lblSel, "cell 0 0");
        this.lblSelected = new JLabel("none");
        panel.add((Component)this.lblSelected, "flowx,cell 1 0,growx");
        JButton btnUpdatePeersNow = new JButton("Update Peers Now");
        panel.add((Component)btnUpdatePeersNow, "cell 1 0,alignx right");
        btnUpdatePeersNow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PeerPanel.this.Mn.getCoreUser().updatePeers(10L);
            }
        });
        JLabel lblSearch = new JLabel("Search");
        panel.add((Component)lblSearch, "cell 0 1,alignx trailing");
        this.textField = new JTextField();
        panel.add((Component)this.textField, "flowx,cell 1 1,growx");
        this.textField.setColumns(10);
        JButton btnSearch = new JButton("Search");
        panel.add((Component)btnSearch, "cell 1 1");
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PeerPanel.this.doSearch();
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        splitPane.setRightComponent(scrollPane);
        this.table = new JTable(this.Model);
        this.table.setAutoCreateRowSorter(true);
        scrollPane.setViewportView(this.table);
        this.SignDialogs = new SignDialogs(this.Mn, this.table);
        JPopupMenu mnu = new JPopupMenu();
        JMenuItem pmsg = new JMenuItem("Send Private Message");
        pmsg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!PeerPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PeerPanel.this.table.getSelectedRow();
                    r = PeerPanel.this.table.convertRowIndexToModel(r);
                    LocalPeer peer = PeerPanel.this.Model.getPeer(r);
                    if (peer != null) {
                        PeerPanel.this.PeerMessageDialog.showDialog(peer.getPeer().getIdentity(), peer.getPeer().getNickSig(), null, "");
                    }
                }
            }
        });
        mnu.add(pmsg);
        JMenuItem sgn = new JMenuItem("Grant Group Authorization");
        mnu.add(sgn);
        sgn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!PeerPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PeerPanel.this.table.getSelectedRow();
                    r = PeerPanel.this.table.convertRowIndexToModel(r);
                    LocalPeer peer = PeerPanel.this.Model.getPeer(r);
                    PeerPanel.this.SignDialogs.setCurAuth(PeerPanel.this.CurAuth);
                    PeerPanel.this.SignDialogs.setPeer(peer);
                    PeerPanel.this.SignDialogs.sign();
                } else {
                    JOptionPane.showMessageDialog(PeerPanel.this.table, "Select a peer first.", "No peer selected", 2);
                }
            }
        });
        this.table.setComponentPopupMenu(mnu);
        this.doSearch();
    }

    @Override
    public void setSelectedNetwork(LocalNetwork network, LocalNetworkAuthorization auth) {
        this.CurNetwork = network;
        this.CurAuth = auth;
        this.lblSelected.setText(this.CurNetwork.getNetwork().getTitleSig());
    }

    public NewPeerMessageDialog getPeerMessageDialog() {
        return this.PeerMessageDialog;
    }

    public void setPeerMessageDialog(NewPeerMessageDialog peerMessageDialog) {
        this.PeerMessageDialog = peerMessageDialog;
    }
}

