/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.security;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.ourfilesystem.db.so.Network;
import org.ourfilesystem.db.so.NetworkAuthorization;
import org.ourfilesystem.db.so.Peer;
import org.ourfilesystem.db.so.Post;
import org.ourfilesystem.db.so.PublicPost;
import org.ourfilesystem.security.CryptoDataBaseInterface;
import org.ourfilesystem.security.KeySet;
import org.ourfilesystem.security.PublicKeySet;
import org.ourfilesystem.security.SecurityTools;
import org.ourfilesystem.utilities.BBytes;

public class CryptoDataBaseImpl
implements CryptoDataBaseInterface {
    public static final Logger Log = Logger.getLogger(CryptoDataBaseImpl.class.getName());

    @Override
    public KeySet generateNewKeys() {
        return SecurityTools.generateKeySet();
    }

    @Override
    public boolean digEquals(BBytes id0, BBytes id1) {
        return id0.equals(id1);
    }

    @Override
    public void signLocation(Peer p, Object privkey) {
        SecurityTools.genIdentity(p);
        SecurityTools.signPeerLocation(p, (RSAPrivateCrtKeyParameters)privkey);
    }

    @Override
    public boolean verifyIdentity(Peer p) {
        return SecurityTools.verifyIdentity(p);
    }

    @Override
    public boolean verifyLocation(Peer p, Object pub) {
        return SecurityTools.verifyPeerLocation(p, (PublicKeySet)pub);
    }

    @Override
    public Post signPost(Post p, BBytes peerid, Object privkey) {
        SecurityTools.signPost(p, peerid, (RSAPrivateCrtKeyParameters)privkey);
        return p;
    }

    @Override
    public boolean verifyPost(Post p, Object pubkey) {
        return SecurityTools.verifyPost(p, (PublicKeySet)pubkey);
    }

    @Override
    public PublicPost signPublicPost(PublicPost p, BBytes peerid, Object privkey) {
        SecurityTools.signPublicPost(p, peerid, (RSAPrivateCrtKeyParameters)privkey);
        return p;
    }

    @Override
    public boolean verifyPublicPost(PublicPost p, Object pubkey) {
        return SecurityTools.verifyPublicPost(p, (PublicKeySet)pubkey);
    }

    @Override
    public Network signNetwork(Network n, BBytes peerid, Object privkey) {
        SecurityTools.signNetwork(n, peerid, (RSAPrivateCrtKeyParameters)privkey);
        return n;
    }

    @Override
    public boolean verifyNetwork(Network n, Object pubkey) {
        return SecurityTools.verifyNetwork(n, (PublicKeySet)pubkey);
    }

    @Override
    public NetworkAuthorization signNetworkAuthorization(NetworkAuthorization n, BBytes peerid, Object privkey) {
        SecurityTools.signNetworkAuth(n, peerid, (RSAPrivateCrtKeyParameters)privkey);
        return n;
    }

    @Override
    public boolean verifyNetworkAuthorization(NetworkAuthorization n, Object pubkey) {
        return SecurityTools.verifyNetworkAuth(n, (PublicKeySet)pubkey);
    }

    @Override
    public BBytes digestFile(File f) {
        try {
            return SecurityTools.digestFile(f, 0L, f.length());
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.severe("Could not digest file: " + f + ": " + e.getMessage());
            return null;
        }
    }

    @Override
    public BBytes digestFile(File f, long offset, long size) {
        try {
            return SecurityTools.digestFile(f, offset, size);
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.severe("Could not digest file: " + f + ": " + e.getMessage());
            return null;
        }
    }

    @Override
    public Object encodePublicPost(Object rawmessage, Object pubkey) {
        String msg = (String)rawmessage;
        return SecurityTools.encodePublicPost(msg, (PublicKeySet)pubkey);
    }

    @Override
    public Object decodePublicPost(Object encmessage, Object privkey) {
        BBytes bmsg = (BBytes)encmessage;
        return SecurityTools.decodePublicPost(bmsg, (RSAPrivateCrtKeyParameters)privkey);
    }
}

