/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.db;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Constraint;
import com.db4o.query.Query;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.ourfilesystem.db.DataBaseCoreImpl;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalPeer;

public class PeerQueryResultsImpl
implements QueryResultsInterface {
    private ObjectContainer DB;
    private TopDocs CurDocs;
    private IndexSearcher Searcher;
    private DirectoryReader Reader;

    public PeerQueryResultsImpl(TopDocs t, IndexSearcher s, DirectoryReader reader, ObjectContainer d) {
        this.CurDocs = t;
        this.Reader = reader;
        this.Searcher = s;
        this.DB = d;
    }

    @Override
    public void Close() {
        try {
            this.Reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int size() {
        return this.CurDocs.totalHits;
    }

    @Override
    public Object get(int i) {
        if (i >= 0 && i < this.CurDocs.scoreDocs.length) {
            ScoreDoc sd = this.CurDocs.scoreDocs[i];
            try {
                Document d = this.Searcher.doc(sd.doc);
                StoredField lf0 = (StoredField)d.getField(DataBaseCoreImpl.PEER_ID0);
                StoredField lf1 = (StoredField)d.getField(DataBaseCoreImpl.PEER_ID1);
                if (lf0 != null && lf1 != null) {
                    long id0 = lf0.numericValue().longValue();
                    long id1 = lf1.numericValue().longValue();
                    Query q = this.DB.query();
                    q.constrain(LocalPeer.class);
                    Constraint c0 = q.descend("Peer").descend("Identity").descend("Index0").constrain((Object)id0);
                    q.descend("Peer").descend("Identity").descend("Index1").constrain((Object)id1).and(c0);
                    ObjectSet osa = q.execute();
                    if (osa.size() > 0) {
                        return osa.get(0);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

