/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.core;

import java.util.LinkedList;
import java.util.List;
import org.ourfilesystem.com.ConnectionUpdateInterface;
import org.ourfilesystem.core.EventInterface;
import org.ourfilesystem.db.so.FileReference;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.db.so.LocalPost;
import org.ourfilesystem.db.so.LocalPublicPost;
import org.ourfilesystem.db.so.Peer;

public class EventDispatcher
implements EventInterface {
    private List<EventInterface> Events = new LinkedList<EventInterface>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(EventInterface e) {
        List<EventInterface> list = this.Events;
        synchronized (list) {
            this.Events.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<EventInterface> getEventList() {
        LinkedList<EventInterface> r = new LinkedList<EventInterface>();
        List<EventInterface> list = this.Events;
        synchronized (list) {
            r.addAll(this.Events);
        }
        return r;
    }

    @Override
    public void newPostReceived(LocalPost post) {
        List<EventInterface> r = this.getEventList();
        for (EventInterface e : r) {
            e.newPostReceived(post);
        }
    }

    @Override
    public void newPublicPostReceived(LocalPublicPost post) {
        List<EventInterface> r = this.getEventList();
        for (EventInterface e : r) {
            e.newPublicPostReceived(post);
        }
    }

    @Override
    public void newNetworkReceived(LocalNetwork network) {
        List<EventInterface> r = this.getEventList();
        for (EventInterface e : r) {
            e.newNetworkReceived(network);
        }
    }

    @Override
    public void newNetworkAuthReceived(LocalNetworkAuthorization auth) {
        List<EventInterface> r = this.getEventList();
        for (EventInterface e : r) {
            e.newNetworkAuthReceived(auth);
        }
    }

    @Override
    public void newPeerReceived(LocalPeer peer) {
        List<EventInterface> r = this.getEventList();
        for (EventInterface e : r) {
            e.newPeerReceived(peer);
        }
    }

    @Override
    public void newFileDownloaded(FileReference filelist) {
        List<EventInterface> r = this.getEventList();
        for (EventInterface e : r) {
            e.newFileDownloaded(filelist);
        }
    }

    @Override
    public void downloadFailed(Object dig) {
        List<EventInterface> r = this.getEventList();
        for (EventInterface e : r) {
            e.downloadFailed(dig);
        }
    }

    @Override
    public void connectionEvent(ConnectionUpdateInterface con) {
        List<EventInterface> r = this.getEventList();
        for (EventInterface e : r) {
            e.connectionEvent(con);
        }
    }

    @Override
    public void connectionFailure(Peer p) {
        List<EventInterface> r = this.getEventList();
        for (EventInterface e : r) {
            e.connectionFailure(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListeners(ConnectionUpdateInterface c) {
        List<EventInterface> list = this.Events;
        synchronized (list) {
            for (EventInterface e : this.Events) {
                c.addEventInterface(e);
            }
        }
    }
}

