/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.ourfilesystem.com.ComConnectionInterface;
import org.ourfilesystem.com.ComPeerInterface;
import org.ourfilesystem.core.CoreComInterface;
import org.ourfilesystem.core.CoreUserInterface;
import org.ourfilesystem.core.EventInterface;
import org.ourfilesystem.db.DataBaseCoreInterface;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.TimeInterface;
import org.ourfilesystem.db.so.FileReference;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.db.so.LocalPost;
import org.ourfilesystem.db.so.LocalPublicPost;
import org.ourfilesystem.db.so.MyPeerDataSO;
import org.ourfilesystem.db.so.Network;
import org.ourfilesystem.db.so.NetworkAuthorization;
import org.ourfilesystem.db.so.Peer;
import org.ourfilesystem.db.so.PeerHasFile;
import org.ourfilesystem.db.so.Post;
import org.ourfilesystem.db.so.PostMessage;
import org.ourfilesystem.db.so.PostTemplate;
import org.ourfilesystem.db.so.PublicPost;
import org.ourfilesystem.db.so.SearchQuery;
import org.ourfilesystem.security.CryptoDataBaseInterface;
import org.ourfilesystem.security.KeySet;
import org.ourfilesystem.utilities.BBytes;
import org.ourfilesystem.utilities.DumbMIME;
import org.ourfilesystem.utilities.FileUtils;

public class CoreUserImpl
implements CoreUserInterface {
    public static final Logger Log = Logger.getLogger(CoreUserImpl.class.getName());
    private DataBaseCoreInterface CoreDB;
    private CryptoDataBaseInterface Crypto;
    private TimeInterface Time;
    private EventInterface Event;
    private CoreComInterface CoreCom;
    private ComConnectionInterface Com;
    private File TemplateDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadFile(BBytes network, BBytes digest, File f, long offset, long size, boolean template, long priority) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            FileReference fr = this.CoreDB.getFile(network, digest, f, offset, size);
            if (fr == null) {
                Log.info("FileReference did not already exist.  Creating.");
                fr = new FileReference();
                fr.setNetworkId(new BBytes(network));
                fr.setUnsignedDigest(new BBytes(digest));
                fr.setLocalDate(this.Time.getTime());
                fr.setOffset(offset);
                fr.setSize(size);
                fr.setFile(new File(f.getPath()));
                fr.setTemplate(template);
            } else {
                Log.info("FileReference already existed.");
            }
            File of = fr.getFile();
            if (of != null && of.exists()) {
                Log.info("File already existed.  Checking if it's already got the correct data.");
                BBytes tdig = this.Crypto.digestFile(of, offset, size);
                if (tdig.equals(digest)) {
                    Log.info("The existing file already had the correct data.");
                    if (this.Event != null) {
                        this.Event.newFileDownloaded(fr);
                    }
                    return;
                }
            }
            List<FileReference> fr2 = this.CoreDB.getFiles(network, digest);
            for (FileReference of2 : fr2) {
                BBytes tdig;
                File tf2 = of2.getFile();
                if (!tf2.exists() || !(tdig = this.Crypto.digestFile(tf2, of2.getOffset(), of2.getSize())).equals(digest) || of2.getSize() != size) continue;
                try {
                    FileUtils.copyFile(tf2, of, of2.getOffset(), offset, size);
                    Log.info("Copied from another file already in the network.");
                    if (this.Event != null) {
                        this.Event.newFileDownloaded(fr);
                    }
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Log.info("The file does not exist, or the data is not correct.  Request download.");
            fr.setUserRequested(true);
            fr.setUserRequestDispatched(false);
            fr.setUserRequestTime(this.Time.getTime());
            fr.setUserRequestPriority(priority);
            this.CoreDB.saveFileReference(fr);
        }
        this.CoreCom.requestReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePeers(long priority) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            BBytes me = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
            List<LocalPeer> plst = this.CoreDB.getLocalPeers();
            for (LocalPeer lp : plst) {
                if (lp.getPeer().getIdentity().equals(me)) continue;
                lp.setRequestPeers(true);
                lp.setRequestPeersPriority(priority);
                lp.setRequestPeersTime(this.Time.getTime());
                this.CoreDB.saveLocalPeer(lp);
            }
        }
        this.CoreCom.requestReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNetworks(long priority) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            BBytes me = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
            List<LocalPeer> lst = this.CoreDB.getLocalPeers();
            for (LocalPeer lp : lst) {
                if (lp.getPeer().getIdentity().equals(me)) continue;
                lp.setRequestNetworks(true);
                lp.setRequestNetworksDispatched(false);
                lp.setRequestNetworksPriority(priority);
                lp.setRequestNetworksTime(this.Time.getTime());
                this.CoreDB.saveLocalPeer(lp);
            }
        }
        this.CoreCom.requestReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePublicPosts(long priority) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            BBytes me = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
            List<LocalPeer> lst = this.CoreDB.getLocalPeers();
            for (LocalPeer lp : lst) {
                if (lp.getPeer().getIdentity().equals(me)) continue;
                lp.setRequestPublicPosts(true);
                lp.setRequestPublicPostsDispatched(false);
                lp.setRequestPublicPostsPriority(priority);
                lp.setRequestPublicPostsTime(this.Time.getTime());
                this.CoreDB.saveLocalPeer(lp);
            }
        }
        this.CoreCom.requestReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNetworkAuths(BBytes networkid, long priority) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            BBytes me = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
            List<LocalNetworkAuthorization> lst = this.CoreDB.getNetworkAuths(networkid);
            for (LocalNetworkAuthorization l : lst) {
                if (l.isMarkedBad() || l.getNetworkAuthorization().getPeerId().equals(me)) continue;
                Log.info("Update network auths : " + l.getNetworkAuthorization().getNetworkId() + " peer: " + l.getNetworkAuthorization().getPeerId());
                l.setRequestAuths(true);
                l.setRequestAuthsDispatched(false);
                l.setRequestAuthsPriority(priority);
                l.setRequestAuthsTime(this.Time.getTime());
                this.CoreDB.saveLocalNetworkAuth(l);
            }
        }
        this.CoreCom.requestReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePosts(BBytes networkid, long priority) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            BBytes me = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
            List<LocalNetworkAuthorization> lst = this.CoreDB.getNetworkAuths(networkid);
            for (LocalNetworkAuthorization l : lst) {
                if (l.isMarkedBad() || l.getNetworkAuthorization().getPeerId().equals(me)) continue;
                l.setRequestPosts(true);
                l.setRequestPostsDispatched(false);
                l.setRequestPostsPriority(priority);
                l.setRequestPostsTime(this.Time.getTime());
                this.CoreDB.saveLocalNetworkAuth(l);
            }
        }
        this.CoreCom.requestReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalPost addLocalPost(BBytes networkid, Object message, BBytes fileref) {
        MyPeerDataSO mp = this.getMyPeerData();
        BBytes peerid = mp.getPeer().getPeer().getIdentity();
        LocalNetworkAuthorization na = null;
        LocalPost lp = null;
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            block15: {
                na = this.CoreDB.getNetworkAuth(networkid, peerid);
                if (na != null && this.CoreCom.verifyNetworkAuthChain(na.getNetworkAuthorization())) break block15;
                return null;
            }
            Post p = new Post();
            if (fileref != null) {
                p.setFileReferenceDigest(new BBytes(fileref));
            }
            p.setMessage(message);
            p.setNetworkId(new BBytes(networkid));
            p.setPosterHasFile(false);
            long number = na.getLastPostNumber();
            na.setLastPostNumber(++number);
            this.CoreDB.saveLocalNetworkAuth(na);
            p.setPostNumber(number);
            if (fileref != null) {
                PeerHasFile ph;
                List<FileReference> frl = this.CoreDB.getFiles(networkid, fileref);
                Iterator<FileReference> i = frl.iterator();
                boolean filefound = false;
                while (i.hasNext() && !filefound) {
                    FileReference fr = i.next();
                    if (fr.getFile() != null && fr.getFile().exists()) {
                        if (this.Crypto.digestFile(fr.getFile(), fr.getOffset(), fr.getSize()).equals(fileref)) {
                            filefound = true;
                            if (fr.isExists()) continue;
                            fr.setExists(true);
                            this.CoreDB.saveFileReference(fr);
                            continue;
                        }
                        if (!fr.isExists()) continue;
                        fr.setExists(false);
                        this.CoreDB.saveFileReference(fr);
                        continue;
                    }
                    if (!fr.isExists()) continue;
                    fr.setExists(false);
                    this.CoreDB.saveFileReference(fr);
                }
                if (filefound) {
                    p.setPosterHasFile(true);
                    ph = this.CoreDB.getPeerHasFile(networkid, peerid, fileref);
                    if (ph == null) {
                        ph = new PeerHasFile();
                        ph.setDigest(new BBytes(fileref));
                        ph.setNetworkId(new BBytes(networkid));
                        ph.setPeerId(new BBytes(peerid));
                        ph.setPeerHasFile(true);
                        ph.setLastMessage(p.getPostNumber());
                        this.CoreDB.savePeerHasFile(ph);
                    } else if (!ph.isPeerHasFile()) {
                        ph.setPeerHasFile(true);
                        ph.setLastMessage(p.getPostNumber());
                        this.CoreDB.savePeerHasFile(ph);
                    }
                } else {
                    ph = this.CoreDB.getPeerHasFile(networkid, peerid, fileref);
                    if (ph != null) {
                        ph.setPeerHasFile(false);
                        ph.setLastMessage(p.getPostNumber());
                        this.CoreDB.savePeerHasFile(ph);
                    }
                }
            }
            this.Crypto.signPost(p, mp.getPeer().getPeer().getIdentity(), mp.getKeySet().getPrivateSigningKey());
            lp = new LocalPost();
            lp.setPeerRank(na.getPeerRank());
            lp.setCreator(mp.getPeer().getPeer().getNickSig());
            lp.setLocalDate(this.Time.getTime());
            lp.setPeerRank(na.getPeerRank());
            lp.setPost(p);
            this.CoreDB.saveLocalPost(lp);
            this.CoreCom.pushPost(p);
        }
        return lp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalPost addLocalFile(BBytes networkid, File f, long offset, long size, Object message) {
        if (f != null && f.exists()) {
            BBytes dig = this.Crypto.digestFile(f, offset, size);
            FileReference fr = new FileReference();
            fr.setFile(new File(f.getPath()));
            fr.setLocalDate(this.Time.getTime());
            fr.setNetworkId(new BBytes(networkid));
            fr.setOffset(offset);
            fr.setSize(size);
            fr.setUnsignedDigest(dig);
            fr.setExists(true);
            DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
            synchronized (dataBaseCoreInterface) {
                this.CoreDB.saveFileReference(fr);
            }
            LocalPost lp = this.addLocalPost(networkid, message, dig);
            return lp;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalNetwork addLocalNetwork(String title, String description) {
        Network n = new Network();
        n.setDescription(description);
        n.setTitle(title);
        MyPeerDataSO mp = this.getMyPeerData();
        if (mp == null) {
            return null;
        }
        long netnum = mp.getPeer().getLastNetworkNumber();
        n.setNetworkNumber(++netnum);
        this.Crypto.signNetwork(n, mp.getPeer().getPeer().getIdentity(), mp.getKeySet().getPrivateSigningKey());
        mp.getPeer().setLastNetworkNumber(netnum);
        BBytes myid = mp.getPeer().getPeer().getIdentity();
        NetworkAuthorization newa = new NetworkAuthorization();
        newa.setNetworkId(new BBytes(n.getSignature().getDigest()));
        newa.setPeerId(new BBytes(myid));
        newa.setSignAuthority(NetworkAuthorization.CANGIVESIGNAUTH);
        this.Crypto.signNetworkAuthorization(newa, myid, mp.getKeySet().getPrivateSigningKey());
        LocalNetwork ln = null;
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            this.CoreDB.saveMyPeerData(mp);
            ln = new LocalNetwork();
            ln.setLocalDate(this.Time.getTime());
            ln.setNetwork(n);
            ln.setCreator(mp.getPeer().getPeer().getNickSig());
            ln.setAuthorization(NetworkAuthorization.CANGIVESIGNAUTH);
            ln.setAuthorized(true);
            this.CoreDB.saveLocalNetwork(ln);
            LocalNetworkAuthorization lna = new LocalNetworkAuthorization();
            lna.setNetworkAuthorization(newa);
            lna.setLocalDate(this.Time.getTime());
            lna.setLastNewAuths(this.Time.getTime());
            lna.setLastNewFile(this.Time.getTime());
            lna.setLocalDate(this.Time.getTime());
            lna.setMarkedBadDate(null);
            lna.setMarkedBad(false);
            lna.setNetworkTitle(n.getTitleSig());
            lna.setPeerNickSig(mp.getPeer().getPeer().getNickSig());
            lna.setSignerNickSig(mp.getPeer().getPeer().getNickSig());
            this.CoreDB.saveLocalNetworkAuth(lna);
        }
        this.CoreCom.pushNetwork(n);
        this.CoreCom.pushNetworkAuth(newa);
        return ln;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalPublicPost addLocalPublicPost(BBytes network, Object message, BBytes encode4peer) {
        MyPeerDataSO mp;
        PublicPost pp = new PublicPost();
        pp.setMessage(message);
        if (network != null) {
            pp.setNetworkId(new BBytes(network));
        }
        if ((mp = this.getMyPeerData()) == null) {
            return null;
        }
        long pubnum = mp.getPeer().getLastPublicPostNumber();
        mp.getPeer().setLastPublicPostNumber(++pubnum);
        LocalPublicPost lpp = null;
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            this.CoreDB.saveMyPeerData(mp);
            pp.setPostNumber(pubnum);
            lpp = new LocalPublicPost();
            lpp.setLocalDate(this.Time.getTime());
            lpp.setPublicPost(pp);
            lpp.setCreator(mp.getPeer().getPeer().getNickSig());
            lpp.setPrivateMessage(false);
            if (network != null) {
                LocalNetwork ln = this.CoreDB.getLocalNetwork(network);
                lpp.setNetworkTitle(ln.getNetwork().getTitleSig());
            }
            if (encode4peer != null) {
                LocalPeer ep = this.CoreDB.getPeer(encode4peer);
                if (ep != null) {
                    Object encmsg = this.Crypto.encodePublicPost(message, ep.getPeer().getPeerKeys());
                    Log.info("Encrypted public post message.");
                    pp.setEncrypted(true);
                    pp.setMessage(encmsg);
                    lpp.setDecodedMessage(message);
                    lpp.setToPeer(ep.getPeer().getNickSig());
                    lpp.setPrivateMessage(true);
                    this.Crypto.signPublicPost(pp, mp.getPeer().getPeer().getIdentity(), mp.getKeySet().getPrivateSigningKey());
                    this.CoreDB.saveLocalPublicPost(lpp);
                    this.CoreCom.pushPublicPost(pp);
                    return lpp;
                }
            } else {
                pp.setEncrypted(false);
                this.Crypto.signPublicPost(pp, mp.getPeer().getPeer().getIdentity(), mp.getKeySet().getPrivateSigningKey());
                this.CoreDB.saveLocalPublicPost(lpp);
                this.CoreCom.pushPublicPost(pp);
                return lpp;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalNetworkAuthorization signPeer(BBytes network, LocalPeer peerdata, int authority) {
        MyPeerDataSO mp = this.getMyPeerData();
        if (mp == null) {
            return null;
        }
        BBytes networkid = network;
        BBytes myid = mp.getPeer().getPeer().getIdentity();
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalNetworkAuthorization na = this.CoreDB.getNetworkAuth(networkid, myid);
            LocalNetwork net = this.CoreDB.getLocalNetwork(networkid);
            Log.info("Existing NetworkAuthorization: " + na);
            if (net != null && na != null && na.getNetworkAuthorization().getSignAuthority() > 0 && this.CoreCom.verifyNetworkAuthChain(na.getNetworkAuthorization())) {
                int myauth = na.getNetworkAuthorization().getSignAuthority();
                if (myauth == NetworkAuthorization.CANGIVESIGNAUTH || myauth > authority) {
                    NetworkAuthorization newa = new NetworkAuthorization();
                    Log.info("Signing peer: " + peerdata.getPeer().getIdentity() + " for network: " + networkid);
                    newa.setNetworkId(new BBytes(networkid));
                    newa.setPeerId(new BBytes(peerdata.getPeer().getIdentity()));
                    newa.setSignAuthority(authority);
                    long lnum = na.getLastNetworkAuthNumber();
                    na.setLastNetworkAuthNumber(++lnum);
                    this.CoreDB.saveLocalNetworkAuth(na);
                    this.Crypto.signNetworkAuthorization(newa, myid, mp.getKeySet().getPrivateSigningKey());
                    LocalNetworkAuthorization lna = new LocalNetworkAuthorization();
                    lna.setNetworkAuthorization(newa);
                    lna.setLocalDate(this.Time.getTime());
                    lna.setNetworkTitle(net.getNetwork().getTitleSig());
                    lna.setPeerNickSig(peerdata.getPeer().getNickSig());
                    lna.setSignerNickSig(mp.getPeer().getPeer().getNickSig());
                    this.CoreDB.saveLocalNetworkAuth(lna);
                    ComPeerInterface c = this.Com.getComPeerInterface(peerdata.getPeer());
                    this.CoreCom.newConnection(c, true);
                    this.CoreCom.pushNetworkAuth(na.getNetworkAuthorization());
                    this.CoreCom.pushNetworkAuth(newa);
                    return lna;
                }
            } else {
                LocalNetwork n = this.CoreDB.getLocalNetwork(network);
                Log.info("Existing network found: " + n);
                if (n != null && n.getNetwork().getSignature().getPeerIdentifier().equals(myid)) {
                    Log.info("Signing for my own network.");
                    NetworkAuthorization newa = new NetworkAuthorization();
                    newa.setNetworkId(new BBytes(networkid));
                    newa.setPeerId(new BBytes(peerdata.getPeer().getIdentity()));
                    newa.setSignAuthority(authority);
                    long lnum = na.getLastNetworkAuthNumber();
                    na.setLastNetworkAuthNumber(++lnum);
                    this.CoreDB.saveLocalNetworkAuth(na);
                    this.Crypto.signNetworkAuthorization(newa, myid, mp.getKeySet().getPrivateSigningKey());
                    LocalNetworkAuthorization lna = new LocalNetworkAuthorization();
                    lna.setNetworkAuthorization(newa);
                    lna.setLocalDate(this.Time.getTime());
                    this.CoreDB.saveLocalNetworkAuth(lna);
                    this.CoreCom.pushNetworkAuth(newa);
                    return lna;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMyLocation(Object location) {
        MyPeerDataSO mp = this.getMyPeerData();
        if (mp == null) {
            return;
        }
        Peer p = mp.getPeer().getPeer();
        p.setLocation(location);
        this.Crypto.signLocation(p, mp.getKeySet().getPrivateSigningKey());
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            this.CoreDB.saveMyPeerData(mp);
        }
        this.CoreCom.pushPeer(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMyNickname(String nn) {
        MyPeerDataSO mp = this.getMyPeerData();
        if (mp == null) {
            return;
        }
        Peer p = mp.getPeer().getPeer();
        p.setNickname(nn);
        this.Crypto.signLocation(p, mp.getKeySet().getPrivateSigningKey());
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            this.CoreDB.saveMyPeerData(mp);
        }
        this.CoreCom.pushPeer(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMyIntroduction(String intro) {
        MyPeerDataSO mp = this.getMyPeerData();
        if (mp == null) {
            return;
        }
        Peer p = mp.getPeer().getPeer();
        p.setIntroduction(intro);
        this.Crypto.signLocation(p, mp.getKeySet().getPrivateSigningKey());
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            this.CoreDB.saveMyPeerData(mp);
        }
        this.CoreCom.pushPeer(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateNewKeys() {
        MyPeerDataSO mp = this.getMyPeerData();
        if (mp == null) {
            mp = new MyPeerDataSO();
        }
        KeySet ks = this.Crypto.generateNewKeys();
        mp.setKeySet(ks);
        if (mp.getPeer() == null) {
            mp.setPeer(new LocalPeer());
        }
        if (mp.getPeer().getPeer() == null) {
            mp.getPeer().setPeer(new Peer());
        }
        Date curtime = this.Time.getTime();
        mp.getPeer().getPeer().setPeerKeys(ks.getPublicKeySet());
        mp.getPeer().setLastConnectionTime(curtime);
        mp.getPeer().setLastNewNetwork(curtime);
        mp.getPeer().setLastNewPeer(curtime);
        mp.getPeer().setLastNewPublicPost(curtime);
        mp.getPeer().setLastSuccessRequest(curtime);
        mp.getPeer().setLocalDate(curtime);
        this.Crypto.signLocation(mp.getPeer().getPeer(), ks.getPrivateSigningKey());
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            this.CoreDB.saveMyPeerData(mp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MyPeerDataSO getMyPeerData() {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            return this.CoreDB.getMyPeerData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBadPeer(LocalPeer id) {
        if (id != null && id.getPeer() != null) {
            DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
            synchronized (dataBaseCoreInterface) {
                List<LocalNetworkAuthorization> nalst = this.CoreDB.getPeerNetworkAuths(id.getPeer().getIdentity());
                for (LocalNetworkAuthorization na : nalst) {
                    this.setBadPeer(na);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBadPeer(BBytes network, BBytes peerid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalNetworkAuthorization lna = this.CoreDB.getNetworkAuth(network, peerid);
            this.setBadPeer(lna);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBadPeer(LocalNetworkAuthorization lna) {
        if (lna != null) {
            DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
            synchronized (dataBaseCoreInterface) {
                BBytes me = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
                if (!lna.getNetworkAuthorization().getPeerId().equals(me)) {
                    lna.setMarkedBad(true);
                    this.CoreDB.saveLocalNetworkAuth(lna);
                    BBytes netid = lna.getNetworkAuthorization().getNetworkId();
                    BBytes peerid = lna.getNetworkAuthorization().getPeerId();
                    List<LocalNetworkAuthorization> ml = this.CoreDB.getNetworkAuthsSignedBy(netid, peerid);
                    for (LocalNetworkAuthorization na : ml) {
                        this.setBadPeer(na);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDownloadPriority(File f, long priority) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            List<FileReference> flst = this.CoreDB.getFilesForFile(f);
            for (FileReference fr : flst) {
                fr.setUserRequestPriority(priority);
                this.CoreDB.saveFileReference(fr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelDownload(File f) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            List<FileReference> flst = this.CoreDB.getFilesForFile(f);
            for (FileReference fr : flst) {
                fr.setUserRequested(false);
                this.CoreDB.saveFileReference(fr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelUpdatePeers() {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            List<LocalPeer> plst = this.CoreDB.getLocalPeers();
            for (LocalPeer lp : plst) {
                lp.setRequestPeers(false);
                this.CoreDB.saveLocalPeer(lp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelUpdateNetworks() {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            List<LocalPeer> lst = this.CoreDB.getLocalPeers();
            for (LocalPeer lp : lst) {
                lp.setRequestNetworks(false);
                this.CoreDB.saveLocalPeer(lp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelUpdatePublicPosts() {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            List<LocalPeer> lst = this.CoreDB.getLocalPeers();
            for (LocalPeer lp : lst) {
                lp.setRequestPublicPosts(false);
                this.CoreDB.saveLocalPeer(lp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelUpdateNetworkAuths(BBytes networkid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            List<LocalNetworkAuthorization> lst = this.CoreDB.getNetworkAuths(networkid);
            for (LocalNetworkAuthorization l : lst) {
                if (l.isMarkedBad()) continue;
                l.setRequestAuths(false);
                this.CoreDB.saveLocalNetworkAuth(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelUpdatePosts(BBytes network) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            List<LocalNetworkAuthorization> lst = this.CoreDB.getNetworkAuths(network);
            for (LocalNetworkAuthorization l : lst) {
                if (l.isMarkedBad()) continue;
                l.setRequestPosts(false);
                this.CoreDB.saveLocalNetworkAuth(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile(File f) {
        this.cancelDownload(f);
        f.delete();
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            MyPeerDataSO myp = this.CoreDB.getMyPeerData();
            BBytes pid = myp.getPeer().getPeer().getIdentity();
            List<FileReference> files = this.CoreDB.getFilesForFile(f);
            for (FileReference fr : files) {
                this.CoreCom.requestFile(pid, fr.getNetworkId(), fr.getUnsignedDigest());
            }
        }
    }

    public void setCoreDB(DataBaseCoreInterface coreDB) {
        this.CoreDB = coreDB;
    }

    public void setCrypto(CryptoDataBaseInterface crypto) {
        this.Crypto = crypto;
    }

    public void setTime(TimeInterface time) {
        this.Time = time;
    }

    public void setCoreCom(CoreComInterface coreCom) {
        this.CoreCom = coreCom;
    }

    public void setCom(ComConnectionInterface com) {
        this.Com = com;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalPeer addLocalPeer(Peer p) {
        if (this.Crypto.verifyIdentity(p)) {
            DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
            synchronized (dataBaseCoreInterface) {
                LocalPeer olp = this.CoreDB.getPeer(p.getIdentity());
                if (olp != null) {
                    if (olp.getPeer().getUpdateCount() < p.getUpdateCount() && this.Crypto.verifyLocation(p, olp.getPeer().getPeerKeys())) {
                        this.CoreDB.deletePeer(olp.getPeer(), false);
                        olp.setPeer(p);
                        olp.setPushRequested(false);
                        olp.setReceivedFromPeer(null);
                        this.CoreDB.saveLocalPeer(olp);
                        if (this.Event != null) {
                            this.Event.newPeerReceived(olp);
                        }
                    }
                } else if (this.Crypto.verifyLocation(p, p.getPeerKeys())) {
                    LocalPeer lp = new LocalPeer();
                    lp.setConnectionAttempts(0L);
                    lp.setLastConnectionTime(this.Time.getTime());
                    lp.setLastNetworkNumber(0L);
                    lp.setLastNewNetwork(this.Time.getTime());
                    lp.setLastNewPeer(this.Time.getTime());
                    lp.setLastNewPublicPost(this.Time.getTime());
                    lp.setLastPublicPostNumber(0L);
                    lp.setLastSuccessRequest(this.Time.getTime());
                    lp.setNumberOfNewNetworks(0L);
                    lp.setNumberOfNewPeers(0L);
                    lp.setNumberOfNewPublicPosts(0L);
                    lp.setRequestNetworks(false);
                    lp.setRequestNetworksDispatched(false);
                    lp.setRequestNetworksDispatchedTime(this.Time.getTime());
                    lp.setRequestNetworksPriority(0L);
                    lp.setRequestNetworksTime(this.Time.getTime());
                    lp.setRequestPeers(false);
                    lp.setRequestPeersPriority(0L);
                    lp.setRequestPeersTime(this.Time.getTime());
                    lp.setRequestPublicPosts(false);
                    lp.setRequestPublicPostsDispatched(false);
                    lp.setRequestPublicPostsDispatchedTime(this.Time.getTime());
                    lp.setRequestPublicPostsPriority(0L);
                    lp.setRequestPublicPostsTime(this.Time.getTime());
                    lp.setRequests(0L);
                    lp.setSuccessfulConnectionAttempts(0L);
                    lp.setSuccessfulRequests(0L);
                    lp.setPushRequested(false);
                    lp.setReceivedFromPeer(null);
                    lp.setPeer(p);
                    lp.setLocalDate(this.Time.getTime());
                    this.CoreDB.saveLocalPeer(lp);
                    if (this.Event != null) {
                        this.Event.newPeerReceived(lp);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            List<FileReference> l = this.CoreDB.getOrderedFilesRequestedAndDispatched();
            for (FileReference r : l) {
                r.setUserRequestDispatched(false);
                this.CoreDB.saveFileReference(r);
            }
            List<LocalPeer> lpl = this.CoreDB.getOrderedNetworksRequestedAndDispatched();
            for (LocalPeer lp : lpl) {
                lp.setRequestNetworksDispatched(false);
                this.CoreDB.saveLocalPeer(lp);
            }
            lpl = this.CoreDB.getOrderedPublicPostsRequestedAndDispatched();
            for (LocalPeer lp : lpl) {
                lp.setRequestPublicPostsDispatched(false);
                this.CoreDB.saveLocalPeer(lp);
            }
            List<LocalNetworkAuthorization> lll = this.CoreDB.getOrderedNetworkAuthsRequestedAndDispatched();
            for (LocalNetworkAuthorization ll : lll) {
                ll.setRequestAuthsDispatched(false);
                this.CoreDB.saveLocalNetworkAuth(ll);
            }
            lll = this.CoreDB.getOrderedPostsRequestedAndDispatched();
            for (LocalNetworkAuthorization ll : lll) {
                ll.setRequestPostsDispatched(false);
                this.CoreDB.saveLocalNetworkAuth(ll);
            }
        }
    }

    @Override
    public void addPostTemplate(PostTemplate pt) {
        try {
            File tmp = File.createTempFile("template", ".dat", this.TemplateDir);
            PostTemplate.writePostTemplate(tmp, pt);
            PostMessage pm = new PostMessage();
            pm.setTemplate(true);
            pm.setNum0(tmp.length());
            LocalPost lp = this.addLocalFile(pt.getNetworkId(), tmp, 0L, tmp.length(), pm);
            if (lp != null) {
                pt.setDigest(new BBytes(lp.getPost().getFileReferenceDigest()));
                this.CoreDB.saveTemplate(pt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public File getTemplateDir() {
        return this.TemplateDir;
    }

    public void setTemplateDir(File templateDir) {
        this.TemplateDir = templateDir;
    }

    @Override
    public void updatePeerNetworkRank(BBytes networkid, BBytes peerid, long rank) {
        LocalNetworkAuthorization lna = this.CoreDB.getNetworkAuth(networkid, peerid);
        if (lna != null) {
            lna.setPeerRank(rank);
            this.CoreDB.saveLocalNetworkAuth(lna);
            SearchQuery sq = new SearchQuery();
            sq.PeerId = peerid;
            sq.Network = networkid;
            QueryResultsInterface qr = this.CoreDB.getDBQuery().searchPosts(sq);
            int c = 0;
            while (c < qr.size()) {
                LocalPost lp = (LocalPost)qr.get(c);
                if (lp != null) {
                    lp.setPeerRank(rank);
                    this.CoreDB.saveLocalPost(lp);
                }
                ++c;
            }
        }
    }

    @Override
    public void setEventInterface(EventInterface e) {
        this.Event = e;
    }

    @Override
    public void writePeerFile(String outputfile) {
        try {
            File outfile = new File(outputfile);
            PrintWriter pw = new PrintWriter(outfile);
            List<Peer> pl = this.CoreDB.getPeers();
            for (Peer p : pl) {
                DumbMIME.writePeer2MIME(p, pw);
            }
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

