/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.core;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import org.ourfilesystem.com.ComConnectionInterface;
import org.ourfilesystem.com.ComPeerInterface;
import org.ourfilesystem.com.ConnectionUpdateInterface;
import org.ourfilesystem.core.CoreComInterface;
import org.ourfilesystem.core.CoreUserInterface;
import org.ourfilesystem.core.EventDispatcher;
import org.ourfilesystem.db.DataBaseCoreInterface;
import org.ourfilesystem.db.TimeInterface;
import org.ourfilesystem.db.so.FileReference;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.db.so.LocalPost;
import org.ourfilesystem.db.so.LocalPublicPost;
import org.ourfilesystem.db.so.MyPeerDataSO;
import org.ourfilesystem.db.so.Network;
import org.ourfilesystem.db.so.NetworkAuthHoles;
import org.ourfilesystem.db.so.NetworkAuthorization;
import org.ourfilesystem.db.so.NetworkHoles;
import org.ourfilesystem.db.so.Peer;
import org.ourfilesystem.db.so.PeerHasFile;
import org.ourfilesystem.db.so.Post;
import org.ourfilesystem.db.so.PostHoles;
import org.ourfilesystem.db.so.PostMessage;
import org.ourfilesystem.db.so.PostTemplate;
import org.ourfilesystem.db.so.PublicPost;
import org.ourfilesystem.db.so.PublicPostHoles;
import org.ourfilesystem.security.CryptoDataBaseInterface;
import org.ourfilesystem.utilities.BBytes;
import org.ourfilesystem.utilities.FileUtils;

public class CoreComImpl
implements CoreComInterface {
    public static final Logger Log = Logger.getLogger(CoreComImpl.class.getName());
    private CoreUserInterface CoreUser;
    private DataBaseCoreInterface CoreDB;
    private TimeInterface Time;
    private CryptoDataBaseInterface Crypto;
    private EventDispatcher Events;
    private ComConnectionInterface Com;
    private Map<BBytes, ComPeerInterface> Connections = new HashMap<BBytes, ComPeerInterface>();
    private int MaxConnections;
    private long TimeConnectedSteps;
    private int NumberTimeConnectedSteps;
    private long ReDispatchTime;
    private long ReConnectTime;
    private Random Random;
    private File TemplateDir;

    public void setMaxConnections(int maxConnections) {
        this.MaxConnections = maxConnections;
    }

    public void setCoreUser(CoreUserInterface coreUser) {
        this.CoreUser = coreUser;
    }

    public void setCom(ComConnectionInterface com) {
        this.Com = com;
    }

    public void setCoreDB(DataBaseCoreInterface coreDB) {
        this.CoreDB = coreDB;
    }

    public void setTime(TimeInterface time) {
        this.Time = time;
    }

    public void setCrypto(CryptoDataBaseInterface crypto) {
        this.Crypto = crypto;
    }

    public void setConnections(Map<BBytes, ComPeerInterface> connections) {
        this.Connections = connections;
    }

    public void setTimeConnectedSteps(long timeConnectedSteps) {
        this.TimeConnectedSteps = timeConnectedSteps;
    }

    public void setNumberTimeConnectedSteps(int numberTimeConnectedSteps) {
        this.NumberTimeConnectedSteps = numberTimeConnectedSteps;
    }

    public void setRandom(Random random) {
        this.Random = random;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newConnection(ComPeerInterface com, boolean force) {
        String me = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity().toString();
        Log.info("(" + me + ") Connection: " + com.getPeer().getIdentity());
        ComPeerInterface oc = null;
        Map<BBytes, ComPeerInterface> map = this.Connections;
        synchronized (map) {
            oc = this.Connections.get(com.getPeer().getIdentity());
            if (oc != null) {
                Log.info("Existing connection found: " + com.getPeer().getIdentity());
                if (oc != com) {
                    Log.info("Closing old connection in favor of new: " + com.getPeer().getIdentity());
                    com.Close();
                }
            } else {
                Log.info("No existing connection found: " + com.getPeer().getIdentity() + " max cons: " + this.MaxConnections + " existing cons: " + this.Connections.size());
                int size = 0;
                size = this.Connections.size();
                if (force || size < this.MaxConnections) {
                    Log.info("Accept new connection: " + com.getPeer().getIdentity());
                    this.Connections.put(com.getPeer().getIdentity(), com);
                } else {
                    Log.info("Too many connections closing incoming connection: " + com.getPeer().getIdentity());
                    com.Close();
                }
            }
        }
        if (com.getPeer() != null) {
            LinkedList<Peer> l = new LinkedList<Peer>();
            l.add(com.getPeer());
            this.processPeers(com.getPeer().getIdentity(), l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionClosed(ComPeerInterface com, boolean error) {
        Object object = this.Connections;
        synchronized (object) {
            ComPeerInterface ct = this.Connections.get(com.getPeer().getIdentity());
            if (ct == com) {
                this.Connections.remove(com.getPeer().getIdentity());
            }
        }
        object = this.CoreDB;
        synchronized (object) {
            LocalPeer lp = this.CoreDB.getPeer(com.getPeer().getIdentity());
            long rtime = this.Time.getTime().getTime() + (long)((double)this.getReConnectTime() * this.Random.nextDouble());
            lp.setLastConnectionTime(new Date(rtime));
            this.CoreDB.saveLocalPeer(lp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean requestNetworkAuths(ComPeerInterface com) {
        BBytes peerid = com.getPeer().getIdentity();
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            List<LocalNetworkAuthorization> lst = this.CoreDB.getPeerNetworkAuths(peerid);
            HashSet<BBytes> peernets = new HashSet<BBytes>();
            for (LocalNetworkAuthorization l : lst) {
                peernets.add(l.getNetworkAuthorization().getNetworkId());
            }
            for (BBytes netid : peernets) {
                List<LocalNetworkAuthorization> pushlist = this.CoreDB.getNextNetworkAuthPush(netid);
                for (LocalNetworkAuthorization ln : pushlist) {
                    if (ln.getReceivedFromPeer().equals(peerid) || ln.getNetworkAuthorization().getSignature().getPeerIdentifier().equals(peerid)) continue;
                    ln.setPushRequested(false);
                    this.CoreDB.saveLocalNetworkAuth(ln);
                    com.sendNetworkAuth(ln.getNetworkAuthorization());
                }
            }
            if (peernets.size() > 0) {
                BBytes myid = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
                List<LocalNetworkAuthorization> rsts = this.CoreDB.getOrderedNetworkAuthsRequestedNotDispatched();
                for (LocalNetworkAuthorization ln : rsts) {
                    Log.info("Check if should update network auths for network: " + ln.getNetworkAuthorization().getNetworkId() + " for peer: " + ln.getNetworkAuthorization().getPeerId());
                    if (!peernets.contains(ln.getNetworkAuthorization().getNetworkId()) || !ln.isRequestAuths() || ln.isRequestAuthsDispatched()) continue;
                    LocalNetworkAuthorization myauth = this.CoreDB.getNetworkAuth(ln.getNetworkAuthorization().getNetworkId(), myid);
                    LocalNetworkAuthorization conauth = this.CoreDB.getNetworkAuth(ln.getNetworkAuthorization().getNetworkId(), peerid);
                    if (conauth == null || myauth == null) continue;
                    BBytes rpeer = ln.getNetworkAuthorization().getPeerId();
                    BBytes netid = ln.getNetworkAuthorization().getNetworkId();
                    ln.setRequestAuthsDispatched(true);
                    ln.setRequestAuthsDispatchedTime(this.Time.getTime());
                    this.CoreDB.saveLocalNetworkAuth(ln);
                    List<NetworkAuthHoles> holes = this.CoreDB.getPeerNetworkAuthHoles(netid, rpeer);
                    for (NetworkAuthHoles ph : holes) {
                        Log.info("Send request for network auths: " + netid + " to peer: " + rpeer + " " + ph.getFirstNumber() + " > " + ph.getLastNumber());
                        com.requestNetworkAuths(myauth.getNetworkAuthorization(), conauth.getNetworkAuthorization(), rpeer, netid, ph.getFirstNumber(), ph.getLastNumber());
                    }
                    Log.info("Send request for network auths: " + netid + " to peer: " + rpeer + " " + ln.getLastNetworkAuthNumber() + " > " + Long.MAX_VALUE);
                    com.requestNetworkAuths(myauth.getNetworkAuthorization(), conauth.getNetworkAuthorization(), rpeer, netid, ln.getLastNetworkAuthNumber(), Long.MAX_VALUE);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestNetworks(ComPeerInterface com) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            block6: {
                BBytes myid = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
                BBytes compeerid = com.getPeer().getIdentity();
                List<LocalNetwork> nlst = this.CoreDB.getNextNetworkPush();
                for (LocalNetwork ln : nlst) {
                    if (ln.getReceivedFromPeer().equals(compeerid) || ln.getNetwork().getSignature().getPeerIdentifier().equals(compeerid)) continue;
                    ln.setPushRequseted(false);
                    this.CoreDB.saveLocalNetwork(ln);
                    com.sendNetwork(ln.getNetwork());
                }
                LocalPeer lp = this.CoreDB.getHighestPriorityNeteworkRequest();
                if (lp == null || !lp.isRequestNetworks() || lp.isRequestNetworksDispatched()) break block6;
                BBytes peerid = lp.getPeer().getIdentity();
                lp.setRequestNetworksDispatched(true);
                lp.setRequestNetworksDispatchedTime(this.Time.getTime());
                this.CoreDB.saveLocalPeer(lp);
                List<NetworkHoles> nh = this.CoreDB.getPeerNetworkHoles(peerid);
                for (NetworkHoles n : nh) {
                    Log.info("This peer: " + myid + " requests network update holes from: " + compeerid);
                    com.requestNetworks(peerid, n.getFirstNumber(), n.getLastNumber());
                }
                Log.info("This peer: " + myid + " requests network update from: " + compeerid);
                com.requestNetworks(peerid, lp.getLastNetworkNumber(), Long.MAX_VALUE);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestPeers(ComPeerInterface com) {
        BBytes pid = com.getPeer().getIdentity();
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            block5: {
                LocalPeer lp2;
                List<LocalPeer> lstp = this.CoreDB.getNextPeerPush();
                for (LocalPeer lp2 : lstp) {
                    Log.info("Peer: " + lp2.getPeer().getIdentity() + " received from: " + lp2.getReceivedFromPeer() + " push: " + lp2.isPushRequested());
                    if (lp2.getReceivedFromPeer().equals(pid) || lp2.getPeer().getIdentity().equals(pid)) continue;
                    lp2.setPushRequested(false);
                    this.CoreDB.saveLocalPeer(lp2);
                    com.sendPeer(lp2.getPeer());
                }
                lp2 = this.CoreDB.getPeer(pid);
                if (lp2 == null || !lp2.isRequestPeers()) break block5;
                lp2.setRequestPeers(false);
                this.CoreDB.saveLocalPeer(lp2);
                com.requestPeers();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean requestPosts(ComPeerInterface com) {
        BBytes peerid = com.getPeer().getIdentity();
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            List<LocalNetworkAuthorization> lst = this.CoreDB.getPeerNetworkAuths(peerid);
            HashSet<BBytes> peernets = new HashSet<BBytes>();
            for (LocalNetworkAuthorization l : lst) {
                peernets.add(l.getNetworkAuthorization().getNetworkId());
            }
            for (BBytes netid : peernets) {
                List<LocalPost> plst = this.CoreDB.getNextPostPush(netid);
                for (LocalPost lp : plst) {
                    if (lp.getReceivedFromPeer().equals(peerid) || lp.getPost().getSignedDigest().getPeerIdentifier().equals(peerid)) continue;
                    lp.setPushRequested(false);
                    this.CoreDB.saveLocalPost(lp);
                    com.sendPost(lp.getPost());
                }
            }
            if (peernets.size() > 0) {
                BBytes myid = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
                List<LocalNetworkAuthorization> rsts = this.CoreDB.getOrderedPostsRequestedNotDispatched();
                for (LocalNetworkAuthorization ln : rsts) {
                    if (!peernets.contains(ln.getNetworkAuthorization().getNetworkId()) || !ln.isRequestPosts() || ln.isRequestPostsDispatched()) continue;
                    LocalNetworkAuthorization conauth = this.CoreDB.getNetworkAuth(ln.getNetworkAuthorization().getNetworkId(), peerid);
                    LocalNetworkAuthorization myauth = this.CoreDB.getNetworkAuth(ln.getNetworkAuthorization().getNetworkId(), myid);
                    if (conauth == null || myauth == null) continue;
                    BBytes rpeer = ln.getNetworkAuthorization().getPeerId();
                    BBytes netid = ln.getNetworkAuthorization().getNetworkId();
                    ln.setRequestPostsDispatched(true);
                    ln.setRequestPostsDispatchedTime(this.Time.getTime());
                    this.CoreDB.saveLocalNetworkAuth(ln);
                    List<PostHoles> holes = this.CoreDB.getPostHoles(netid, rpeer);
                    Log.info("NUM HOLES: " + holes.size());
                    for (PostHoles ph : holes) {
                        Log.info("REQUEST HOLES: " + ph.getFirstNumber() + " - " + ph.getLastNumber());
                        com.requestPosts(myauth.getNetworkAuthorization(), conauth.getNetworkAuthorization(), rpeer, netid, ph.getFirstNumber(), ph.getLastNumber());
                    }
                    com.requestPosts(myauth.getNetworkAuthorization(), conauth.getNetworkAuthorization(), rpeer, netid, ln.getLastPostNumber(), Long.MAX_VALUE);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestPublicPosts(ComPeerInterface com) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            block6: {
                BBytes compeerid = com.getPeer().getIdentity();
                List<LocalPublicPost> plst = this.CoreDB.getNextPublicPostPush();
                for (LocalPublicPost lpp : plst) {
                    if (lpp.getReceivedFromPeer().equals(compeerid) || lpp.getPublicPost().getSignature().getPeerIdentifier().equals(compeerid)) continue;
                    lpp.setPushRequsted(false);
                    this.CoreDB.saveLocalPublicPost(lpp);
                    com.sendPublicPost(lpp.getPublicPost());
                }
                LocalPeer lp = this.CoreDB.getHighestPriorityPublicPostRequest();
                if (lp == null || !lp.isRequestPublicPosts() || lp.isRequestPublicPostsDispatched()) break block6;
                BBytes peerid = lp.getPeer().getIdentity();
                lp.setRequestPublicPostsDispatched(true);
                lp.setRequestPublicPostsDispatchedTime(this.Time.getTime());
                this.CoreDB.saveLocalPeer(lp);
                List<PublicPostHoles> nh = this.CoreDB.getPublicPostHoles(peerid);
                for (PublicPostHoles n : nh) {
                    com.requestPublicPosts(peerid, n.getFirstNumber(), n.getLastNumber());
                }
                com.requestPublicPosts(peerid, lp.getLastNetworkNumber(), Long.MAX_VALUE);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean requestFile(ComPeerInterface com) {
        BBytes peerid = com.getPeer().getIdentity();
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            List<LocalNetworkAuthorization> lst = this.CoreDB.getPeerNetworkAuths(peerid);
            HashSet<BBytes> peernets = new HashSet<BBytes>();
            for (LocalNetworkAuthorization l : lst) {
                peernets.add(l.getNetworkAuthorization().getNetworkId());
            }
            if (peernets.size() <= 0) return false;
            List<FileReference> rsts = this.CoreDB.getOrderedFilesRequestedNotDispatched();
            Log.info("File requests found: " + rsts.size());
            for (FileReference ln : rsts) {
                if (ln.getUserRequestPriority() <= 0L || !peernets.contains(ln.getNetworkId()) || !ln.isUserRequested() || ln.isUserRequestDispatched()) continue;
                Log.info("Request is not dispatched.");
                PeerHasFile phf = this.CoreDB.getPeerHasFile(ln.getNetworkId(), peerid, ln.getUnsignedDigest());
                if (phf == null || !phf.isPeerHasFile()) continue;
                Log.info("Peer has file..  Sending request. " + peerid);
                ln.setUserRequestDispatched(true);
                ln.setUserRequestDispatchTime(this.Time.getTime());
                this.CoreDB.saveFileReference(ln);
                com.requestsFile(ln.getNetworkId(), ln.getUnsignedDigest());
                return true;
            }
            return false;
        }
    }

    @Override
    public void nextRequest(ComPeerInterface com) {
        if (!com.isOk()) {
            return;
        }
        int lastrequesttype = com.getLastRequestType();
        boolean requestfound = false;
        int cnt = 0;
        while (cnt < 2 && !requestfound) {
            int chk = cnt;
            if (lastrequesttype == 5 && cnt == 0 || !requestfound && chk > 0) {
                requestfound = this.requestNetworkAuths(com);
                Log.info("RequestNetworkAuths: " + requestfound + " cnt: " + cnt + " chk: " + chk);
                ++chk;
            }
            if (lastrequesttype == 3 && cnt == 0 || !requestfound && chk > 0) {
                requestfound = this.requestNetworks(com);
                Log.info("RequestNetworks: " + requestfound + " cnt: " + cnt + " chk: " + chk);
                ++chk;
            }
            if (lastrequesttype == 2 && cnt == 0 || !requestfound && chk > 0) {
                requestfound = this.requestPeers(com);
                Log.info("RequestPeers: " + requestfound + " cnt: " + cnt + " chk: " + chk);
                ++chk;
            }
            if (lastrequesttype == 4 && cnt == 0 || !requestfound && chk > 0) {
                requestfound = this.requestPosts(com);
                Log.info("RequestPosts: " + requestfound + " cnt: " + cnt + " chk: " + chk);
                ++chk;
            }
            if (lastrequesttype == 0 && cnt == 0 || !requestfound && chk > 0) {
                requestfound = this.requestPublicPosts(com);
                Log.info("RequestPublicPosts: " + requestfound + " cnt: " + cnt + " chk: " + chk);
                ++chk;
            }
            if (lastrequesttype == 1 && cnt == 0 || !requestfound && chk > 0) {
                requestfound = this.requestFile(com);
                Log.info("RequestFile: " + requestfound + " cnt: " + cnt + " chk: " + chk);
                ++chk;
            }
            ++cnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestPostsFailed(ComPeerInterface conpeer, BBytes peerid, BBytes networkid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalNetworkAuthorization lna = this.CoreDB.getNetworkAuth(networkid, peerid);
            if (lna != null) {
                lna.setRequestPostsDispatched(false);
                this.CoreDB.saveLocalNetworkAuth(lna);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestFileFailed(ComPeerInterface conpeer, BBytes networkid, BBytes filedig) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            List<FileReference> flist = this.CoreDB.getFilesRequested(filedig);
            for (FileReference f : flist) {
                if (!f.getNetworkId().equals(networkid)) continue;
                f.setUserRequestDispatched(false);
                this.CoreDB.saveFileReference(f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestNetworksFailed(ComPeerInterface conpeer, BBytes peerid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalPeer lp = this.CoreDB.getPeer(peerid);
            if (lp != null) {
                lp.setRequestNetworksDispatched(false);
                this.CoreDB.saveLocalPeer(lp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestNetworkAuthsFailed(ComPeerInterface conpeer, BBytes peerid, BBytes networkid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalNetworkAuthorization lna = this.CoreDB.getNetworkAuth(networkid, peerid);
            if (lna != null) {
                lna.setRequestAuthsDispatched(false);
                this.CoreDB.saveLocalNetworkAuth(lna);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestPublicPostsFailed(ComPeerInterface conpeer, BBytes peerid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalPeer lp = this.CoreDB.getPeer(peerid);
            if (lp != null) {
                lp.setRequestPublicPostsDispatched(false);
                this.CoreDB.saveLocalPeer(lp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestPostsSucceeded(ComPeerInterface conpeer, BBytes peerid, BBytes networkid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalNetworkAuthorization lna = this.CoreDB.getNetworkAuth(networkid, peerid);
            if (lna != null) {
                lna.setRequestPosts(false);
                lna.setRequestPostsDispatched(false);
                this.CoreDB.saveLocalNetworkAuth(lna);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestNetworksSucceeded(ComPeerInterface conpeer, BBytes peerid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalPeer lp = this.CoreDB.getPeer(peerid);
            if (lp != null) {
                lp.setRequestNetworks(false);
                lp.setRequestNetworksDispatched(false);
                this.CoreDB.saveLocalPeer(lp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestNetworkAuthSucceeded(ComPeerInterface conpeer, BBytes peerid, BBytes networkid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalNetworkAuthorization lna = this.CoreDB.getNetworkAuth(networkid, peerid);
            if (lna != null) {
                lna.setRequestAuths(false);
                lna.setRequestAuthsDispatched(false);
                this.CoreDB.saveLocalNetworkAuth(lna);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestPublicPostsSucceeded(ComPeerInterface conpeer, BBytes peerid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalPeer lp = this.CoreDB.getPeer(peerid);
            if (lp != null) {
                lp.setRequestPublicPosts(false);
                lp.setRequestPublicPostsDispatched(false);
                this.CoreDB.saveLocalPeer(lp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyPost(Post p) {
        BBytes peerid = p.getSignedDigest().getPeerIdentifier();
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            block4: {
                LocalPost ep = this.CoreDB.getPost(p.getNetworkId(), peerid, p.getPostNumber());
                if (ep != null) break block4;
                LocalPeer lp = this.CoreDB.getPeer(peerid);
                LocalNetworkAuthorization lna = this.CoreDB.getNetworkAuth(p.getNetworkId(), peerid);
                if (lp == null || lna == null || lna.isMarkedBad() || !this.verifyNetworkAuthChain(lna.getNetworkAuthorization()) || !this.Crypto.verifyPost(p, lp.getPeer().getPeerKeys())) break block4;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processPosts(BBytes conpeer, List<Post> posts) {
        for (Post p : posts) {
            if (!this.verifyPost(p)) continue;
            DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
            synchronized (dataBaseCoreInterface) {
                PostMessage pm;
                LocalNetworkAuthorization splna;
                BBytes peerid = p.getSignedDigest().getPeerIdentifier();
                LocalPost lpst = new LocalPost();
                lpst.setLocalDate(this.Time.getTime());
                lpst.setPost(p);
                lpst.setPushRequested(true);
                lpst.setReceivedFromPeer(conpeer);
                LocalNetworkAuthorization slna = this.CoreDB.getNetworkAuth(p.getNetworkId(), peerid);
                if (slna != null) {
                    lpst.setPeerRank(slna.getPeerRank());
                    lpst.setCreator(slna.getPeerNickSig());
                    this.CoreDB.saveLocalPost(lpst);
                    long lastnum = slna.getLastPostNumber();
                    if (p.getPostNumber() > lastnum) {
                        slna.setLastPostNumber(p.getPostNumber());
                        if (p.getPostNumber() > lastnum + 1L) {
                            PostHoles nph = new PostHoles();
                            nph.setFirstNumber(lastnum + 1L);
                            nph.setLastNumber(p.getPostNumber() - 1L);
                            nph.setNetworkId(p.getNetworkId());
                            nph.setPeerId(peerid);
                            this.CoreDB.savePostHoles(nph);
                        }
                    } else {
                        List<PostHoles> holes = this.CoreDB.getPostHoles(p.getNetworkId(), peerid);
                        for (PostHoles h : holes) {
                            PostHoles nh = h.newPostReceived(p.getPostNumber());
                            if (nh != null) {
                                this.CoreDB.savePostHoles(nh);
                            }
                            if (h.isDone()) {
                                this.CoreDB.deletePostHoles(h);
                                continue;
                            }
                            this.CoreDB.savePostHoles(h);
                        }
                    }
                    slna.setRequestPosts(false);
                    slna.setRequestPostsDispatched(false);
                    this.CoreDB.saveLocalNetworkAuth(slna);
                }
                if ((splna = this.CoreDB.getNetworkAuth(p.getNetworkId(), conpeer)) != null) {
                    splna.setNumberOfNewPosts(splna.getNumberOfNewPosts() + 1L);
                    splna.setLastNewPost(this.Time.getTime());
                    this.CoreDB.saveLocalNetworkAuth(splna);
                }
                if (p.getFileReferenceDigest() != null) {
                    PeerHasFile phf = this.CoreDB.getPeerHasFile(p.getNetworkId(), p.getSignedDigest().getPeerIdentifier(), p.getFileReferenceDigest());
                    if (phf != null) {
                        if (phf.getLastMessage() < p.getPostNumber() && (phf.isPeerHasFile() && !p.isPosterHasFile() || !phf.isPeerHasFile() && p.isPosterHasFile())) {
                            phf.setPeerHasFile(p.isPosterHasFile());
                            phf.setLastMessage(p.getPostNumber());
                            this.CoreDB.savePeerHasFile(phf);
                        }
                    } else if (p.isPosterHasFile()) {
                        phf = new PeerHasFile();
                        phf.setDigest(p.getFileReferenceDigest());
                        phf.setLastMessage(p.getPostNumber());
                        phf.setNetworkId(p.getNetworkId());
                        phf.setPeerHasFile(p.isPosterHasFile());
                        phf.setPeerId(p.getSignedDigest().getPeerIdentifier());
                        this.CoreDB.savePeerHasFile(phf);
                    }
                }
                if (p.getMessage() instanceof PostMessage && (pm = (PostMessage)p.getMessage()).isTemplate() && p.getFileReferenceDigest() != null) {
                    try {
                        File tmpfile = File.createTempFile("template", ".dat", this.TemplateDir);
                        this.CoreUser.downloadFile(p.getNetworkId(), p.getFileReferenceDigest(), tmpfile, 0L, pm.getNum0(), true, 10L);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.Events.newPostReceived(lpst);
            }
        }
        return false;
    }

    private void createHaveFilePost(BBytes networkid, BBytes dig) {
        this.CoreUser.addLocalPost(networkid, null, dig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BBytes processFile(BBytes conpeer, BBytes networkid, File frs) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            BBytes dig = this.Crypto.digestFile(frs);
            if (dig != null) {
                List<FileReference> flist = this.CoreDB.getFilesRequested(dig);
                for (FileReference f : flist) {
                    if (!f.isUserRequested() || f.getSize() != frs.length()) continue;
                    try {
                        FileUtils.copyFile(frs, f.getFile(), 0L, f.getOffset(), f.getSize());
                        f.setUserRequested(false);
                        f.setUserRequestDispatched(false);
                        this.CoreDB.saveFileReference(f);
                        this.Events.newFileDownloaded(f);
                        this.createHaveFilePost(f.getNetworkId(), dig);
                        LocalNetworkAuthorization splna = this.CoreDB.getNetworkAuth(f.getNetworkId(), conpeer);
                        if (splna != null) {
                            splna.setNumberOfFiles(splna.getNumberOfFiles() + 1L);
                            splna.setLastNewFile(this.Time.getTime());
                            this.CoreDB.saveLocalNetworkAuth(splna);
                        }
                        if (!f.isTemplate()) continue;
                        try {
                            PostTemplate pt = PostTemplate.readPostTemplate(frs);
                            pt.setDigest(dig);
                            this.CoreDB.saveTemplate(pt);
                        }
                        catch (Exception exception) {}
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            frs.delete();
            return dig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPeers(BBytes conpeer, List<Peer> peers) {
        long numnewpeers = 0L;
        Log.info("Number of peers to process: " + peers.size());
        for (Peer p : peers) {
            String ident = p.getIdentity().toString();
            Log.info("Process peer: " + ident);
            DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
            synchronized (dataBaseCoreInterface) {
                if (this.Crypto.verifyIdentity(p)) {
                    Log.info("Peer identity data verified: " + ident);
                    LocalPeer olp = this.CoreDB.getPeer(p.getIdentity());
                    if (olp != null) {
                        Log.info("Existing peer data found: Current update count: " + olp.getPeer().getUpdateCount() + " new count: " + p.getUpdateCount() + " for: " + ident);
                        if (olp.getPeer().getUpdateCount() < p.getUpdateCount()) {
                            if (this.Crypto.verifyLocation(p, olp.getPeer().getPeerKeys())) {
                                Log.info("Location data verified: " + ident);
                                Log.info(">>>>>> Set push, received from: " + conpeer);
                                this.CoreDB.deletePeer(olp.getPeer(), false);
                                olp.setPeer(p);
                                olp.setPushRequested(true);
                                olp.setReceivedFromPeer(conpeer);
                                this.CoreDB.saveLocalPeer(olp);
                                ++numnewpeers;
                                this.Events.newPeerReceived(olp);
                            } else {
                                Log.info("Location data was not valid: " + ident);
                            }
                        }
                    } else {
                        Log.info("Existing peer data not found: " + ident);
                        if (this.Crypto.verifyLocation(p, p.getPeerKeys())) {
                            Log.info("Location data verfied saving new peer: " + ident);
                            LocalPeer lp = new LocalPeer();
                            lp.setConnectionAttempts(0L);
                            lp.setLastConnectionTime(this.Time.getTime());
                            lp.setLastNetworkNumber(0L);
                            lp.setLastNewNetwork(this.Time.getTime());
                            lp.setLastNewPeer(this.Time.getTime());
                            lp.setLastNewPublicPost(this.Time.getTime());
                            lp.setLastPublicPostNumber(0L);
                            lp.setLastSuccessRequest(this.Time.getTime());
                            lp.setNumberOfNewNetworks(0L);
                            lp.setNumberOfNewPeers(0L);
                            lp.setNumberOfNewPublicPosts(0L);
                            lp.setRequestNetworks(false);
                            lp.setRequestNetworksDispatched(false);
                            lp.setRequestNetworksDispatchedTime(this.Time.getTime());
                            lp.setRequestNetworksPriority(0L);
                            lp.setRequestNetworksTime(this.Time.getTime());
                            lp.setRequestPeers(false);
                            lp.setRequestPeersPriority(0L);
                            lp.setRequestPeersTime(this.Time.getTime());
                            lp.setRequestPublicPosts(false);
                            lp.setRequestPublicPostsDispatched(false);
                            lp.setRequestPublicPostsDispatchedTime(this.Time.getTime());
                            lp.setRequestPublicPostsPriority(0L);
                            lp.setRequestPublicPostsTime(this.Time.getTime());
                            lp.setRequests(0L);
                            lp.setSuccessfulConnectionAttempts(0L);
                            lp.setSuccessfulRequests(0L);
                            lp.setPushRequested(true);
                            lp.setReceivedFromPeer(conpeer);
                            Log.info("CONPEER: " + conpeer);
                            lp.setPeer(p);
                            lp.setLocalDate(this.Time.getTime());
                            this.CoreDB.saveLocalPeer(lp);
                            ++numnewpeers;
                            this.Events.newPeerReceived(lp);
                        } else {
                            Log.info("Location data was invalid: " + ident);
                        }
                    }
                } else {
                    Log.info("Identity was not valid: " + ident);
                }
            }
        }
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalPeer slp = this.CoreDB.getPeer(conpeer);
            if (slp != null) {
                long numpeers = slp.getNumberOfNewPeers();
                slp.setNumberOfNewPeers(numpeers += numnewpeers);
                slp.setLastNewPeer(this.Time.getTime());
                this.CoreDB.saveLocalPeer(slp);
                Log.info("Update peer newpeer stat: " + conpeer + " number: " + numpeers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processNetworks(BBytes conpeer, List<Network> networks) {
        long numnewnetworks = 0L;
        for (Network n : networks) {
            DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
            synchronized (dataBaseCoreInterface) {
                LocalPeer creator;
                LocalPeer olp = this.CoreDB.getPeer(n.getSignature().getPeerIdentifier());
                LocalNetwork lnw = this.CoreDB.getLocalNetwork(n.getSignature().getDigest());
                if (olp != null && lnw == null && (creator = this.CoreDB.getPeer(n.getSignature().getPeerIdentifier())) != null && this.Crypto.verifyNetwork(n, olp.getPeer().getPeerKeys())) {
                    LocalNetwork ln = new LocalNetwork();
                    ln.setLocalDate(this.Time.getTime());
                    ln.setNetwork(n);
                    ln.setPushRequseted(true);
                    ln.setReceivedFromPeer(conpeer);
                    ln.setCreator(creator.getPeer().getNickSig());
                    this.CoreDB.saveLocalNetwork(ln);
                    ++numnewnetworks;
                    long oldlast = olp.getLastNetworkNumber();
                    if (n.getNetworkNumber() > oldlast) {
                        olp.setLastNetworkNumber(n.getNetworkNumber());
                        if (n.getNetworkNumber() > oldlast + 1L) {
                            NetworkHoles nh = new NetworkHoles();
                            nh.setFirstNumber(oldlast + 1L);
                            nh.setLastNumber(n.getNetworkNumber() - 1L);
                            nh.setPeerId(olp.getPeer().getIdentity());
                            this.CoreDB.saveNetworkHoles(nh);
                        }
                    } else {
                        List<NetworkHoles> nhl = this.CoreDB.getPeerNetworkHoles(olp.getPeer().getIdentity());
                        for (NetworkHoles nh : nhl) {
                            NetworkHoles nnh = nh.newNetworkReceived(n.getNetworkNumber());
                            if (nnh != null) {
                                this.CoreDB.saveNetworkHoles(nnh);
                            }
                            if (nh.isDone()) {
                                this.CoreDB.deleteNetworkHoles(nh);
                                continue;
                            }
                            this.CoreDB.saveNetworkHoles(nh);
                        }
                    }
                    olp.setRequestNetworks(false);
                    olp.setRequestNetworksDispatched(false);
                    this.CoreDB.saveLocalPeer(olp);
                    this.Events.newNetworkReceived(ln);
                }
            }
        }
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalPeer slp = this.CoreDB.getPeer(conpeer);
            if (slp != null) {
                long numnets = slp.getNumberOfNewNetworks();
                slp.setNumberOfNewNetworks(numnets += numnewnetworks);
                slp.setLastNewNetwork(this.Time.getTime());
                this.CoreDB.saveLocalPeer(slp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean verifyNetworkAuthChain(NetworkAuthorization na) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalPeer signingpeer = this.CoreDB.getPeer(na.getSignature().getPeerIdentifier());
            Log.info("Signing peer: " + signingpeer);
            if (signingpeer != null) {
                BBytes networkcreator;
                Log.info("Signing peer: " + signingpeer.getPeer().getIdentity() + " for peer: " + na.getPeerId() + " net: " + na.getNetworkId());
                BBytes id = signingpeer.getPeer().getIdentity();
                LocalNetwork sna = this.CoreDB.getLocalNetwork(na.getNetworkId());
                LocalNetworkAuthorization pna = this.CoreDB.getNetworkAuth(na.getNetworkId(), id);
                Log.info("Signing peer's network auth: " + pna);
                if (sna != null) {
                    Log.info("Network signed by: " + sna.getNetwork().getSignature().getPeerIdentifier());
                }
                if (pna != null && sna != null && !sna.getNetwork().getSignature().getPeerIdentifier().equals(id) && !na.getPeerId().equals(na.getSignature().getPeerIdentifier())) {
                    Log.info("Is peer marked bad for the network: " + pna.isMarkedBad());
                    if (!pna.isMarkedBad()) {
                        int sa = pna.getNetworkAuthorization().getSignAuthority();
                        int nna = na.getSignAuthority();
                        Log.info("Signing peer's authority: " + sa + " granted athority: " + nna);
                        if ((sa == NetworkAuthorization.CANSIGN && nna == NetworkAuthorization.NOSIGN || sa == NetworkAuthorization.CANGIVESIGNAUTH) && this.Crypto.verifyNetworkAuthorization(na, signingpeer.getPeer().getPeerKeys())) {
                            Log.info("Authorization signature is valid.");
                            if (this.verifyNetworkAuthChain(pna.getNetworkAuthorization())) {
                                Log.info("Peer: " + na.getPeerId() + " is authorized for: " + na.getNetworkId());
                                return true;
                            }
                        }
                    }
                } else if (sna != null && (networkcreator = sna.getNetwork().getSignature().getPeerIdentifier()).equals(id)) {
                    Log.info("The signing peer created the network!");
                    if (this.Crypto.verifyNetworkAuthorization(na, signingpeer.getPeer().getPeerKeys())) {
                        Log.info("N: Peer: " + na.getPeerId() + " is authorized for: " + na.getNetworkId());
                        return true;
                    }
                }
            }
        }
        Log.info("Peer: " + na.getPeerId() + " is NOT authorized for: " + na.getNetworkId());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyNetworkAuth(NetworkAuthorization na) {
        block5: {
            DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
            synchronized (dataBaseCoreInterface) {
                block4: {
                    LocalNetworkAuthorization cna;
                    LocalPeer signingpeer = this.CoreDB.getPeer(na.getSignature().getPeerIdentifier());
                    if (signingpeer == null || !this.Crypto.verifyNetworkAuthorization(na, signingpeer.getPeer().getPeerKeys()) || (cna = this.CoreDB.getNetworkAuth(na.getNetworkId(), na.getPeerId())) != null) break block5;
                    BBytes myid = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
                    if (!na.getPeerId().equals(myid)) break block4;
                    return true;
                }
                return this.verifyNetworkAuthChain(na);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processNetworkAuths(BBytes conpeer, List<NetworkAuthorization> auths) {
        MyPeerDataSO mp = this.CoreDB.getMyPeerData();
        for (NetworkAuthorization na : auths) {
            LocalPeer forpeer = this.CoreDB.getPeer(na.getPeerId());
            LocalPeer signer = this.CoreDB.getPeer(na.getSignature().getPeerIdentifier());
            LocalNetwork net = this.CoreDB.getLocalNetwork(na.getNetworkId());
            if (forpeer == null || signer == null || net == null || !this.verifyNetworkAuth(na)) continue;
            DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
            synchronized (dataBaseCoreInterface) {
                LocalNetworkAuthorization splna;
                if (mp.getPeer().getPeer().getIdentity().equals(na.getPeerId())) {
                    net.setAuthorization(na.getSignAuthority());
                    net.setAuthorized(true);
                    this.CoreDB.saveLocalNetwork(net);
                }
                LocalNetworkAuthorization lna = new LocalNetworkAuthorization();
                lna.setNetworkAuthorization(na);
                lna.setLastNetworkAuthNumber(0L);
                lna.setLastNewAuths(this.Time.getTime());
                lna.setLastNewPost(this.Time.getTime());
                lna.setLastPostNumber(0L);
                lna.setLocalDate(this.Time.getTime());
                lna.setMarkedBad(false);
                lna.setMarkedBadDate(this.Time.getTime());
                lna.setNumberOfNewAuths(0L);
                lna.setNumberOfNewPosts(0L);
                lna.setRequestAuths(false);
                lna.setRequestAuthsDispatched(false);
                lna.setRequestAuthsDispatchedTime(this.Time.getTime());
                lna.setRequestAuthsPriority(0L);
                lna.setRequestAuthsTime(this.Time.getTime());
                lna.setRequestPosts(false);
                lna.setRequestPostsDispatched(false);
                lna.setRequestPostsDispatchedTime(this.Time.getTime());
                lna.setRequestPostsPriority(0L);
                lna.setRequestPostsTime(this.Time.getTime());
                lna.setPeerNickSig(forpeer.getPeer().getNickSig());
                lna.setSignerNickSig(signer.getPeer().getNickSig());
                lna.setNetworkTitle(net.getNetwork().getTitleSig());
                lna.setReceivedFromPeer(conpeer);
                lna.setPushRequested(true);
                this.CoreDB.saveLocalNetworkAuth(lna);
                LocalNetworkAuthorization slna = this.CoreDB.getNetworkAuth(na.getNetworkId(), na.getSignature().getPeerIdentifier());
                if (slna != null) {
                    long lastnum = slna.getLastNetworkAuthNumber();
                    if (na.getSignatureNumber() > lastnum) {
                        slna.setLastNetworkAuthNumber(na.getSignatureNumber());
                        if (na.getSignatureNumber() > lastnum + 1L) {
                            NetworkAuthHoles newholes = new NetworkAuthHoles();
                            newholes.setFirstNumber(lastnum + 1L);
                            newholes.setLastNumber(na.getSignatureNumber() - 1L);
                            newholes.setNetworkId(na.getNetworkId());
                            newholes.setPeerId(na.getSignature().getPeerIdentifier());
                            this.CoreDB.saveNetworkAuthHoles(newholes);
                        }
                    } else {
                        List<NetworkAuthHoles> holes = this.CoreDB.getPeerNetworkAuthHoles(na.getNetworkId(), na.getSignature().getPeerIdentifier());
                        for (NetworkAuthHoles h : holes) {
                            NetworkAuthHoles nh = h.newNetworkAuthReceived(na.getSignatureNumber());
                            if (nh != null) {
                                this.CoreDB.saveNetworkAuthHoles(nh);
                            }
                            if (h.isDone()) {
                                this.CoreDB.deleteNetworkAuthHoles(h);
                                continue;
                            }
                            this.CoreDB.saveNetworkAuthHoles(h);
                        }
                    }
                    slna.setRequestAuths(false);
                    slna.setRequestAuthsDispatched(false);
                    this.CoreDB.saveLocalNetworkAuth(slna);
                }
                if ((splna = this.CoreDB.getNetworkAuth(na.getNetworkId(), conpeer)) != null) {
                    splna.setNumberOfNewAuths(splna.getNumberOfNewAuths() + 1L);
                    splna.setLastNewAuths(this.Time.getTime());
                    this.CoreDB.saveLocalNetworkAuth(splna);
                }
                this.Events.newNetworkAuthReceived(lna);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPublicPosts(BBytes conpeer, List<PublicPost> posts) {
        long numpubposts = 0L;
        Log.info("Process public posts: " + posts.size());
        MyPeerDataSO mp = this.CoreDB.getMyPeerData();
        for (PublicPost pp : posts) {
            DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
            synchronized (dataBaseCoreInterface) {
                Log.info("Public post encrypted: " + pp.isEncrypted());
                BBytes peerid = pp.getSignature().getPeerIdentifier();
                LocalPeer lp = this.CoreDB.getPeer(peerid);
                LocalPublicPost olpp = this.CoreDB.getLocalPublicPost(peerid, pp.getPostNumber());
                if (lp != null && olpp == null) {
                    Log.info("We don't already have the public post.");
                    if (this.Crypto.verifyPublicPost(pp, lp.getPeer().getPeerKeys())) {
                        LocalNetwork net;
                        Log.info("The public post verifies!");
                        LocalPublicPost lpp = new LocalPublicPost();
                        lpp.setCreator(lp.getPeer().getNickSig());
                        if (pp.getNetworkId() != null && (net = this.CoreDB.getLocalNetwork(pp.getNetworkId())) != null) {
                            lpp.setNetworkTitle(net.getNetwork().getTitleSig());
                        }
                        lpp.setLocalDate(this.Time.getTime());
                        lpp.setPublicPost(pp);
                        lpp.setPushRequsted(true);
                        lpp.setReceivedFromPeer(conpeer);
                        if (pp.isEncrypted()) {
                            Object privkey = this.CoreDB.getMyPeerData().getKeySet().getPrivateEncryptionKey();
                            Object decmsg = this.Crypto.decodePublicPost(pp.getMessage(), privkey);
                            Log.info("Decrypto public message for me: " + decmsg);
                            lpp.setDecodedMessage(decmsg);
                            if (decmsg != null) {
                                lpp.setPrivateMessage(true);
                                lpp.setToPeer(mp.getPeer().getPeer().getNickSig());
                            }
                        }
                        this.CoreDB.saveLocalPublicPost(lpp);
                        ++numpubposts;
                        long oldpostnum = lp.getLastPublicPostNumber();
                        if (pp.getPostNumber() > oldpostnum) {
                            lp.setLastPublicPostNumber(pp.getPostNumber());
                            if (pp.getPostNumber() > oldpostnum + 1L) {
                                PublicPostHoles pph = new PublicPostHoles();
                                pph.setFirstNumber(oldpostnum + 1L);
                                pph.setLastNumber(pp.getPostNumber() - 1L);
                                pph.setPeerId(peerid);
                                this.CoreDB.savePublicPostHoles(pph);
                            }
                        } else {
                            List<PublicPostHoles> pphl = this.CoreDB.getPublicPostHoles(peerid);
                            for (PublicPostHoles pph : pphl) {
                                PublicPostHoles npph = pph.newPublicPostReceived(pp.getPostNumber());
                                if (npph != null) {
                                    this.CoreDB.savePublicPostHoles(npph);
                                }
                                if (pph.isDone()) {
                                    this.CoreDB.deletePublicPostHoles(pph);
                                    continue;
                                }
                                this.CoreDB.savePublicPostHoles(pph);
                            }
                        }
                        lp.setRequestPublicPosts(false);
                        lp.setRequestPublicPostsDispatched(false);
                        this.CoreDB.saveLocalPeer(lp);
                        this.Events.newPublicPostReceived(lpp);
                    } else {
                        Log.info("PUBLIC POST IS INVALID!");
                    }
                }
            }
        }
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalPeer slp = this.CoreDB.getPeer(conpeer);
            if (slp != null) {
                long numnets = slp.getNumberOfNewPublicPosts();
                slp.setNumberOfNewPublicPosts(numnets += numpubposts);
                slp.setLastNewPublicPost(this.Time.getTime());
                this.CoreDB.saveLocalPeer(slp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushPeer(Peer p) {
        Map<BBytes, ComPeerInterface> map = this.Connections;
        synchronized (map) {
            for (ComPeerInterface com : this.Connections.values()) {
                com.sendPeer(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushNetwork(Network n) {
        Map<BBytes, ComPeerInterface> map = this.Connections;
        synchronized (map) {
            for (ComPeerInterface com : this.Connections.values()) {
                com.sendNetwork(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushNetworkAuth(NetworkAuthorization na) {
        LinkedList<ComPeerInterface> cr = new LinkedList<ComPeerInterface>();
        Map<BBytes, ComPeerInterface> map = this.Connections;
        synchronized (map) {
            cr.addAll(this.Connections.values());
        }
        for (ComPeerInterface com : cr) {
            BBytes ppid = com.getPeer().getIdentity();
            Log.info("Check if we want to push auth to: " + ppid);
            BBytes nid = na.getNetworkId();
            DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
            synchronized (dataBaseCoreInterface) {
                LocalNetworkAuthorization pna = this.CoreDB.getNetworkAuth(nid, ppid);
                Log.info("Authorization for connected peer: " + ppid + "network: " + nid + " auth: " + pna);
                if (pna != null && !pna.isMarkedBad() && this.verifyNetworkAuthChain(pna.getNetworkAuthorization())) {
                    Log.info("Push authorization: " + ppid);
                    com.sendNetworkAuth(na);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushPublicPost(PublicPost pp) {
        Map<BBytes, ComPeerInterface> map = this.Connections;
        synchronized (map) {
            for (ComPeerInterface com : this.Connections.values()) {
                Log.info("Push new public post!");
                com.sendPublicPost(pp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushPost(Post p) {
        LinkedList<ComPeerInterface> cr = new LinkedList<ComPeerInterface>();
        Map<BBytes, ComPeerInterface> map = this.Connections;
        synchronized (map) {
            cr.addAll(this.Connections.values());
        }
        for (ComPeerInterface com : cr) {
            BBytes nid = p.getNetworkId();
            BBytes ppid = com.getPeer().getIdentity();
            DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
            synchronized (dataBaseCoreInterface) {
                LocalNetworkAuthorization pna = this.CoreDB.getNetworkAuth(nid, ppid);
                if (pna != null && !pna.isMarkedBad() && this.verifyNetworkAuthChain(pna.getNetworkAuthorization())) {
                    Log.info("Push post for network: " + nid + " from peer: " + this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity() + " to peer: " + ppid);
                    com.sendPost(p);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Peer> requestPeers() {
        List<Peer> lst = null;
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            lst = this.CoreDB.getPeers();
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Network> requestNetworks(BBytes requestingpeer, BBytes peerid, long fromnumber, long tonumber) {
        List<Network> lst = null;
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            lst = this.CoreDB.getNetworks(peerid, fromnumber, tonumber);
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PublicPost> requestPublicPosts(BBytes requestingpeer, BBytes peerid, long fromnumber, long tonumber) {
        List<PublicPost> lst = null;
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            lst = this.CoreDB.getPublicPosts(peerid, fromnumber, tonumber);
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NetworkAuthorization> requestNetworkAuths(BBytes requestingpeer, BBytes peerid, BBytes networkid, long fromnumber, long tonumber) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalNetworkAuthorization lna = this.CoreDB.getNetworkAuth(networkid, requestingpeer);
            if (lna != null && !lna.isMarkedBad() && this.verifyNetworkAuthChain(lna.getNetworkAuthorization())) {
                return this.CoreDB.getNetworkAuthorizations(peerid, networkid, fromnumber, tonumber);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Post> requestPosts(BBytes reqestingpeer, BBytes peerid, BBytes networkid, long fromnumber, long tonumber) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalNetworkAuthorization lna = this.CoreDB.getNetworkAuth(networkid, reqestingpeer);
            if (lna != null && !lna.isMarkedBad() && this.verifyNetworkAuthChain(lna.getNetworkAuthorization())) {
                return this.CoreDB.getPosts(peerid, networkid, fromnumber, tonumber);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileReference requestFile(BBytes requestingpeer, BBytes networkid, BBytes dig) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalNetworkAuthorization lna = this.CoreDB.getNetworkAuth(networkid, requestingpeer);
            if (lna != null && !lna.isMarkedBad() && this.verifyNetworkAuthChain(lna.getNetworkAuthorization())) {
                MyPeerDataSO me = this.CoreDB.getMyPeerData();
                BBytes myid = me.getPeer().getPeer().getIdentity();
                PeerHasFile phf = this.CoreDB.getPeerHasFile(networkid, myid, dig);
                List<FileReference> frefs = this.CoreDB.getFiles(networkid, dig);
                for (FileReference fr : frefs) {
                    if (fr.getFile() == null || !fr.getFile().exists() || !this.Crypto.digestFile(fr.getFile(), fr.getOffset(), fr.getSize()).equals(dig)) continue;
                    if (phf == null || !phf.isPeerHasFile()) {
                        this.CoreUser.addLocalPost(networkid, null, dig);
                    }
                    return fr;
                }
                if (phf != null && phf.isPeerHasFile()) {
                    this.CoreUser.addLocalPost(networkid, null, dig);
                }
            }
        }
        return null;
    }

    private BBytes pickPeerForFile(HashSet<BBytes> peerwfile, BBytes networkid, Date then) {
        BBytes addpeer = null;
        BBytes me = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
        List<LocalNetworkAuthorization> nolst = this.CoreDB.getOrderedMostFilesMostPostsLastDate(networkid, then);
        LinkedList<BBytes> wfile = new LinkedList<BBytes>();
        for (LocalNetworkAuthorization n : nolst) {
            BBytes npeerid = n.getNetworkAuthorization().getPeerId();
            if (!peerwfile.contains(npeerid) || me.equals(npeerid)) continue;
            wfile.add(npeerid);
        }
        if (wfile.size() > 0) {
            double rv = this.Random.nextDouble();
            rv *= rv;
            int idx = (int)((double)wfile.size() * rv);
            idx = Math.min(idx, wfile.size() - 1);
            addpeer = (BBytes)wfile.get(idx);
        }
        return addpeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BBytes getNewPeerForFiles(HashSet<BBytes> conpeers) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            List<FileReference> flist = this.CoreDB.getOrderedFilesRequestedNotDispatched();
            if (flist.size() > 0) {
                boolean found = false;
                FileReference fr = flist.get(0);
                Iterator<BBytes> i = conpeers.iterator();
                while (i.hasNext() && !found) {
                    BBytes conpeer = i.next();
                    PeerHasFile phf = this.CoreDB.getPeerHasFile(fr.getNetworkId(), conpeer, fr.getUnsignedDigest());
                    if (phf == null || !phf.isPeerHasFile()) continue;
                    found = true;
                }
                if (!found) {
                    List<PeerHasFile> phfl = this.CoreDB.getPeersHaveFile(fr.getNetworkId(), fr.getUnsignedDigest());
                    HashSet<BBytes> peerwfile = new HashSet<BBytes>();
                    for (PeerHasFile phf : phfl) {
                        if (!phf.isPeerHasFile()) continue;
                        peerwfile.add(phf.getPeerId());
                    }
                    BBytes addpeer = null;
                    Date now = this.Time.getTime();
                    int cnt = 0;
                    while (cnt < this.NumberTimeConnectedSteps && addpeer == null) {
                        Date then = new Date(now.getTime() - (long)(cnt + 1) * this.TimeConnectedSteps);
                        addpeer = this.pickPeerForFile(peerwfile, fr.getNetworkId(), then);
                        ++cnt;
                    }
                    if (addpeer == null) {
                        Date then = new Date(0L);
                        addpeer = this.pickPeerForFile(peerwfile, fr.getNetworkId(), then);
                    }
                    return addpeer;
                }
            }
        }
        return null;
    }

    private BBytes pickPeerForPosts(BBytes networkid, Date then) {
        BBytes addpeer = null;
        List<LocalNetworkAuthorization> dlst = this.CoreDB.getOrderedMostPostsLastDate(networkid, then);
        LinkedList<LocalNetworkAuthorization> nlst = new LinkedList<LocalNetworkAuthorization>();
        BBytes meid = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
        for (LocalNetworkAuthorization l : dlst) {
            if (l.getNetworkAuthorization().getPeerId().equals(meid)) continue;
            nlst.add(l);
        }
        if (nlst.size() > 0) {
            double rv = this.Random.nextDouble();
            rv *= rv;
            int idx = (int)((double)nlst.size() * rv);
            idx = Math.min(idx, nlst.size() - 1);
            addpeer = ((LocalNetworkAuthorization)nlst.get(idx)).getNetworkAuthorization().getPeerId();
        }
        return addpeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BBytes getNewPeerForPosts(HashSet<BBytes> conpeers) {
        Log.info("Pick peer for post update.");
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            List<LocalNetworkAuthorization> plist = this.CoreDB.getOrderedPostsRequestedNotDispatched();
            Log.info("getOrderedPostsRequestedNotDispatched: " + plist.size());
            if (plist.size() > 0) {
                boolean found = false;
                LocalNetworkAuthorization lna = plist.get(0);
                BBytes netid = lna.getNetworkAuthorization().getNetworkId();
                BBytes peerid = lna.getNetworkAuthorization().getPeerId();
                Log.info("Trying to find a peer to request posts from peer: " + peerid.toString().substring(0, 10) + " network: " + netid.toString().substring(0, 10));
                Iterator<BBytes> i = conpeers.iterator();
                while (!found && i.hasNext()) {
                    BBytes conpeer = i.next();
                    LocalNetworkAuthorization plna = this.CoreDB.getNetworkAuth(netid, conpeer);
                    Log.info("Check if connected peer has auth to the network requesting: " + plna);
                    if (plna == null) continue;
                    Log.info("Connected peer found!!!");
                    found = true;
                }
                if (!found) {
                    BBytes addpeer = null;
                    Date now = this.Time.getTime();
                    int cnt = 0;
                    while (cnt < this.NumberTimeConnectedSteps && addpeer == null) {
                        Date then = new Date(now.getTime() - (long)(cnt + 1) * this.TimeConnectedSteps);
                        addpeer = this.pickPeerForPosts(netid, then);
                        Log.info("pickPeerForPosts: " + addpeer + " :: " + cnt);
                        ++cnt;
                    }
                    if (addpeer == null) {
                        Date then = new Date(0L);
                        addpeer = this.pickPeerForPosts(netid, then);
                        Log.info("pickPeerForPosts: " + addpeer + " FINAL");
                    }
                    return addpeer;
                }
            }
        }
        return null;
    }

    private BBytes pickPeerForNetwork(Set<BBytes> conpeers, Date then) {
        BBytes addpeer = null;
        List<LocalPeer> plst = this.CoreDB.getOrderedMostNetworksLastDate(then);
        LinkedList<BBytes> pplst = new LinkedList<BBytes>();
        BBytes myid = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
        for (LocalPeer lp : plst) {
            if (conpeers.contains(lp.getPeer().getIdentity()) || myid.equals(lp.getPeer().getIdentity())) continue;
            pplst.add(lp.getPeer().getIdentity());
        }
        if (pplst.size() > 0) {
            double rv = this.Random.nextDouble();
            rv *= rv;
            int idx = (int)((double)pplst.size() * rv);
            idx = Math.min(idx, pplst.size() - 1);
            addpeer = (BBytes)pplst.get(idx);
        }
        return addpeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BBytes getNewPeerForNetworks(HashSet<BBytes> conpeers) {
        if (conpeers.size() < this.MaxConnections) {
            DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
            synchronized (dataBaseCoreInterface) {
                if (this.CoreDB.getHighestPriorityNeteworkRequest() != null) {
                    BBytes addpeer = null;
                    Date now = this.Time.getTime();
                    int cnt = 0;
                    while (cnt < this.NumberTimeConnectedSteps && addpeer == null) {
                        Date then = new Date(now.getTime() - (long)(cnt + 1) * this.TimeConnectedSteps);
                        addpeer = this.pickPeerForNetwork(conpeers, then);
                        ++cnt;
                    }
                    if (addpeer == null) {
                        Date then = new Date(0L);
                        addpeer = this.pickPeerForNetwork(conpeers, then);
                    }
                    return addpeer;
                }
            }
        }
        return null;
    }

    private BBytes pickPeerForPublicPosts(Set<BBytes> conpeers, Date then) {
        BBytes addpeer = null;
        List<LocalPeer> plst = this.CoreDB.getOrderedMostPublicPostsLastDate(then);
        LinkedList<BBytes> pplst = new LinkedList<BBytes>();
        BBytes myid = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
        for (LocalPeer lp : plst) {
            if (conpeers.contains(lp.getPeer().getIdentity()) || myid.equals(lp.getPeer().getIdentity())) continue;
            pplst.add(lp.getPeer().getIdentity());
        }
        if (pplst.size() > 0) {
            double rv = this.Random.nextDouble();
            rv *= rv;
            int idx = (int)((double)pplst.size() * rv);
            idx = Math.min(idx, pplst.size() - 1);
            addpeer = (BBytes)pplst.get(idx);
        }
        return addpeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BBytes getNewPeerForPublicPosts(HashSet<BBytes> conpeers) {
        if (conpeers.size() < this.MaxConnections) {
            DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
            synchronized (dataBaseCoreInterface) {
                LocalPeer lp = this.CoreDB.getHighestPriorityPublicPostRequest();
                if (lp != null) {
                    Log.info("Highest priority public post request: " + lp.getPeer().getIdentity() + " rqst: " + lp.isRequestPublicPosts());
                    BBytes addpeer = null;
                    Date now = this.Time.getTime();
                    int cnt = 0;
                    while (cnt < this.NumberTimeConnectedSteps && addpeer == null) {
                        Date then = new Date(now.getTime() - (long)(cnt + 1) * this.TimeConnectedSteps);
                        addpeer = this.pickPeerForPublicPosts(conpeers, then);
                        ++cnt;
                    }
                    if (addpeer == null) {
                        Date then = new Date(0L);
                        addpeer = this.pickPeerForPublicPosts(conpeers, then);
                    }
                    return addpeer;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BBytes getNewPeerForPeers(HashSet<BBytes> conpeers) {
        if (conpeers.size() < this.MaxConnections) {
            DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
            synchronized (dataBaseCoreInterface) {
                LocalPeer lp = this.CoreDB.getHighestPriorityPeerRequest();
                if (lp != null) {
                    return lp.getPeer().getIdentity();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectToPeer(BBytes peer) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            ComPeerInterface com;
            LocalPeer lp;
            BBytes me = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
            if (!me.equals(peer) && (lp = this.CoreDB.getPeer(peer)) != null && (com = this.Com.getComPeerInterface(lp.getPeer())) != null) {
                this.newConnection(com, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reDispatch() {
        long cuttime = this.Time.getTime().getTime() - this.getReDispatchTime();
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            List<FileReference> l = this.CoreDB.getOrderedFilesRequestedAndDispatched();
            Log.info("Found files dispatched: " + l.size());
            for (FileReference r : l) {
                if (r.getUserRequestDispatchTime().getTime() >= cuttime) break;
                r.setUserRequestDispatched(false);
                this.CoreDB.saveFileReference(r);
                Log.info("Re-dispatch file: " + r.getFile() + " offset: " + r.getOffset());
            }
            List<LocalPeer> lpl = this.CoreDB.getOrderedNetworksRequestedAndDispatched();
            Log.info("Found networks dispatched: " + lpl.size());
            for (LocalPeer lp : lpl) {
                if (lp.getRequestNetworksDispatchedTime().getTime() >= cuttime) break;
                lp.setRequestNetworksDispatched(false);
                this.CoreDB.saveLocalPeer(lp);
            }
            lpl = this.CoreDB.getOrderedPublicPostsRequestedAndDispatched();
            Log.info("Found public posts dispatched: " + lpl.size());
            for (LocalPeer lp : lpl) {
                if (lp.getRequestPublicPostsDispatchedTime().getTime() >= cuttime) break;
                lp.setRequestPublicPostsDispatched(false);
                this.CoreDB.saveLocalPeer(lp);
            }
            List<LocalNetworkAuthorization> lll = this.CoreDB.getOrderedNetworkAuthsRequestedAndDispatched();
            Log.info("Found network auths dispatched: " + lll.size());
            for (LocalNetworkAuthorization ll : lll) {
                if (ll.getRequestAuthsDispatchedTime().getTime() >= cuttime) break;
                ll.setRequestAuthsDispatched(false);
                this.CoreDB.saveLocalNetworkAuth(ll);
            }
            lll = this.CoreDB.getOrderedPostsRequestedAndDispatched();
            Log.info("Found posts dispatched: " + lll.size());
            for (LocalNetworkAuthorization ll : lll) {
                if (ll.getRequestPostsDispatchedTime().getTime() >= cuttime) break;
                ll.setRequestPostsDispatched(false);
                this.CoreDB.saveLocalNetworkAuth(ll);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canReConnectYet(BBytes pid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalPeer lp = this.CoreDB.getPeer(pid);
            return lp.getLastConnectionTime().compareTo(this.Time.getTime()) <= 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        BBytes newpeerpeer;
        BBytes newpubpeer;
        BBytes newnetpeer;
        BBytes newpostpeer;
        this.reDispatch();
        String me = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity().toString();
        Log.info("[" + me + "]");
        HashSet<BBytes> conpeers = new HashSet<BBytes>();
        HashSet<BBytes> newconpeers = new HashSet<BBytes>();
        Map<BBytes, ComPeerInterface> map = this.Connections;
        synchronized (map) {
            conpeers.addAll(this.Connections.keySet());
        }
        BBytes newfilepeer = this.getNewPeerForFiles(conpeers);
        if (newfilepeer != null && this.canReConnectYet(newfilepeer)) {
            Log.info("New peer for files: " + newfilepeer);
            newconpeers.add(newfilepeer);
        }
        if ((newpostpeer = this.getNewPeerForPosts(conpeers)) != null && this.canReConnectYet(newpostpeer)) {
            Log.info("New peer for posts: " + newpostpeer);
            newconpeers.add(newpostpeer);
        }
        if ((newnetpeer = this.getNewPeerForNetworks(conpeers)) != null && this.canReConnectYet(newnetpeer)) {
            Log.info("New peer for networks: " + newnetpeer);
            newconpeers.add(newnetpeer);
        }
        if ((newpubpeer = this.getNewPeerForPublicPosts(conpeers)) != null && this.canReConnectYet(newpubpeer)) {
            Log.info("New peer for public posts: " + newpubpeer);
            newconpeers.add(newpubpeer);
        }
        if ((newpeerpeer = this.getNewPeerForPeers(conpeers)) != null && this.canReConnectYet(newpeerpeer)) {
            Log.info("New peer for peers: " + newpeerpeer);
            newconpeers.add(newpeerpeer);
        }
        for (BBytes b : newconpeers) {
            Log.info("Go connect to new peer: " + b);
            this.connectToPeer(b);
        }
        int numconnects = conpeers.size() + newconpeers.size();
        while (numconnects > this.MaxConnections) {
            --numconnects;
            ComPeerInterface con = null;
            Map<BBytes, ComPeerInterface> map2 = this.Connections;
            synchronized (map2) {
                Date oldtime = null;
                for (ComPeerInterface c : this.Connections.values()) {
                    if (c.isBusy()) continue;
                    if (oldtime == null) {
                        con = c;
                        oldtime = con.getLastRequestTime();
                        continue;
                    }
                    if (oldtime.compareTo(c.getLastRequestTime()) <= 0) continue;
                    con = c;
                    oldtime = con.getLastRequestTime();
                }
            }
            if (con == null) continue;
            Log.info("Closing old connection because there are too many.");
            con.Close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestReady() {
        Map<BBytes, ComPeerInterface> map = this.Connections;
        synchronized (map) {
            for (ComPeerInterface c : this.Connections.values()) {
                c.requestReady();
            }
        }
    }

    public File getTemplateDir() {
        return this.TemplateDir;
    }

    public void setTemplateDir(File templateDir) {
        this.TemplateDir = templateDir;
    }

    @Override
    public void addConnectionListeners(ConnectionUpdateInterface c) {
        this.Events.addConnectionListeners(c);
    }

    @Override
    public void setEventDispatcher(EventDispatcher e) {
        this.Events = e;
    }

    public long getReDispatchTime() {
        return this.ReDispatchTime;
    }

    public void setReDispatchTime(long reDispatchTime) {
        this.ReDispatchTime = reDispatchTime;
    }

    public long getReConnectTime() {
        return this.ReConnectTime;
    }

    public void setReConnectTime(long reConnectTime) {
        this.ReConnectTime = reConnectTime;
    }
}

