/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.i2p.I2PAppContext;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

public class SimpleScheduler {
    private static final int MIN_THREADS = 2;
    private static final int MAX_THREADS = 4;
    private final Log _log;
    private final ScheduledThreadPoolExecutor _executor;
    private final String _name;
    private int _count;
    private final int _threads;

    public static SimpleScheduler getInstance() {
        return I2PAppContext.getGlobalContext().simpleScheduler();
    }

    public SimpleScheduler(I2PAppContext context) {
        this(context, "SimpleScheduler");
    }

    private SimpleScheduler(I2PAppContext context, String name) {
        this._log = context.logManager().getLog(SimpleScheduler.class);
        this._name = name;
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory == Long.MAX_VALUE) {
            maxMemory = 0x6000000L;
        }
        this._threads = (int)Math.max(2L, Math.min(4L, 1L + maxMemory / 0x2000000L));
        this._executor = new ScheduledThreadPoolExecutor(this._threads, new CustomThreadFactory());
        this._executor.prestartAllCoreThreads();
        context.addShutdownTask(new Shutdown());
    }

    public void stop() {
        this._executor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
        this._executor.shutdownNow();
    }

    public void addEvent(SimpleTimer.TimedEvent event, long timeoutMs) {
        if (event == null) {
            throw new IllegalArgumentException("addEvent null");
        }
        RunnableEvent re = new RunnableEvent(event, timeoutMs);
        re.schedule();
    }

    public void addPeriodicEvent(SimpleTimer.TimedEvent event, long timeoutMs) {
        this.addPeriodicEvent(event, timeoutMs, timeoutMs);
    }

    public void addPeriodicEvent(SimpleTimer.TimedEvent event, long initialDelay, long timeoutMs) {
        if (event == null) {
            throw new IllegalArgumentException("addEvent null");
        }
        PeriodicRunnableEvent re = new PeriodicRunnableEvent(event, initialDelay, timeoutMs);
        ((RunnableEvent)re).schedule();
    }

    private String debug() {
        return " Pool: " + this._name + " Active: " + this._executor.getActiveCount() + '/' + this._executor.getPoolSize() + " Completed: " + this._executor.getCompletedTaskCount() + " Queued: " + this._executor.getQueue().size();
    }

    private class CustomThreadFactory
    implements ThreadFactory {
        private CustomThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread rv = Executors.defaultThreadFactory().newThread(r);
            rv.setName(SimpleScheduler.this._name + ' ' + ++SimpleScheduler.this._count + '/' + SimpleScheduler.this._threads);
            rv.setDaemon(true);
            return rv;
        }
    }

    private class PeriodicRunnableEvent
    extends RunnableEvent {
        private long _timeoutMs;
        private long _initialDelay;

        public PeriodicRunnableEvent(SimpleTimer.TimedEvent t, long initialDelay, long timeoutMs) {
            super(t, timeoutMs);
            this._initialDelay = initialDelay;
            this._timeoutMs = timeoutMs;
            this._scheduled = initialDelay + System.currentTimeMillis();
        }

        public void schedule() {
            SimpleScheduler.this._executor.scheduleWithFixedDelay(this, this._initialDelay, this._timeoutMs, TimeUnit.MILLISECONDS);
        }

        public void run() {
            super.run();
            this._scheduled = this._timeoutMs + System.currentTimeMillis();
        }
    }

    private class RunnableEvent
    implements Runnable {
        protected final SimpleTimer.TimedEvent _timedEvent;
        protected long _scheduled;

        public RunnableEvent(SimpleTimer.TimedEvent t, long timeoutMs) {
            if (SimpleScheduler.this._log.shouldLog(10)) {
                SimpleScheduler.this._log.debug("Creating w/ delay " + timeoutMs + " : " + t);
            }
            this._timedEvent = t;
            this._scheduled = timeoutMs + System.currentTimeMillis();
        }

        public void schedule() {
            SimpleScheduler.this._executor.schedule(this, this._scheduled - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        public void run() {
            long completed;
            if (SimpleScheduler.this._log.shouldLog(10)) {
                SimpleScheduler.this._log.debug("Running: " + this._timedEvent);
            }
            long before = System.currentTimeMillis();
            if (SimpleScheduler.this._log.shouldLog(30) && before < this._scheduled - 100L) {
                SimpleScheduler.this._log.warn(SimpleScheduler.this._name + " wtf, early execution " + (this._scheduled - before) + ": " + this._timedEvent);
            } else if (SimpleScheduler.this._log.shouldLog(30) && before > this._scheduled + 1000L) {
                SimpleScheduler.this._log.warn(" wtf, late execution " + (before - this._scheduled) + ": " + this._timedEvent + SimpleScheduler.this.debug());
            }
            try {
                this._timedEvent.timeReached();
            }
            catch (Throwable t) {
                SimpleScheduler.this._log.log(50, SimpleScheduler.this._name + ": Scheduled task " + this._timedEvent + " exited unexpectedly, please report", t);
            }
            long time = System.currentTimeMillis() - before;
            if (time > 1000L && SimpleScheduler.this._log.shouldLog(30)) {
                SimpleScheduler.this._log.warn(SimpleScheduler.this._name + " wtf, event execution took " + time + ": " + this._timedEvent);
            }
            if (SimpleScheduler.this._log.shouldLog(20) && (completed = SimpleScheduler.this._executor.getCompletedTaskCount()) % 250L == 0L) {
                SimpleScheduler.this._log.info(SimpleScheduler.this.debug());
            }
        }
    }

    private class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        public void run() {
            SimpleScheduler.this.stop();
        }
    }
}

