/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class ShellCommand {
    private static final boolean DEBUG = false;
    private static final boolean CONSUME_OUTPUT = true;
    private static final boolean NO_CONSUME_OUTPUT = false;
    private static final boolean WAIT_FOR_EXIT_STATUS = true;
    private static final boolean NO_WAIT_FOR_EXIT_STATUS = false;
    private InputStream _errorStream;
    private InputStream _inputStream;
    private OutputStream _outputStream;
    private static final int BUFFER_SIZE = 1024;

    public void execute(String shellCommand) {
        this.execute(shellCommand, false, false);
    }

    public boolean executeAndWait(String shellCommand) {
        return this.execute(shellCommand, false, true);
    }

    public boolean executeAndWaitTimed(String shellCommand, int seconds) {
        Result result = new Result();
        CommandThread commandThread = new CommandThread(shellCommand, false, result);
        commandThread.start();
        try {
            if (seconds > 0) {
                commandThread.join(seconds * 1000);
                if (commandThread.isAlive()) {
                    return true;
                }
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return result.commandSuccessful;
    }

    public void executeSilent(String shellCommand) throws IOException {
        Runtime.getRuntime().exec(shellCommand, null);
    }

    public boolean executeSilentAndWait(String shellCommand) {
        return this.execute(shellCommand, true, true);
    }

    public boolean executeSilentAndWaitTimed(String shellCommand, int seconds) {
        return this.executeSAWT(shellCommand, seconds);
    }

    public boolean executeSilentAndWaitTimed(String[] commandArray, int seconds) {
        return this.executeSAWT(commandArray, seconds);
    }

    private boolean executeSAWT(Object shellCommand, int seconds) {
        Object name = null;
        long begin = 0L;
        Result result = new Result();
        CommandThread commandThread = new CommandThread(shellCommand, true, result);
        commandThread.start();
        try {
            if (seconds > 0) {
                commandThread.join(seconds * 1000);
                if (commandThread.isAlive()) {
                    return true;
                }
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return result.commandSuccessful;
    }

    public InputStream getErrorStream() {
        return this._errorStream;
    }

    public InputStream getInputStream() {
        return this._inputStream;
    }

    public OutputStream getOutputStream() {
        return this._outputStream;
    }

    public static void main(String[] args) {
        if (args.length <= 0) {
            System.err.println("Usage: ShellCommand commandline");
            return;
        }
        try {
            Runtime.getRuntime().exec(args);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private boolean execute(Object shellCommand, boolean consumeOutput, boolean waitForExitStatus) {
        block13: {
            String name = null;
            try {
                Process process;
                if (shellCommand instanceof String) {
                    name = (String)shellCommand;
                    process = Runtime.getRuntime().exec(name);
                } else if (shellCommand instanceof String[]) {
                    String[] arr = (String[])shellCommand;
                    process = Runtime.getRuntime().exec(arr);
                } else {
                    throw new ClassCastException("shell command must be a String or a String[]");
                }
                if (consumeOutput) {
                    StreamConsumer processStderrConsumer = new StreamConsumer(process.getErrorStream());
                    processStderrConsumer.start();
                    StreamConsumer processStdoutConsumer = new StreamConsumer(process.getInputStream());
                    processStdoutConsumer.start();
                } else {
                    this._errorStream = process.getErrorStream();
                    this._inputStream = process.getInputStream();
                    this._outputStream = process.getOutputStream();
                    StreamReader processStderrReader = new StreamReader(this._errorStream);
                    processStderrReader.start();
                    StreamWriter processStdinWriter = new StreamWriter(this._outputStream);
                    processStdinWriter.start();
                    StreamReader processStdoutReader = new StreamReader(this._inputStream);
                    processStdoutReader.start();
                }
                if (!waitForExitStatus) break block13;
                try {
                    process.waitFor();
                }
                catch (Exception e) {
                    if (!consumeOutput) {
                        this.killStreams();
                    }
                    return false;
                }
                if (!consumeOutput) {
                    this.killStreams();
                }
                if (process.exitValue() > 0) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private void killStreams() {
        try {
            this._errorStream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this._inputStream.close();
        }
        catch (IOException e1) {
            // empty catch block
        }
        try {
            this._outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._errorStream = null;
        this._inputStream = null;
        this._outputStream = null;
    }

    private class CommandThread
    extends Thread {
        private final boolean consumeOutput;
        private final Object shellCommand;
        private final Result result;

        CommandThread(Object shellCommand2, boolean consumeOutput, Result result) {
            super("ShellCommand Executor");
            this.shellCommand = shellCommand2;
            this.consumeOutput = consumeOutput;
            this.result = result;
        }

        public void run() {
            this.result.commandSuccessful = ShellCommand.this.execute(this.shellCommand, this.consumeOutput, true);
        }
    }

    private static class Result {
        public volatile boolean commandSuccessful;

        private Result() {
        }
    }

    private static class StreamConsumer
    extends Thread {
        private final BufferedReader bufferedReader;

        public StreamConsumer(InputStream inputStream) {
            super("ShellCommand Consumer");
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            this.bufferedReader = new BufferedReader(inputStreamReader);
        }

        public void run() {
            try {
                while (this.bufferedReader.readLine() != null) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class StreamReader
    extends Thread {
        private final BufferedReader bufferedReader;

        public StreamReader(InputStream inputStream) {
            super("ShellCommand Reader");
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            this.bufferedReader = new BufferedReader(inputStreamReader);
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            buffer = new char[1024];
            try {
                block2: while (true) {
                    if ((bytesRead = this.bufferedReader.read(buffer, 0, 1024)) == -1) {
                        continue;
                    }
                    i = 0;
                    while (true) {
                        if (i < bytesRead) ** break;
                        continue block2;
                        System.out.print(buffer[i]);
                        ++i;
                    }
                    break;
                }
            }
            catch (IOException var3_4) {
                return;
            }
        }
    }

    private static class StreamWriter
    extends Thread {
        private final BufferedWriter bufferedWriter;

        public StreamWriter(OutputStream outputStream) {
            super("ShellCommand Writer");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            this.bufferedWriter = new BufferedWriter(outputStreamWriter);
        }

        public void run() {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            try {
                while (true) {
                    this.bufferedWriter.write(in.readLine());
                    this.bufferedWriter.write("\r\n");
                    this.bufferedWriter.flush();
                }
            }
            catch (IOException e) {
                try {
                    this.bufferedWriter.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
        }
    }
}

