/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.datagram;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.crypto.DSAEngine;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.DataFormatException;
import net.i2p.data.SigningPrivateKey;
import net.i2p.util.Log;

public final class I2PDatagramMaker {
    private static final int DGRAM_BUFSIZE = 32768;
    private final SHA256Generator hashGen = SHA256Generator.getInstance();
    private final DSAEngine dsaEng = DSAEngine.getInstance();
    private SigningPrivateKey sxPrivKey;
    private byte[] sxDestBytes;
    private final ByteArrayOutputStream sxDGram = new ByteArrayOutputStream(32768);

    public I2PDatagramMaker(I2PSession session) {
        this();
        this.setI2PDatagramMaker(session);
    }

    public I2PDatagramMaker() {
    }

    public void setI2PDatagramMaker(I2PSession session) {
        this.sxPrivKey = session.getPrivateKey();
        this.sxDestBytes = session.getMyDestination().toByteArray();
    }

    public byte[] makeI2PDatagram(byte[] payload) {
        this.sxDGram.reset();
        try {
            this.sxDGram.write(this.sxDestBytes);
            this.dsaEng.sign(this.hashGen.calculateHash(payload).toByteArray(), this.sxPrivKey).writeBytes(this.sxDGram);
            this.sxDGram.write(payload);
            return this.sxDGram.toByteArray();
        }
        catch (IOException e) {
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(I2PDatagramMaker.class);
            log.error("Caught IOException", e);
            return null;
        }
        catch (DataFormatException e) {
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(I2PDatagramMaker.class);
            log.error("Caught DataFormatException", e);
            return null;
        }
    }
}

