/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.Connection;
import net.i2p.client.streaming.ConnectionOptions;
import net.i2p.data.Destination;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

class TCBShare {
    private final I2PAppContext _context;
    private final Log _log;
    private final Map<Destination, Entry> _cache;
    private final CleanEvent _cleaner;
    private static final long EXPIRE_TIME = 1800000L;
    private static final long CLEAN_TIME = 600000L;
    private static final double RTT_DAMPENING = 0.75;
    private static final double WDW_DAMPENING = 0.75;
    private static final int MAX_RTT = 22500;
    private static final int MAX_WINDOW_SIZE = 24;

    public TCBShare(I2PAppContext ctx, SimpleTimer2 timer) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(TCBShare.class);
        this._cache = new ConcurrentHashMap<Destination, Entry>(4);
        this._cleaner = new CleanEvent(timer);
        this._cleaner.schedule(600000L);
    }

    public void stop() {
        this._cleaner.cancel();
        this._cache.clear();
    }

    public void updateOptsFromShare(Connection con) {
        Destination dest = con.getRemotePeer();
        if (dest == null) {
            return;
        }
        ConnectionOptions opts = con.getOptions();
        if (opts == null) {
            return;
        }
        Entry e = this._cache.get(dest);
        if (e == null || e.isExpired()) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("From cache: " + con.getSession().getMyDestination().calculateHash().toBase64().substring(0, 4) + '-' + dest.calculateHash().toBase64().substring(0, 4) + " RTT: " + e.getRTT() + " wdw: " + e.getWindowSize());
        }
        opts.setRTT(e.getRTT());
        opts.setWindowSize(e.getWindowSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateShareOpts(Connection con) {
        Destination dest = con.getRemotePeer();
        if (dest == null) {
            return;
        }
        if (con.getAckedPackets() <= 0L) {
            return;
        }
        ConnectionOptions opts = con.getOptions();
        if (opts == null) {
            return;
        }
        int old = -1;
        int oldw = -1;
        Entry e = this._cache.get(dest);
        if (e == null || e.isExpired()) {
            e = new Entry(opts.getRTT(), opts.getWindowSize());
            this._cache.put(dest, e);
        } else {
            Entry entry = e;
            synchronized (entry) {
                old = e.getRTT();
                oldw = e.getWindowSize();
                e.setRTT(opts.getRTT());
                e.setWindowSize(opts.getWindowSize());
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("To cache: " + con.getSession().getMyDestination().calculateHash().toBase64().substring(0, 4) + '-' + dest.calculateHash().toBase64().substring(0, 4) + " old: " + old + " con: " + opts.getRTT() + " new: " + e.getRTT() + " oldw: " + oldw + " conw: " + opts.getWindowSize() + " neww: " + e.getWindowSize());
        }
    }

    private class CleanEvent
    extends SimpleTimer2.TimedEvent {
        public CleanEvent(SimpleTimer2 timer) {
            super(timer);
        }

        public void timeReached() {
            Iterator iter = TCBShare.this._cache.values().iterator();
            while (iter.hasNext()) {
                if (!((Entry)iter.next()).isExpired()) continue;
                iter.remove();
            }
            this.schedule(600000L);
        }
    }

    private class Entry {
        int _rtt;
        int _wdw;
        long _updated;

        public Entry(int ms, int wdw) {
            this._rtt = ms;
            this._wdw = wdw;
            this._updated = TCBShare.this._context.clock().now();
        }

        public synchronized int getRTT() {
            return this._rtt;
        }

        public synchronized void setRTT(int ms) {
            this._rtt = (int)(0.75 * (double)this._rtt + 0.25 * (double)ms);
            if (this._rtt > 22500) {
                this._rtt = 22500;
            }
            this._updated = TCBShare.this._context.clock().now();
        }

        public synchronized int getWindowSize() {
            return this._wdw;
        }

        public synchronized void setWindowSize(int wdw) {
            this._wdw = (int)(0.5 + 0.75 * (double)this._wdw + 0.25 * (double)wdw);
            if (this._wdw > 24) {
                this._wdw = 24;
            }
            this._updated = TCBShare.this._context.clock().now();
        }

        public synchronized boolean isExpired() {
            return this._updated < TCBShare.this._context.clock().now() - 1800000L;
        }
    }
}

