/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.transactionlog;

import com.db4o.foundation.IntByRef;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.slots.Slot;
import com.db4o.internal.slots.SlotChange;

public abstract class TransactionLogHandler {
    protected LocalObjectContainer file(LocalTransaction trans) {
        return trans.file();
    }

    protected void flushDatabaseFile(LocalTransaction trans) {
        trans.flushFile();
    }

    protected void appendSlotChanges(LocalTransaction trans, final ByteArrayBuffer writer) {
        trans.traverseSlotChanges(new Visitor4(){

            public void visit(Object obj) {
                ((SlotChange)obj).write(writer);
            }
        });
    }

    protected int transactionLogSlotLength(LocalTransaction trans) {
        return (this.countSlotChanges(trans) * 3 + 2) * 4;
    }

    protected int countSlotChanges(LocalTransaction trans) {
        final IntByRef count = new IntByRef();
        trans.traverseSlotChanges(new Visitor4(){

            public void visit(Object obj) {
                SlotChange slot = (SlotChange)obj;
                if (slot.isSetPointer()) {
                    ++count.value;
                }
            }
        });
        return count.value;
    }

    public abstract Slot allocateSlot(LocalTransaction var1, boolean var2);

    public abstract void applySlotChanges(LocalTransaction var1, Slot var2);

    public abstract boolean checkForInterruptedTransaction(LocalTransaction var1, ByteArrayBuffer var2);

    public abstract void completeInterruptedTransaction(LocalTransaction var1);

    public abstract void close();
}

