/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.fileheader;

import com.db4o.ext.Db4oDatabase;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.SystemData;
import com.db4o.internal.Transaction;
import com.db4o.internal.activation.FixedActivationDepth;

public class FileHeaderVariablePart1
extends PersistentBase {
    private static final int LENGTH = 25;
    private final SystemData _systemData;

    public FileHeaderVariablePart1(int id, SystemData systemData) {
        this.setID(id);
        this._systemData = systemData;
    }

    SystemData systemData() {
        return this._systemData;
    }

    public byte getIdentifier() {
        return 72;
    }

    public int ownLength() {
        return 25;
    }

    public void readThis(Transaction trans, ByteArrayBuffer reader) {
        this._systemData.converterVersion(reader.readInt());
        this._systemData.freespaceSystem(reader.readByte());
        this._systemData.freespaceAddress(reader.readInt());
        this.readIdentity((LocalTransaction)trans, reader.readInt());
        this._systemData.lastTimeStampID(reader.readLong());
        this._systemData.uuidIndexId(reader.readInt());
    }

    public void writeThis(Transaction trans, ByteArrayBuffer writer) {
        writer.writeInt(this._systemData.converterVersion());
        writer.writeByte(this._systemData.freespaceSystem());
        writer.writeInt(this._systemData.freespaceAddress());
        writer.writeInt(this._systemData.identity().getID(trans));
        writer.writeLong(this._systemData.lastTimeStampID());
        writer.writeInt(this._systemData.uuidIndexId());
    }

    private void readIdentity(LocalTransaction trans, int identityID) {
        LocalObjectContainer file = trans.file();
        Db4oDatabase identity = (Db4oDatabase)file.getByID(trans, identityID);
        if (null != identity) {
            file.activate(trans, identity, new FixedActivationDepth(2));
            this._systemData.identity(identity);
        }
    }
}

