/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.caching;

import com.db4o.foundation.CircularIntBuffer4;
import com.db4o.foundation.Function4;
import com.db4o.foundation.Procedure4;
import com.db4o.internal.caching.PurgeableCache4;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LRUIntCache<V>
implements PurgeableCache4<Integer, V> {
    private final Map<Integer, V> _slots;
    private final CircularIntBuffer4 _lru;
    private final int _maxSize;

    LRUIntCache(int size) {
        this._maxSize = size;
        this._slots = new HashMap<Integer, V>(size);
        this._lru = new CircularIntBuffer4(size);
    }

    @Override
    public V produce(Integer key, Function4<Integer, V> producer, Procedure4<V> finalizer) {
        V value = this._slots.get(key);
        if (value == null) {
            V newValue = producer.apply(key);
            if (newValue == null) {
                return null;
            }
            if (this._slots.size() >= this._maxSize) {
                V discarded = this._slots.remove(this._lru.removeLast());
                if (null != finalizer) {
                    finalizer.apply(discarded);
                }
            }
            this._slots.put(key, newValue);
            this._lru.addFirst(key);
            return newValue;
        }
        this._lru.remove(key);
        this._lru.addFirst(key);
        return value;
    }

    @Override
    public Iterator iterator() {
        return this._slots.values().iterator();
    }

    @Override
    public V purge(Integer key) {
        V removed = this._slots.remove(key);
        if (removed == null) {
            return null;
        }
        this._lru.remove(key);
        return removed;
    }
}

