/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.config.ObjectAttribute;
import com.db4o.config.ObjectClass;
import com.db4o.config.ObjectField;
import com.db4o.config.ObjectTranslator;
import com.db4o.ext.Db4oException;
import com.db4o.foundation.DeepClone;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.KeySpec;
import com.db4o.foundation.KeySpecHashtable4;
import com.db4o.foundation.TernaryBool;
import com.db4o.internal.Config4Abstract;
import com.db4o.internal.Config4Field;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.ReflectPlatform;
import com.db4o.internal.Renames;
import com.db4o.reflect.ReflectClass;

public class Config4Class
extends Config4Abstract
implements ObjectClass,
DeepClone {
    private final Config4Impl _configImpl;
    private static final KeySpec CALL_CONSTRUCTOR_KEY = new KeySpec(TernaryBool.UNSPECIFIED);
    private static final KeySpec CLASS_INDEXED_KEY = new KeySpec(true);
    private static final KeySpec EXCEPTIONAL_FIELDS_KEY = new KeySpec(null);
    private static final KeySpec GENERATE_UUIDS_KEY = new KeySpec(TernaryBool.UNSPECIFIED);
    private static final KeySpec GENERATE_VERSION_NUMBERS_KEY = new KeySpec(TernaryBool.UNSPECIFIED);
    private static final KeySpec MAINTAIN_METACLASS_KEY = new KeySpec(true);
    private static final KeySpec MAXIMUM_ACTIVATION_DEPTH_KEY = new KeySpec(0);
    private static final KeySpec MINIMUM_ACTIVATION_DEPTH_KEY = new KeySpec(0);
    private static final KeySpec PERSIST_STATIC_FIELD_VALUES_KEY = new KeySpec(false);
    private static final KeySpec QUERY_ATTRIBUTE_PROVIDER_KEY = new KeySpec(null);
    private static final KeySpec STORE_TRANSIENT_FIELDS_KEY = new KeySpec(false);
    private static final KeySpec TRANSLATOR_KEY = new KeySpec(null);
    private static final KeySpec TRANSLATOR_NAME_KEY = new KeySpec(null);
    private static final KeySpec UPDATE_DEPTH_KEY = new KeySpec(-1);
    private static final KeySpec WRITE_AS_KEY = new KeySpec(null);

    protected Config4Class(Config4Impl configuration, KeySpecHashtable4 config) {
        super(config);
        this._configImpl = configuration;
    }

    Config4Class(Config4Impl a_configuration, String a_name) {
        this._configImpl = a_configuration;
        this.setName(a_name);
    }

    public int adjustActivationDepth(int depth) {
        TernaryBool cascadeOnActivate = this.cascadeOnActivate();
        if (cascadeOnActivate.definiteYes() && depth < 2) {
            depth = 2;
        }
        if (cascadeOnActivate.definiteNo() && depth > 1) {
            depth = 1;
        }
        if (this.config().classActivationDepthConfigurable()) {
            int maximumActivationDepth;
            int minimumActivationDepth = this.minimumActivationDepth();
            if (minimumActivationDepth != 0 && depth < minimumActivationDepth) {
                depth = minimumActivationDepth;
            }
            if ((maximumActivationDepth = this.maximumActivationDepth()) != 0 && depth > maximumActivationDepth) {
                depth = maximumActivationDepth;
            }
        }
        return depth;
    }

    public void callConstructor(boolean flag) {
        this.putThreeValued(CALL_CONSTRUCTOR_KEY, flag);
    }

    String className() {
        return this.getName();
    }

    ReflectClass classReflector() {
        return this.config().reflector().forName(this.getName());
    }

    public void compare(ObjectAttribute comparator) {
        this._config.put(QUERY_ATTRIBUTE_PROVIDER_KEY, comparator);
    }

    Config4Field configField(String fieldName) {
        Hashtable4 exceptionalFields = this.exceptionalFieldsOrNull();
        if (exceptionalFields == null) {
            return null;
        }
        Config4Field config4Field = (Config4Field)exceptionalFields.get(fieldName);
        if (config4Field == null) {
            return null;
        }
        config4Field.used(true);
        return config4Field;
    }

    public Object deepClone(Object param) {
        Config4Impl parentConfig = ((Config4Impl.ConfigDeepCloneContext)param)._cloned;
        return new Config4Class(parentConfig, this._config);
    }

    public void enableReplication(boolean setting) {
        this.generateUUIDs(setting);
        this.generateVersionNumbers(setting);
    }

    public void generateUUIDs(boolean setting) {
        this._config.put(GENERATE_UUIDS_KEY, TernaryBool.forBoolean(setting));
    }

    public void generateVersionNumbers(boolean setting) {
        this._config.put(GENERATE_VERSION_NUMBERS_KEY, TernaryBool.forBoolean(setting));
    }

    public ObjectTranslator getTranslator() {
        ObjectTranslator translator = (ObjectTranslator)this._config.get(TRANSLATOR_KEY);
        if (translator != null) {
            return translator;
        }
        String translatorName = this._config.getAsString(TRANSLATOR_NAME_KEY);
        if (translatorName == null) {
            return null;
        }
        try {
            translator = this.newTranslatorFromReflector(translatorName);
        }
        catch (RuntimeException t) {
            try {
                translator = this.newTranslatorFromPlatform(translatorName);
            }
            catch (Exception e) {
                throw new Db4oException(e);
            }
        }
        this.translate(translator);
        return translator;
    }

    private ObjectTranslator newTranslatorFromPlatform(String translatorName) throws InstantiationException, IllegalAccessException {
        return (ObjectTranslator)ReflectPlatform.forName(translatorName).newInstance();
    }

    private ObjectTranslator newTranslatorFromReflector(String translatorName) {
        return (ObjectTranslator)this.config().reflector().forName(translatorName).newInstance();
    }

    public void indexed(boolean flag) {
        this._config.put(CLASS_INDEXED_KEY, flag);
    }

    public boolean indexed() {
        return this._config.getAsBoolean(CLASS_INDEXED_KEY);
    }

    public void maximumActivationDepth(int depth) {
        this._config.put(MAXIMUM_ACTIVATION_DEPTH_KEY, depth);
    }

    int maximumActivationDepth() {
        return this._config.getAsInt(MAXIMUM_ACTIVATION_DEPTH_KEY);
    }

    public void minimumActivationDepth(int depth) {
        this._config.put(MINIMUM_ACTIVATION_DEPTH_KEY, depth);
    }

    public int minimumActivationDepth() {
        return this._config.getAsInt(MINIMUM_ACTIVATION_DEPTH_KEY);
    }

    public TernaryBool callConstructor() {
        if (this._config.get(TRANSLATOR_KEY) != null) {
            return TernaryBool.YES;
        }
        return this._config.getAsTernaryBool(CALL_CONSTRUCTOR_KEY);
    }

    Hashtable4 exceptionalFieldsOrNull() {
        return (Hashtable4)this._config.get(EXCEPTIONAL_FIELDS_KEY);
    }

    private Hashtable4 exceptionalFields() {
        Hashtable4 exceptionalFieldsCollection = this.exceptionalFieldsOrNull();
        if (exceptionalFieldsCollection == null) {
            exceptionalFieldsCollection = new Hashtable4(16);
            this._config.put(EXCEPTIONAL_FIELDS_KEY, exceptionalFieldsCollection);
        }
        return exceptionalFieldsCollection;
    }

    public ObjectField objectField(String fieldName) {
        Hashtable4 exceptionalFieldsCollection = this.exceptionalFields();
        Config4Field c4f = (Config4Field)exceptionalFieldsCollection.get(fieldName);
        if (c4f == null) {
            c4f = new Config4Field(this, fieldName);
            exceptionalFieldsCollection.put(fieldName, (Object)c4f);
        }
        return c4f;
    }

    public void persistStaticFieldValues() {
        this._config.put(PERSIST_STATIC_FIELD_VALUES_KEY, true);
    }

    public void readAs(Object clazz) {
        Config4Impl configRef = this.config();
        ReflectClass claxx = configRef.reflectorFor(clazz);
        if (claxx == null) {
            return;
        }
        this._config.put(WRITE_AS_KEY, this.getName());
        configRef.readAs().put(this.getName(), (Object)claxx.getName());
    }

    public void rename(String newName) {
        this.config().rename(Renames.forClass(this.getName(), newName));
        this.setName(newName);
    }

    public void storeTransientFields(boolean flag) {
        this._config.put(STORE_TRANSIENT_FIELDS_KEY, flag);
    }

    public void translate(ObjectTranslator translator) {
        if (translator == null) {
            this._config.put(TRANSLATOR_NAME_KEY, null);
        }
        this._config.put(TRANSLATOR_KEY, translator);
    }

    void translateOnDemand(String a_translatorName) {
        this._config.put(TRANSLATOR_NAME_KEY, a_translatorName);
    }

    public void updateDepth(int depth) {
        this._config.put(UPDATE_DEPTH_KEY, depth);
    }

    Config4Impl config() {
        return this._configImpl;
    }

    TernaryBool generateUUIDs() {
        return (TernaryBool)this._config.get(GENERATE_UUIDS_KEY);
    }

    TernaryBool generateVersionNumbers() {
        return (TernaryBool)this._config.get(GENERATE_VERSION_NUMBERS_KEY);
    }

    void maintainMetaClass(boolean flag) {
        this._config.put(MAINTAIN_METACLASS_KEY, flag);
    }

    boolean staticFieldValuesArePersisted() {
        return this._config.getAsBoolean(PERSIST_STATIC_FIELD_VALUES_KEY);
    }

    public ObjectAttribute queryAttributeProvider() {
        return (ObjectAttribute)this._config.get(QUERY_ATTRIBUTE_PROVIDER_KEY);
    }

    public boolean storeTransientFields() {
        return this._config.getAsBoolean(STORE_TRANSIENT_FIELDS_KEY);
    }

    int updateDepth() {
        return this._config.getAsInt(UPDATE_DEPTH_KEY);
    }

    String writeAs() {
        return this._config.getAsString(WRITE_AS_KEY);
    }
}

