package org.ourfilesystem.utilities;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileLongIndex extends FileIndex {

	private long MaxValue;
	
	public FileLongIndex(String datadir, String indexfile) {
		super(datadir, indexfile);
	}

	@Override
	public Object readObject(InputStream is) throws IOException {
		Long v = FileUtils.readLong(is);
		if (v != null && v > MaxValue) {
			MaxValue = v;
		}
		return v;
	}

	@Override
	public void writeObject(OutputStream os, Object o) throws IOException {
		FileUtils.writeLong((Long)o, os);
		long v = (Long)o;
		if (v > MaxValue) {
			MaxValue = v;
		}
	}
	
	public long getMaxValue() {
		return MaxValue;
	}

}
