package org.ourfilesystem.simpleui;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import javax.swing.table.AbstractTableModel;

import org.ourfilesystem.db.LocalPost;
import org.ourfilesystem.utilities.FileUtils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class PostTableModel extends AbstractTableModel {
	private static final long serialVersionUID = 1L;

	private HashSet<PostRow> Rows;
	private HashMap<PostRow, LocalPost> Posts;
	
	private String[] columns = {
		"Peer",
		"Date",
		"Number",
		"Subject",
		"File Ref"
	};
	
	class PostRow {
		public String Peer;
		public Date Date;
		public long Number;
		public String Subject;
		public String FileRef;
		public int hashCode() {
			return Peer.hashCode() ^ Long.valueOf(Number).hashCode();
		}
		public boolean equals(Object o) {
			if (o == null) return false;
			if (!(o instanceof PostRow)) return false;
			PostRow pr = (PostRow)o;
			return pr.Peer.equals(Peer) && (pr.Number == Number);
		}
	}
	
	public PostTableModel() {
		Rows = new HashSet<PostRow>();
		Posts = new HashMap<PostRow, LocalPost>();
	}
	
	public void addAllPosts(List<LocalPost> pl) {
		Rows.clear();
		Iterator<LocalPost> i = pl.iterator();
		while (i.hasNext()) {
			LocalPost l = i.next();
			addPost(l);
		}
	}
	
	public void addPost(LocalPost lp) {
		PostRow pr = new PostRow();
		pr.Peer = lp.getPost().getSignedDigest().getPeerIdentifier().toString().substring(0, 10);
		pr.Date = lp.getLocalDate();
		pr.Number = lp.getPost().getPostNumber();
		if (lp.getPost().getFileReferenceDigest() != null) {
			pr.FileRef = lp.getPost().getFileReferenceDigest().toString().substring(0, 10);			
		}
		File mf = (File)lp.getPost().getMessage();
		try {
			FileInputStream fis = new FileInputStream(mf);
			pr.Subject = FileUtils.readString(fis);
			fis.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
		Rows.add(pr);
		Posts.put(pr, lp);
		this.fireTableDataChanged();
	}

	private PostRow getPostRow(int row) {
		PostRow r = null;
		Iterator<PostRow> i = Rows.iterator();
		int cnt = 0;
		while (i.hasNext() && cnt <= row) {
			r = i.next();
			cnt++;
		}
		return r;
	}
	
	public LocalPost getPost(int row) {
		return Posts.get(getPostRow(row));
	}
	
	public String getColumnName(int col) {
		return columns[col];
	}
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public Class getColumnClass(int col) {
		if (col == 0 || col == 3 || col == 4) {
			return String.class;
		}
		if (col == 1) {
			return Date.class;
		}
		if (col == 2) {
			return Long.class;
		}
		return null;
	}
	
	@Override
	public int getRowCount() {
		return Rows.size();
	}

	@Override
	public int getColumnCount() {
		return columns.length;
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		PostRow r = getPostRow(rowIndex);
		if (r != null) {
			if (columnIndex == 0) {
				return r.Peer;
			}
			if (columnIndex == 1) {
				return r.Date;
			}
			if (columnIndex == 2) {
				return r.Number;
			}
			if (columnIndex == 3) {
				return r.Subject;
			}
			if (columnIndex == 4) {
				return r.FileRef;
			}
		}		
		return null;
	}

}
