package org.ourfilesystem.simpleui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OFSSettings {

	private static String AUTOSIGN = "AUTOSIGN";
	private static String AUTOUPDATEPEERS = "AUTOPEERUPDATE";
	private static String AUTOUPDATEPOSTS = "AUTOPOSTUPDATE";
	private static String PEERUPDATEPERIOD = "PEERUPDATEPERIOD";
	private static String POSTUPDATEPERIOD = "POSTUPDATEPERIOD";
	
	private File PropertiesFile;
	private Properties Properties;
	
	public OFSSettings(String basedir) {
		Properties = new Properties();
		PropertiesFile = new File(basedir + File.separator + "properties.cfg");
		if (PropertiesFile.exists()) {
			try {
				FileInputStream fis = new FileInputStream(PropertiesFile);
				Properties.load(fis);
				fis.close();
			}
			catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	public String getProperty(String key, String defval) {
		return Properties.getProperty(key, defval);
	}
	
	public String getProperty(String key) {
		return Properties.getProperty(key);
	}
	
	public void setProperty(String key, String value) {
		Properties.setProperty(key, value);
		try {
			FileOutputStream fos = new FileOutputStream(PropertiesFile);
			Properties.store(fos, "please do not manually edit");
			fos.close();
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public boolean isAutoSign() {
		return Boolean.valueOf(getProperty(AUTOSIGN, Boolean.toString(false)));
	}

	public void setAutoSign(boolean val) {
		setProperty(AUTOSIGN, Boolean.toString(val));
	}
	
	public boolean isAutoUpdatePeers() {
		return Boolean.valueOf(getProperty(AUTOUPDATEPEERS, Boolean.toString(true)));		
	}
	
	public void setAutoUpdatePeers(boolean val) {
		setProperty(AUTOUPDATEPEERS, Boolean.toString(val));
	}
	
	public int getPeerUpdatePeriod() {
		return Integer.valueOf(getProperty(PEERUPDATEPERIOD, Integer.toString(30)));
	}
	
	public void setPeerUpdatePeriod(int val) {
		setProperty(PEERUPDATEPERIOD, Integer.toString(val));
	}
	
	public void setPeerUpdatePeriodStr(String sv) {
		setPeerUpdatePeriod(str2minutes(sv));
	}
	
	public String getPeerUpdatePeriodStr() {
		return minutes2str(getPeerUpdatePeriod());
	}
	
	public boolean isAutoUpdatePosts() {
		return Boolean.valueOf(getProperty(AUTOUPDATEPOSTS, Boolean.toString(true)));		
	}
	
	public void setAutoUpdatePosts(boolean val) {
		setProperty(AUTOUPDATEPOSTS, Boolean.toString(val));
	}
	
	public int getPostUpdatePeriod() {
		return Integer.valueOf(getProperty(POSTUPDATEPERIOD, Integer.toString(30)));
	}
	
	public void setPostUpdatePeriod(int val) {
		setProperty(POSTUPDATEPERIOD, Integer.toString(val));
	}
	
	public void setPostUpdatePeriodStr(String sv) {
		setPostUpdatePeriod(str2minutes(sv));
	}
	
	public String getPostUpdatePeriodStr() {
		return minutes2str(getPostUpdatePeriod());
	}
	
	private String minutes2str(int min) {
		if (min >= 60) {
			int hours = min / 60;
			return "" + hours + "h";
		}
		return "" + min + "m";
	}
	
	private int str2minutes(String val) {
		Matcher min = Pattern.compile("(\\d+)m").matcher(val);
		Matcher hr = Pattern.compile("(\\d+)h").matcher(val);
		if (min.find()) {
			int v = Integer.valueOf(min.group(1));
			return v;
		}
		else if (hr.find()) {
			int v = Integer.valueOf(min.group(1));
			v = v * 60;
			return v;
		}
		return 60;
	}
	
}
