package org.ourfilesystem.postcodec;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

import org.ourfilesystem.db.LocalPost;

public class PostDecoded {
	
	private HashMap<String,Set<String>> StringValues;
	private HashMap<String,Long> NumberValues;
	private HashMap<String,Set<Object>> OtherReferences;
	private String Comment;
	
	private LocalPost Post;
	
	public PostDecoded() {
		StringValues    = new HashMap<String,Set<String>>()  ;
		NumberValues    = new HashMap<String,Long>()    ;
		OtherReferences = new HashMap<String, Set<Object>>() ;
		
	}

	public HashMap<String, Set<String>> getStringValues() {
		return StringValues;
	}

	public void setStringValues(HashMap<String, Set<String>> stringValues) {
		StringValues = stringValues;
	}

	public HashMap<String, Long> getNumberValues() {
		return NumberValues;
	}
	
	public void pushStringValue(String key, String value) {
		Set<String> s = StringValues.get(key);
		if (s == null) {
			s = new HashSet<String>();
			StringValues.put(key, s);
		}
		s.add(value);
	}
	
	public void pushReferenceValue(String key, Object ref) {
		Set<Object> s = OtherReferences.get(key);
		if (s == null) {
			s = new HashSet<Object>();
			OtherReferences.put(key, s);
		}
		s.add(ref);
	}
	
	public Set<String> getStringKeySet(String key) {
		return StringValues.get(key);
	}

	public void setNumberValues(HashMap<String, Long> numberValues) {
		NumberValues = numberValues;
	}

	public HashMap<String, Set<Object>> getOtherReferences() {
		return OtherReferences;
	}

	public void setOtherReferences(HashMap<String, Set<Object>> otherReferences) {
		OtherReferences = otherReferences;
	}

	public String getComment() {
		return Comment;
	}

	public void setComment(String comment) {
		Comment = comment;
	}

	public LocalPost getPost() {
		return Post;
	}

	public void setPost(LocalPost post) {
		Post = post;
	}

}
