/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import net.i2p.client.streaming.ConnectionOptions;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketOptions;

class StandardSocket
extends Socket {
    private final I2PSocket _socket;

    StandardSocket(I2PSocket socket) {
        this._socket = socket;
    }

    public void bind(SocketAddress bindpoint) {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        if (this._socket.isClosed()) {
            throw new IOException("Already closed");
        }
        this._socket.close();
    }

    public void connect(SocketAddress endpoint) {
        throw new UnsupportedOperationException();
    }

    public void connect(SocketAddress endpoint, int timeout) {
        throw new UnsupportedOperationException();
    }

    public SocketChannel getChannel() {
        return null;
    }

    public InetAddress getInetAddress() {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        InputStream rv = this._socket.getInputStream();
        if (rv != null) {
            return rv;
        }
        throw new IOException("No stream");
    }

    public boolean getKeepAlive() {
        ConnectionOptions opts = (ConnectionOptions)this._socket.getOptions();
        if (opts == null) {
            return false;
        }
        return opts.getInactivityAction() == 2;
    }

    public InetAddress getLocalAddress() {
        return null;
    }

    public int getLocalPort() {
        return this._socket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return null;
    }

    public boolean getOOBInline() {
        return false;
    }

    public OutputStream getOutputStream() throws IOException {
        OutputStream rv = this._socket.getOutputStream();
        if (rv != null) {
            return rv;
        }
        throw new IOException("No stream");
    }

    public int getPort() {
        return this._socket.getPort();
    }

    public int getReceiveBufferSize() {
        ConnectionOptions opts = (ConnectionOptions)this._socket.getOptions();
        if (opts == null) {
            return 65536;
        }
        return opts.getInboundBufferSize();
    }

    public SocketAddress getRemoteSocketAddress() {
        throw new UnsupportedOperationException();
    }

    public boolean getReuseAddress() {
        return false;
    }

    public int getSendBufferSize() {
        ConnectionOptions opts = (ConnectionOptions)this._socket.getOptions();
        if (opts == null) {
            return 65536;
        }
        return opts.getInboundBufferSize();
    }

    public int getSoLinger() {
        I2PSocketOptions opts = this._socket.getOptions();
        if (opts == null) {
            return -1;
        }
        return -1;
    }

    public int getSoTimeout() {
        I2PSocketOptions opts = this._socket.getOptions();
        if (opts == null) {
            return 0;
        }
        return (int)opts.getReadTimeout();
    }

    public boolean getTcpNoDelay() {
        return false;
    }

    public int getTrafficClass() {
        return 0;
    }

    public boolean isBound() {
        return true;
    }

    public boolean isClosed() {
        return this._socket.isClosed();
    }

    public boolean isConnected() {
        return !this._socket.isClosed();
    }

    public boolean isInputShutdown() {
        return this._socket.isClosed();
    }

    public boolean isOutputShutdown() {
        return this._socket.isClosed();
    }

    public void sendUrgentData(int data) {
        throw new UnsupportedOperationException();
    }

    public void setKeepAlive(boolean on) {
        ConnectionOptions opts = (ConnectionOptions)this._socket.getOptions();
        if (opts == null) {
            return;
        }
        if (on) {
            opts.setInactivityAction(2);
        } else {
            opts.setInactivityAction(0);
        }
    }

    public void setOOBInline(boolean on) {
        if (on) {
            throw new UnsupportedOperationException();
        }
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }

    public void setReceiveBufferSize(int size) {
    }

    public void setReuseAddress(boolean on) {
    }

    public void setSendBufferSize(int size) {
    }

    public void setSoLinger(boolean on, int linger) {
    }

    public void setSoTimeout(int timeout) throws SocketException {
        I2PSocketOptions opts = this._socket.getOptions();
        if (opts == null) {
            throw new SocketException("No options");
        }
        opts.setReadTimeout((long)timeout);
    }

    public void setTcpNoDelay(boolean on) {
    }

    public void setTrafficClass(int tc) {
    }

    public void shutdownInput() throws IOException {
        this.close();
    }

    public void shutdownOutput() throws IOException {
        this.close();
    }

    public String toString() {
        return this._socket.toString();
    }
}

