/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.streaming.Connection;
import net.i2p.client.streaming.ConnectionManager;
import net.i2p.client.streaming.PacketLocal;
import net.i2p.data.ByteArray;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;

class PacketQueue {
    private final I2PAppContext _context;
    private final Log _log;
    private final I2PSession _session;
    private final ConnectionManager _connectionManager;
    private final ByteCache _cache = ByteCache.getInstance((int)64, (int)36864);

    public PacketQueue(I2PAppContext context, I2PSession session, ConnectionManager mgr) {
        this._context = context;
        this._session = session;
        this._connectionManager = mgr;
        this._log = context.logManager().getLog(PacketQueue.class);
        this._context.statManager().createRateStat("stream.con.sendMessageSize", "Size of a message sent on a connection", "Stream", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("stream.con.sendDuplicateSize", "Size of a message resent on a connection", "Stream", new long[]{60000L, 600000L, 3600000L});
    }

    public void enqueue(PacketLocal packet) {
        boolean sent;
        long end;
        long begin;
        ByteArray ba;
        String conStr;
        block23: {
            packet.prepare();
            conStr = null;
            if (this._log.shouldLog(10)) {
                String string = conStr = packet.getConnection() != null ? packet.getConnection().toString() : "";
            }
            if (packet.getAckTime() > 0) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Not resending " + packet);
                }
                return;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Sending... " + packet);
            }
            ba = this._cache.acquire();
            byte[] buf = ba.getData();
            begin = 0L;
            end = 0L;
            sent = false;
            try {
                Connection con;
                int size = 0;
                long beforeWrite = System.currentTimeMillis();
                size = packet.shouldSign() ? packet.writeSignedPacket(buf, 0, this._context, this._session.getPrivateKey()) : packet.writePacket(buf, 0);
                long writeTime = System.currentTimeMillis() - beforeWrite;
                if (writeTime > 1000L && this._log.shouldLog(30)) {
                    this._log.warn("took " + writeTime + "ms to write the packet: " + packet);
                }
                if (packet.getAckTime() > 0) {
                    return;
                }
                begin = this._context.clock().now();
                long expires = 0L;
                Connection.ResendPacketEvent rpe = (Connection.ResendPacketEvent)packet.getResendEvent();
                if (rpe != null) {
                    expires = rpe.getNextSendTime() - 500L;
                }
                sent = expires > 0L ? this._session.sendMessage(packet.getTo(), buf, 0, size, null, null, expires, 6, packet.getLocalPort(), packet.getRemotePort()) : this._session.sendMessage(packet.getTo(), buf, 0, size, null, null, 6, packet.getLocalPort(), packet.getRemotePort());
                end = this._context.clock().now();
                if (end - begin > 1000L && this._log.shouldLog(30)) {
                    this._log.warn("Took " + (end - begin) + "ms to sendMessage(...) " + packet);
                }
                this._context.statManager().addRateData("stream.con.sendMessageSize", (long)size, packet.getLifetime());
                if (packet.getNumSends() > 1) {
                    this._context.statManager().addRateData("stream.con.sendDuplicateSize", (long)size, packet.getLifetime());
                }
                if ((con = packet.getConnection()) != null) {
                    con.incrementBytesSent(size);
                    if (packet.getNumSends() > 1) {
                        con.incrementDupMessagesSent(1);
                    }
                }
            }
            catch (I2PSessionException ise) {
                if (!this._log.shouldLog(30)) break block23;
                this._log.warn("Unable to send the packet " + packet, (Throwable)ise);
            }
        }
        this._cache.release(ba);
        if (!sent) {
            Connection c;
            if (this._log.shouldLog(30)) {
                this._log.warn("Send failed for " + packet);
            }
            if ((c = packet.getConnection()) != null) {
                c.disconnect(false);
            }
        } else {
            Connection c;
            packet.incrementSends();
            if (this._log.shouldLog(10)) {
                String msg = "SEND " + packet + " send # " + packet.getNumSends() + " sendTime: " + (end - begin) + " con: " + conStr;
                this._log.debug(msg);
            }
            String suffix = (c = packet.getConnection()) != null ? "wsize " + c.getOptions().getWindowSize() + " rto " + c.getOptions().getRTO() : null;
            this._connectionManager.getPacketHandler().displayPacket(packet, "SEND", suffix);
        }
        if (packet.getSequenceNum() == 0L && !packet.isFlagSet(1)) {
            packet.releasePayload();
        } else if (packet.isFlagSet(512) && !packet.isFlagSet(8)) {
            packet.releasePayload();
        } else if (packet.isFlagSet(4)) {
            packet.releasePayload();
        }
    }
}

