/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.ObjectContainer;
import com.db4o.foundation.BitMap4;
import com.db4o.foundation.IntByRef;
import com.db4o.internal.ArrayType;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Class;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.Handlers4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.MarshallingBuffer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.Transaction;
import com.db4o.internal.activation.UpdateDepth;
import com.db4o.internal.marshall.MarshallingContextState;
import com.db4o.internal.marshall.MarshallingInfo;
import com.db4o.internal.marshall.SlotFormat;
import com.db4o.internal.slots.Pointer4;
import com.db4o.internal.slots.Slot;
import com.db4o.marshall.ReadBuffer;
import com.db4o.marshall.ReservedBuffer;
import com.db4o.marshall.WriteContext;
import com.db4o.typehandlers.TypeHandler4;

public class MarshallingContext
implements MarshallingInfo,
WriteContext {
    private static final int HEADER_LENGTH = 9;
    private final Transaction _transaction;
    private final ObjectReference _reference;
    private UpdateDepth _updateDepth;
    private final boolean _isNew;
    private final BitMap4 _nullBitMap;
    private final MarshallingBuffer _writeBuffer;
    private MarshallingBuffer _currentBuffer;
    private ByteArrayBuffer _debugPrepend;
    private Object _currentMarshalledObject;
    private Object _currentIndexEntry;
    private int _declaredAspectCount;

    public MarshallingContext(Transaction trans, ObjectReference ref, UpdateDepth updateDepth, boolean isNew) {
        this._transaction = trans;
        this._reference = ref;
        this._nullBitMap = new BitMap4(this.aspectCount());
        this._updateDepth = this.classMetadata().adjustUpdateDepth(trans, updateDepth);
        this._isNew = isNew;
        this._currentBuffer = this._writeBuffer = new MarshallingBuffer();
    }

    private int aspectCount() {
        return this.classMetadata().aspectCount();
    }

    public ClassMetadata classMetadata() {
        return this._reference.classMetadata();
    }

    public boolean isNew() {
        return this._isNew;
    }

    public boolean isNull(int fieldIndex) {
        return false;
    }

    public void isNull(int fieldIndex, boolean flag) {
        this._nullBitMap.set(fieldIndex, flag);
    }

    public Transaction transaction() {
        return this._transaction;
    }

    public Slot allocateNewSlot(int length) {
        if (this._transaction instanceof LocalTransaction) {
            return this.localContainer().allocateSlotForNewUserObject(this._transaction, this.objectID(), length);
        }
        return new Slot(-1, length);
    }

    private Slot allocateUpdateSlot(int length) {
        if (this._transaction instanceof LocalTransaction) {
            return this.localContainer().allocateSlotForUserObjectUpdate(this.transaction(), this.objectID(), length);
        }
        return new Slot(-2, length);
    }

    private LocalObjectContainer localContainer() {
        return ((LocalTransaction)this.transaction()).localContainer();
    }

    public Pointer4 allocateSlot() {
        int length = this.container().blockConverter().blockAlignedBytes(this.marshalledLength());
        Slot slot = this.isNew() ? this.allocateNewSlot(length) : this.allocateUpdateSlot(length);
        return new Pointer4(this.objectID(), slot);
    }

    public ByteArrayBuffer toWriteBuffer(Pointer4 pointer) {
        ByteArrayBuffer buffer = new ByteArrayBuffer(pointer.length());
        this._writeBuffer.mergeChildren(this, pointer.address(), this.writeBufferOffset());
        this.writeObjectClassID(buffer, this.classMetadata().getID());
        buffer.writeByte((byte)10);
        buffer.writeInt(this.aspectCount());
        buffer.writeBitMap(this._nullBitMap);
        this._writeBuffer.transferContentTo(buffer);
        return buffer;
    }

    private int writeBufferOffset() {
        return 9 + this._nullBitMap.marshalledLength();
    }

    public int marshalledLength() {
        int length = this.writeBufferOffset();
        this._writeBuffer.checkBlockAlignment(this, null, new IntByRef(length));
        return length + this._writeBuffer.marshalledLength() + 0;
    }

    public int requiredLength(MarshallingBuffer buffer, boolean align) {
        if (!align) {
            return buffer.length();
        }
        return this.container().blockConverter().blockAlignedBytes(buffer.length());
    }

    private void writeObjectClassID(ByteArrayBuffer reader, int id) {
        reader.writeInt(-id);
    }

    public Object getObject() {
        return this._reference.getObject();
    }

    public Config4Class classConfiguration() {
        return this.classMetadata().config();
    }

    public UpdateDepth updateDepth() {
        return this._updateDepth;
    }

    public void updateDepth(UpdateDepth depth) {
        this._updateDepth = depth;
    }

    public int objectID() {
        return this._reference.getID();
    }

    public Object currentIndexEntry() {
        return null;
    }

    public ObjectContainerBase container() {
        return this.transaction().container();
    }

    public ObjectContainer objectContainer() {
        return this.transaction().objectContainer();
    }

    public void writeByte(byte b) {
        this.preWrite();
        this._currentBuffer.writeByte(b);
        this.postWrite();
    }

    public void writeBytes(byte[] bytes) {
        this.preWrite();
        this._currentBuffer.writeBytes(bytes);
        this.postWrite();
    }

    public void writeInt(int i) {
        this.preWrite();
        this._currentBuffer.writeInt(i);
        this.postWrite();
    }

    public void writeLong(long l) {
        this.preWrite();
        this._currentBuffer.writeLong(l);
        this.postWrite();
    }

    private void preWrite() {
    }

    private void postWrite() {
    }

    public void createChildBuffer(boolean storeLengthInLink) {
        MarshallingBuffer childBuffer = this._currentBuffer.addChild(false, storeLengthInLink);
        this._currentBuffer.reserveChildLinkSpace(storeLengthInLink);
        this._currentBuffer = childBuffer;
    }

    public void beginSlot() {
        this._currentBuffer = this._writeBuffer;
    }

    public void writeDeclaredAspectCount(int count) {
        this._writeBuffer.writeInt(count);
    }

    public void debugPrependNextWrite(ByteArrayBuffer prepend) {
    }

    public void debugWriteEnd(byte b) {
        this._currentBuffer.writeByte(b);
    }

    public void writeObject(Object obj) {
        int id = this.container().storeInternal(this.transaction(), obj, this._updateDepth, true);
        this.writeInt(id);
        this._currentMarshalledObject = obj;
        this._currentIndexEntry = new Integer(id);
    }

    public void writeObject(TypeHandler4 handler, Object obj) {
        MarshallingContextState state = this.currentState();
        this.writeObjectWithCurrentState(handler, obj);
        this.restoreState(state);
    }

    public void writeObjectWithCurrentState(TypeHandler4 handler, Object obj) {
        if (Handlers4.useDedicatedSlot(this, handler)) {
            this.writeObject(obj);
        } else if (obj == null) {
            this.writeNullReference(handler);
        } else {
            this.createIndirectionWithinSlot(handler);
            handler.write(this, obj);
        }
    }

    private void writeNullReference(TypeHandler4 handler) {
        if (this.isIndirectedWithinSlot(handler)) {
            this.writeNullLink();
            return;
        }
        Handlers4.write(handler, this, Handlers4.nullRepresentationInUntypedArrays(handler));
    }

    private void writeNullLink() {
        this.writeInt(0);
        this.writeInt(0);
    }

    public void addIndexEntry(FieldMetadata fieldMetadata, Object obj) {
        if (!this._currentBuffer.hasParent()) {
            Object indexEntry;
            Object object = indexEntry = obj == this._currentMarshalledObject ? this._currentIndexEntry : obj;
            if (this._isNew || !this.updateDepth().canSkip(this._reference)) {
                fieldMetadata.addIndexEntry(this.transaction(), this.objectID(), indexEntry);
            }
            return;
        }
        this._currentBuffer.requestIndexEntry(fieldMetadata);
    }

    public void purgeFieldIndexEntriesOnUpdate(Transaction transaction, ArrayType arrayType) {
        if (!this.updateDepth().canSkip(this._reference)) {
            transaction.writeUpdateAdjustIndexes(this._reference.getID(), this._reference.classMetadata(), arrayType);
        }
    }

    public ObjectReference reference() {
        return this._reference;
    }

    public void createIndirectionWithinSlot(TypeHandler4 handler) {
        if (this.isIndirectedWithinSlot(handler)) {
            this.createIndirectionWithinSlot();
        }
    }

    public void createIndirectionWithinSlot() {
        this.createChildBuffer(true);
    }

    private boolean isIndirectedWithinSlot(TypeHandler4 handler) {
        return SlotFormat.current().isIndirectedWithinSlot(handler);
    }

    public ReadBuffer buffer() {
        return null;
    }

    public MarshallingContextState currentState() {
        return new MarshallingContextState(this._currentBuffer);
    }

    public void restoreState(MarshallingContextState state) {
        this._currentBuffer = state._buffer;
    }

    public ReservedBuffer reserve(int length) {
        this.preWrite();
        ReservedBuffer reservedBuffer = this._currentBuffer.reserve(length);
        this.postWrite();
        return reservedBuffer;
    }

    public int declaredAspectCount() {
        return this._declaredAspectCount;
    }

    public void declaredAspectCount(int count) {
        this._declaredAspectCount = count;
    }
}

