/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.BlockingQueue4;
import com.db4o.foundation.BlockingQueueStoppedException;
import com.db4o.foundation.Closure4;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Lock4;
import com.db4o.foundation.NonblockingQueue;
import com.db4o.foundation.Predicate4;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingQueue<T>
implements BlockingQueue4<T> {
    protected NonblockingQueue<T> _queue = new NonblockingQueue();
    protected Lock4 _lock = new Lock4();
    protected boolean _stopped;

    @Override
    public void add(final T obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        this._lock.run(new Closure4<Void>(){

            @Override
            public Void run() {
                BlockingQueue.this._queue.add(obj);
                BlockingQueue.this._lock.awake();
                return null;
            }
        });
    }

    @Override
    public boolean hasNext() {
        return this._lock.run(new Closure4<Boolean>(){

            @Override
            public Boolean run() {
                return BlockingQueue.this._queue.hasNext();
            }
        });
    }

    @Override
    public Iterator4<T> iterator() {
        return (Iterator4)this._lock.run(new Closure4<Iterator4<T>>(){

            @Override
            public Iterator4<T> run() {
                return BlockingQueue.this._queue.iterator();
            }
        });
    }

    @Override
    public T next(final long timeout) throws BlockingQueueStoppedException {
        return this._lock.run(new Closure4<T>(){

            @Override
            public T run() {
                return BlockingQueue.this.unsafeWaitForNext(timeout) ? BlockingQueue.this.unsafeNext() : null;
            }
        });
    }

    @Override
    public int drainTo(final Collection4<T> target) {
        return this._lock.run(new Closure4<Integer>(){

            @Override
            public Integer run() {
                BlockingQueue.this.unsafeWaitForNext();
                int i = 0;
                while (BlockingQueue.this.hasNext()) {
                    ++i;
                    target.add(BlockingQueue.this.unsafeNext());
                }
                return i;
            }
        });
    }

    public boolean waitForNext(final long timeout) throws BlockingQueueStoppedException {
        return this._lock.run(new Closure4<Boolean>(){

            @Override
            public Boolean run() {
                return BlockingQueue.this.unsafeWaitForNext(timeout);
            }
        });
    }

    @Override
    public T next() throws BlockingQueueStoppedException {
        return this._lock.run(new Closure4<T>(){

            @Override
            public T run() {
                BlockingQueue.this.unsafeWaitForNext();
                return BlockingQueue.this.unsafeNext();
            }
        });
    }

    @Override
    public void stop() {
        this._lock.run(new Closure4<Void>(){

            @Override
            public Void run() {
                BlockingQueue.this._stopped = true;
                BlockingQueue.this._lock.awake();
                return null;
            }
        });
    }

    @Override
    public T nextMatching(final Predicate4<T> condition) {
        return this._lock.run(new Closure4<T>(){

            @Override
            public T run() {
                return BlockingQueue.this._queue.nextMatching(condition);
            }
        });
    }

    public void waitForNext() throws BlockingQueueStoppedException {
        this._lock.run(new Closure4<Boolean>(){

            @Override
            public Boolean run() {
                BlockingQueue.this.unsafeWaitForNext();
                return null;
            }
        });
    }

    protected void unsafeWaitForNext() throws BlockingQueueStoppedException {
        this.unsafeWaitForNext(Long.MAX_VALUE);
    }

    protected boolean unsafeWaitForNext(long timeout) throws BlockingQueueStoppedException {
        long l;
        long now = System.currentTimeMillis();
        for (long timeLeft = timeout; timeLeft > 0L; timeLeft -= now - l) {
            if (this._queue.hasNext()) {
                return true;
            }
            if (this._stopped) {
                throw new BlockingQueueStoppedException();
            }
            this._lock.snooze(timeLeft);
            l = now;
            now = System.currentTimeMillis();
        }
        return false;
    }

    private T unsafeNext() {
        return this._queue.next();
    }
}

