/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.diagnostic;

import com.db4o.diagnostic.DiagnosticBase;

public class UpdateDepthGreaterOne
extends DiagnosticBase {
    private final int _depth;

    public UpdateDepthGreaterOne(int depth) {
        this._depth = depth;
    }

    public Object reason() {
        return "configuration.common().configure().updateDepth(" + this._depth + ")";
    }

    public String problem() {
        return "A global update depth greater than 1 is not recommended";
    }

    public String solution() {
        return "Increasing the global update depth to a value greater than 1 is only recommended for testing, not for production use. If individual deep updates are needed, consider using ExtObjectContainer#set(object, depth) and make sure to profile the performance of each call.";
    }
}

