/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.utilities;

import org.ourfilesystem.db.FileReference;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.db.Post;
import org.ourfilesystem.security.PublicKeySetSigned;
import org.ourfilesystem.security.SignedDigest;

public class Cloning {
    public static SignedDigest cloneSignedDigest(SignedDigest sg) {
        if (sg != null) {
            SignedDigest nsg = new SignedDigest();
            nsg.setDigest(sg.getDigest());
            nsg.setPeerIdentifier(sg.getPeerIdentifier());
            nsg.setSignature(sg.getSignature());
            return nsg;
        }
        return null;
    }

    public static PublicKeySetSigned clonePublicKeySetSigned(PublicKeySetSigned p) {
        if (p != null) {
            PublicKeySetSigned np = new PublicKeySetSigned();
            np.setPublicEncryptionKey(p.getPublicEncryptionKey());
            np.setPublicSigningKey(p.getPublicSigningKey());
            np.setSignature(Cloning.cloneSignedDigest(p.getSignature()));
            return np;
        }
        return null;
    }

    public static Peer clonePeer(Peer p) {
        if (p != null) {
            Peer np = new Peer();
            np.setLocation(p.getLocation());
            np.setNickname(p.getNickname());
            np.setIntroduction(p.getIntroduction());
            np.setUpdateCount(p.getUpdateCount());
            np.setPeerKeysAndIdentity(Cloning.clonePublicKeySetSigned(p.getPeerKeysAndIdentity()));
            np.setLocationSignature(Cloning.cloneSignedDigest(p.getLocationSignature()));
            return np;
        }
        return null;
    }

    public static FileReference cloneFileReference(FileReference fr) {
        if (fr != null) {
            FileReference n = new FileReference();
            n.setUnsignedDigest(fr.getUnsignedDigest());
            return n;
        }
        return null;
    }

    public static Post clonePost(Post p) {
        if (p != null) {
            Post np = new Post();
            np.setFileReferenceDigest(p.getFileReferenceDigest());
            np.setMessage(p.getMessage());
            np.setPosterHasFile(p.isPosterHasFile());
            np.setPostNumber(p.getPostNumber());
            np.setSignedDigest(Cloning.cloneSignedDigest(p.getSignedDigest()));
            return np;
        }
        return null;
    }
}

