/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.test.security;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.db.Post;
import org.ourfilesystem.security.CryptoDataBaseImpl;
import org.ourfilesystem.security.KeySet;
import org.ourfilesystem.security.PublicKeySetSigned;

public class CryptoDataBaseImplTest {
    private File createRandomFile(long size) {
        try {
            Random r = new Random();
            byte[] b = new byte[1024];
            File f = File.createTempFile("random", "tmp");
            FileOutputStream fos = new FileOutputStream(f);
            int cnt = 0;
            while ((long)cnt < size / 1024L) {
                r.nextBytes(b);
                fos.write(b);
                ++cnt;
            }
            fos.close();
            return f;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Test
    public void test() {
        CryptoDataBaseImpl c = new CryptoDataBaseImpl();
        KeySet keyset0 = c.generateNewKeys();
        KeySet keyset1 = c.generateNewKeys();
        PublicKeySetSigned pub0 = new PublicKeySetSigned();
        PublicKeySetSigned pub1 = new PublicKeySetSigned();
        pub0.setPublicEncryptionKey(keyset0.getPublicKeySet().getPublicEncryptionKey());
        pub0.setPublicSigningKey(keyset0.getPublicKeySet().getPublicSigningKey());
        pub1.setPublicEncryptionKey(keyset1.getPublicKeySet().getPublicEncryptionKey());
        pub1.setPublicSigningKey(keyset1.getPublicKeySet().getPublicSigningKey());
        Peer p0 = new Peer();
        p0.setLocation("bbasdrfrewr.blah");
        p0.setPeerKeysAndIdentity(pub0);
        p0.setUpdateCount(0L);
        Peer p1 = new Peer();
        p1.setLocation("bbas2341ewr.blah");
        p1.setPeerKeysAndIdentity(pub1);
        p1.setUpdateCount(1L);
        c.signPeer(p0, null, keyset1.getPrivateSigningKey());
        Assert.assertTrue((boolean)c.verifyPeer(p0.getPeerKeysAndIdentity(), keyset1.getPublicKeySet().getPublicSigningKey()));
        Assert.assertFalse((boolean)c.verifyPeer(p0.getPeerKeysAndIdentity(), keyset0.getPublicKeySet().getPublicSigningKey()));
        File tf0 = this.createRandomFile(4096L);
        File tf1 = this.createRandomFile(4096L);
        Object dig0 = c.digestFile(tf0);
        Object dig1 = c.digestFile(tf1);
        Object dig2 = c.digestFile(tf0);
        Assert.assertFalse((boolean)c.digEquals(dig0, dig1));
        Assert.assertTrue((boolean)c.digEquals(dig0, dig2));
        Post s0 = new Post();
        s0.setFileReferenceDigest(dig0);
        s0.setMessage(tf1);
        s0.setPosterHasFile(true);
        s0.setPostNumber(1L);
        c.signPost(s0, p0.getPeerKeysAndIdentity().getSignature().getDigest(), keyset0.getPrivateSigningKey());
        s0.setPosterHasFile(false);
        Assert.assertFalse((boolean)c.verifyPost(s0, p0.getPeerKeysAndIdentity().getPublicSigningKey()));
        s0.setPosterHasFile(true);
        s0.setFileReferenceDigest(dig1);
        Assert.assertFalse((boolean)c.verifyPost(s0, p0.getPeerKeysAndIdentity().getPublicSigningKey()));
        s0.setFileReferenceDigest(dig0);
        s0.setMessage(tf0);
        Assert.assertFalse((boolean)c.verifyPost(s0, p0.getPeerKeysAndIdentity().getPublicSigningKey()));
        s0.setMessage(tf1);
        s0.setPostNumber(2L);
        Assert.assertFalse((boolean)c.verifyPost(s0, p0.getPeerKeysAndIdentity().getPublicSigningKey()));
        s0.setPostNumber(1L);
        Assert.assertTrue((boolean)c.verifyPost(s0, p0.getPeerKeysAndIdentity().getPublicSigningKey()));
        Assert.assertFalse((boolean)c.verifyPost(s0, p1.getPeerKeysAndIdentity().getPublicSigningKey()));
    }
}

