/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.test.postcodec;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.ourfilesystem.db.LocalPost;
import org.ourfilesystem.db.Post;
import org.ourfilesystem.postcodec.Codec;
import org.ourfilesystem.postcodec.PostDecoded;
import org.ourfilesystem.utilities.BBytes;

public class CodecTest {
    public static boolean mapEquals(HashMap o0, HashMap o1) {
        if (o0.size() != o1.size()) {
            return false;
        }
        for (Map.Entry e : o0.entrySet()) {
            Object v1 = o1.get(e.getKey());
            if (!(v1 == null ? e.getValue() != null : !v1.equals(e.getValue()))) continue;
            return false;
        }
        return true;
    }

    public static boolean setEquals(Set s0, Set s1) {
        if (s0.size() != s1.size()) {
            return false;
        }
        return s0.containsAll(s1);
    }

    public static boolean stringMapEquals(Map m0, Map m1) {
        if (m0.size() != m1.size()) {
            return false;
        }
        for (Map.Entry e : m0.entrySet()) {
            if (CodecTest.setEquals((Set)e.getValue(), (Set)m1.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Test
    public void test() {
        Random r = new Random();
        Post p0 = new Post();
        LocalPost lp0 = new LocalPost();
        p0.setMessage(new File("testfile.dat"));
        lp0.setPost(p0);
        PostDecoded pd0 = new PostDecoded();
        pd0.setPost(lp0);
        pd0.setComment("This is a really cool comment.  Like, you're not even going to believe it.");
        pd0.getNumberValues().put("COOL_LEVEL", 213L);
        pd0.getNumberValues().put("AWESOME_NUM", 759L);
        pd0.pushStringValue("KEYWORD", "MAGICMAN");
        pd0.pushStringValue("KEYWORD", "WOW");
        pd0.pushStringValue("SOMETHINGELSE", "THERE");
        byte[] b0 = new byte[1024];
        r.nextBytes(b0);
        BBytes bb0 = new BBytes(b0);
        pd0.pushReferenceValue("SOMEOTHERFILE", bb0);
        try {
            Codec.ecnode(pd0);
            PostDecoded pd1 = Codec.decode(pd0.getPost());
            Assert.assertTrue((boolean)CodecTest.stringMapEquals(pd0.getOtherReferences(), pd1.getOtherReferences()));
            Assert.assertTrue((boolean)CodecTest.mapEquals(pd0.getNumberValues(), pd1.getNumberValues()));
            Assert.assertTrue((boolean)CodecTest.stringMapEquals(pd0.getStringValues(), pd1.getStringValues()));
            Assert.assertEquals((Object)pd0.getComment(), (Object)pd1.getComment());
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

