/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.simpleui;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.ourfilesystem.db.LocalPost;
import org.ourfilesystem.utilities.FileUtils;

public class PostTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private HashSet<PostRow> Rows;
    private HashMap<PostRow, LocalPost> Posts;
    private String[] columns = new String[]{"Peer", "Date", "Number", "Subject", "File Ref"};

    public PostTableModel() {
        this.Rows = new HashSet();
        this.Posts = new HashMap();
    }

    public void addAllPosts(List<LocalPost> pl) {
        this.Rows.clear();
        for (LocalPost l : pl) {
            this.addPost(l);
        }
    }

    public void addPost(LocalPost lp) {
        PostRow pr = new PostRow();
        pr.Peer = lp.getPost().getSignedDigest().getPeerIdentifier().toString().substring(0, 10);
        pr.Date = lp.getLocalDate();
        pr.Number = lp.getPost().getPostNumber();
        if (lp.getPost().getFileReferenceDigest() != null) {
            pr.FileRef = lp.getPost().getFileReferenceDigest().toString().substring(0, 10);
        }
        File mf = (File)lp.getPost().getMessage();
        try {
            FileInputStream fis = new FileInputStream(mf);
            pr.Subject = FileUtils.readString(fis);
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.Rows.add(pr);
        this.Posts.put(pr, lp);
        this.fireTableDataChanged();
    }

    private PostRow getPostRow(int row) {
        PostRow r = null;
        Iterator<PostRow> i = this.Rows.iterator();
        int cnt = 0;
        while (i.hasNext() && cnt <= row) {
            r = i.next();
            ++cnt;
        }
        return r;
    }

    public LocalPost getPost(int row) {
        return this.Posts.get(this.getPostRow(row));
    }

    @Override
    public String getColumnName(int col) {
        return this.columns[col];
    }

    public Class getColumnClass(int col) {
        if (col == 0 || col == 3 || col == 4) {
            return String.class;
        }
        if (col == 1) {
            return Date.class;
        }
        if (col == 2) {
            return Long.class;
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.Rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        PostRow r = this.getPostRow(rowIndex);
        if (r != null) {
            if (columnIndex == 0) {
                return r.Peer;
            }
            if (columnIndex == 1) {
                return r.Date;
            }
            if (columnIndex == 2) {
                return r.Number;
            }
            if (columnIndex == 3) {
                return r.Subject;
            }
            if (columnIndex == 4) {
                return r.FileRef;
            }
        }
        return null;
    }

    class PostRow {
        public String Peer;
        public Date Date;
        public long Number;
        public String Subject;
        public String FileRef;

        PostRow() {
        }

        public int hashCode() {
            return this.Peer.hashCode() ^ Long.valueOf(this.Number).hashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof PostRow)) {
                return false;
            }
            PostRow pr = (PostRow)o;
            return pr.Peer.equals(this.Peer) && pr.Number == this.Number;
        }
    }
}

