/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.simpleui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.core.Core;
import org.ourfilesystem.db.LocalPost;
import org.ourfilesystem.utilities.FileUtils;

public class PostDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private JTextField textField;
    private JTextPane textPane;
    private JLabel lblDate;
    private JLabel lblFrom;
    private JLabel lblAttachedFile;
    private LocalPost Post;
    private Core Core;

    public void setPost(LocalPost post) {
        this.Post = post;
        if (this.Post != null) {
            DateFormat df = DateFormat.getDateInstance(2, Locale.getDefault());
            this.lblDate.setText(df.format(this.Post.getLocalDate()));
            this.lblFrom.setText(this.Post.getPost().getSignedDigest().getPeerIdentifier().toString().substring(0, 10));
            if (this.Post.getPost().getFileReferenceDigest() != null) {
                this.lblAttachedFile.setText(this.Post.getPost().getFileReferenceDigest().toString().substring(0, 10));
            } else {
                this.lblAttachedFile.setText("No file.");
            }
            this.readFile();
        }
    }

    private void readFile() {
        if (this.Post != null) {
            File f = (File)this.Post.getPost().getMessage();
            if (f != null) {
                try {
                    FileInputStream fis = new FileInputStream(f);
                    String subject = FileUtils.readString(fis);
                    String body = FileUtils.readString(fis);
                    this.textField.setText(subject);
                    this.textPane.setText(body);
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.textField.setText("Empty");
                this.textPane.setText("Empty");
            }
        }
    }

    public PostDialog(Core core) {
        this.Core = core;
        this.setDefaultCloseOperation(1);
        this.setBounds(100, 100, 450, 300);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][][][][][grow]"));
        JLabel lblSubject = new JLabel("Subject");
        this.contentPanel.add((Component)lblSubject, "cell 0 0,alignx left");
        this.textField = new JTextField();
        this.textField.setEditable(false);
        this.contentPanel.add((Component)this.textField, "cell 0 1,growx");
        this.textField.setColumns(10);
        this.lblDate = new JLabel("Date");
        this.contentPanel.add((Component)this.lblDate, "cell 0 2");
        this.lblFrom = new JLabel("From");
        this.contentPanel.add((Component)this.lblFrom, "cell 0 3");
        JButton btnDownloadFile = new JButton("Download File");
        this.contentPanel.add((Component)btnDownloadFile, "flowx,cell 0 4");
        btnDownloadFile.setActionCommand("DOWNLOAD");
        btnDownloadFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("DOWNLOAD") && PostDialog.this.Post.getPost().getFileReferenceDigest() != null) {
                    PostDialog.this.Core.downloadFile(PostDialog.this.Post.getPost().getFileReferenceDigest());
                }
            }
        });
        this.lblAttachedFile = new JLabel("No file attached");
        this.contentPanel.add((Component)this.lblAttachedFile, "cell 0 4");
        JScrollPane scrollPane = new JScrollPane();
        this.contentPanel.add((Component)scrollPane, "cell 0 5,grow");
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        scrollPane.setViewportView(this.textPane);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("OK");
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PostDialog.this.setVisible(false);
            }
        });
    }
}

