/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.simpleui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;
import org.ourfilesystem.com.ConnectionUpdateInterface;
import org.ourfilesystem.db.Peer;

public class ConnectionsTable
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columns = new String[]{"Peer", "Location", "Introduction", "Pending", "Signed by"};
    private HashSet<Peer> Connections = new HashSet();
    private HashMap<Peer, ConnectionUpdateInterface> ConMap = new HashMap();

    public synchronized void connectionUpdate(ConnectionUpdateInterface c) {
        this.Connections.add(c.getPeer());
        this.ConMap.put(c.getPeer(), c);
        this.fireTableDataChanged();
    }

    public synchronized void removeConnection(Peer p) {
        this.Connections.remove(p);
        this.ConMap.remove(p);
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int col) {
        return this.columns[col];
    }

    public Class getColumnClass(int col) {
        if (col == 3) {
            return Integer.class;
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public synchronized int getRowCount() {
        return this.Connections.size();
    }

    @Override
    public synchronized Object getValueAt(int row, int col) {
        Iterator<Peer> i = this.Connections.iterator();
        Peer up = null;
        int cnt = 0;
        while (i.hasNext() && cnt <= row) {
            up = i.next();
            ++cnt;
        }
        if (up != null) {
            if (col == 0) {
                return up.getNickSig();
            }
            if (col == 1) {
                return up.getLocation();
            }
            if (col == 2) {
                return up.getIntroduction();
            }
            if (col == 3) {
                ConnectionUpdateInterface c = this.ConMap.get(up);
                if (c != null) {
                    return c.getPendingRequests();
                }
                return null;
            }
            if (col == 4) {
                return up.getPeerKeysAndIdentity().getSignature().getPeerIdentifier().toString().substring(0, 10);
            }
        }
        return null;
    }
}

