/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.db;

import com.db4o.Db4oEmbedded;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.config.EmbeddedConfiguration;
import com.db4o.query.Predicate;
import com.db4o.query.Query;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ourfilesystem.db.LocalFileReference;
import org.ourfilesystem.db.LocalPost;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.db.Post;
import org.ourfilesystem.db.PostHoles;
import org.ourfilesystem.db.StorageInterface;
import org.ourfilesystem.security.KeySet;
import org.ourfilesystem.security.SignedDigest;
import org.ourfilesystem.utilities.BBytes;
import org.ourfilesystem.utilities.FileUtils;

public class StorageImpl2
implements StorageInterface {
    public static long MAXPOSTSIZE = 10240L;
    public static long MAXFILESIZE = 0x300000L;
    private File BaseDir;
    private ObjectContainer DB;

    public StorageImpl2(String basedir) {
        this.BaseDir = new File(basedir);
        if (!this.BaseDir.exists()) {
            this.BaseDir.mkdirs();
        } else if (!this.BaseDir.isDirectory()) {
            throw new RuntimeException("Expecting a directory: " + basedir);
        }
        String file = String.valueOf(basedir) + File.separator + "mainstore.dat";
        EmbeddedConfiguration db4oconfig = Db4oEmbedded.newConfiguration();
        db4oconfig.common().activationDepth(10);
        db4oconfig.common().updateDepth(10);
        db4oconfig.common().objectClass(MyPeerData.class).cascadeOnDelete(true);
        db4oconfig.common().objectClass(MyPeerData.class).cascadeOnActivate(true);
        db4oconfig.common().objectClass(MyPeerData.class).cascadeOnUpdate(true);
        db4oconfig.common().objectClass(LocalPost.class).objectField("LocalDate").indexed(true);
        db4oconfig.common().objectClass(LocalPost.class).objectField("Post").indexed(true);
        db4oconfig.common().objectClass(Post.class).objectField("SignedDigest").indexed(true);
        db4oconfig.common().objectClass(SignedDigest.class).objectField("Digest").indexed(true);
        this.DB = Db4oEmbedded.openFile((EmbeddedConfiguration)db4oconfig, (String)file);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                StorageImpl2.this.DB.close();
            }
        });
    }

    @Override
    public synchronized void saveMyPeerData(Peer peer) {
        Query q = this.DB.query();
        q.constrain(MyPeerData.class);
        ObjectSet os = q.execute();
        if (os.size() > 1) {
            System.out.println("ERROR: There is more than one copy for some reason.");
        }
        for (MyPeerData mydat : os) {
            this.DB.delete((Object)mydat);
        }
        this.DB.commit();
        MyPeerData newpeer = new MyPeerData();
        newpeer.Peer = peer;
        this.DB.store((Object)newpeer);
        this.DB.commit();
    }

    @Override
    public synchronized Peer getMyPeerData() {
        Iterator i;
        Query q = this.DB.query();
        q.constrain(MyPeerData.class);
        ObjectSet os = q.execute();
        if (os.size() > 1) {
            System.out.println("ERROR: There is more than one copy for some reason.");
        }
        if ((i = os.iterator()).hasNext()) {
            return ((MyPeerData)i.next()).Peer;
        }
        return null;
    }

    @Override
    public synchronized void saveMyKeySet(KeySet keyset) {
        Query q = this.DB.query();
        q.constrain(KeySet.class);
        ObjectSet os = q.execute();
        if (os.size() > 1) {
            System.out.println("ERROR: There is more than one copy for some reason.");
        }
        for (KeySet mydat : os) {
            this.DB.delete((Object)mydat);
        }
        this.DB.store((Object)keyset);
        this.DB.commit();
    }

    @Override
    public synchronized KeySet getMyKeySet() {
        Iterator i;
        Query q = this.DB.query();
        q.constrain(KeySet.class);
        ObjectSet os = q.execute();
        if (os.size() > 1) {
            System.out.println("ERROR: There is more than one copy for some reason.");
        }
        if ((i = os.iterator()).hasNext()) {
            return (KeySet)i.next();
        }
        return null;
    }

    @Override
    public synchronized void savePeer(final Peer peer) {
        if (peer == null) {
            System.out.println("ERROR: Peer is null");
            return;
        }
        if (peer.getPeerKeysAndIdentity() == null) {
            System.out.println("ERROR: Identity does not exist.");
            return;
        }
        if (peer.getPeerKeysAndIdentity().getSignature() == null) {
            System.out.println("ERROR: Signature does not exist.");
            return;
        }
        if (peer.getPeerKeysAndIdentity().getSignature().getDigest() == null) {
            System.out.println("ERROR: Digest does not exist.");
            return;
        }
        ObjectSet os = this.DB.query((Predicate)new Predicate<Peer>(){

            public boolean match(Peer ep) {
                return ep.getPeerKeysAndIdentity().getSignature().getDigest().equals(peer.getPeerKeysAndIdentity().getSignature().getDigest());
            }
        });
        if (os.size() > 1) {
            System.out.println("ERROR: There is more than one copy of this peer saved for some reason.");
        }
        for (Peer np : os) {
            this.DB.delete((Object)np);
        }
        this.DB.store((Object)peer);
        this.DB.commit();
    }

    @Override
    public synchronized Peer getPeer(final Object peerid) {
        Iterator i;
        ObjectSet osa = this.DB.query((Predicate)new Predicate<BadPeer>(){

            public boolean match(BadPeer ep) {
                return ep.Digest.equals(peerid);
            }
        });
        if (osa.size() > 0) {
            return null;
        }
        ObjectSet os = this.DB.query((Predicate)new Predicate<Peer>(){

            public boolean match(Peer ep) {
                return ep.getPeerKeysAndIdentity().getSignature().getDigest().equals(peerid);
            }
        });
        if (os.size() > 1) {
            System.out.println("ERROR: There is more than one copy for some reason.");
        }
        if ((i = os.iterator()).hasNext()) {
            return (Peer)i.next();
        }
        return null;
    }

    @Override
    public synchronized List<Peer> getPeerList() {
        Query q = this.DB.query();
        q.constrain(Peer.class);
        ObjectSet os = q.execute();
        q = this.DB.query();
        q.constrain(BadPeer.class);
        ObjectSet osa = q.execute();
        LinkedList<Peer> r = new LinkedList<Peer>();
        for (Peer p : os) {
            boolean found = false;
            Iterator i2 = osa.iterator();
            while (i2.hasNext() && !found) {
                BadPeer bp = (BadPeer)i2.next();
                if (!p.getPeerKeysAndIdentity().getSignature().getDigest().equals(bp.Digest)) continue;
                found = true;
            }
            if (found) continue;
            r.add(p);
        }
        return r;
    }

    @Override
    public synchronized void savePost(LocalPost post) {
        if (post == null) {
            System.out.println("ERROR: post is null.");
            return;
        }
        if (post.getPost() == null) {
            System.out.println("ERROR: post is null.");
            return;
        }
        if (post.getPost().getSignedDigest() == null) {
            System.out.println("ERROR: Signed digest is null.");
            return;
        }
        if (post.getPost().getSignedDigest().getPeerIdentifier() == null) {
            System.out.println("ERROR: Digest is null.");
            return;
        }
        boolean savemsg = true;
        File fm = (File)post.getPost().getMessage();
        if (fm != null) {
            if (fm.exists()) {
                if (fm.length() <= MAXPOSTSIZE) {
                    File ndir = this.dirFromDig((BBytes)post.getPost().getSignedDigest().getDigest(), String.valueOf(this.BaseDir.getPath()) + File.separator + "posts");
                    File nm = new File(String.valueOf(ndir.getPath()) + File.separator + "msg.dat");
                    if (!fm.renameTo(nm)) {
                        savemsg = false;
                    }
                    post.getPost().setMessage(nm);
                } else {
                    savemsg = false;
                }
                if (!savemsg) {
                    fm.delete();
                }
            } else {
                savemsg = false;
            }
        }
        if (savemsg) {
            LastPostNumber lpn = this.getLast(post.getPost().getSignedDigest().getPeerIdentifier());
            if (lpn == null) {
                lpn = new LastPostNumber();
                lpn.Digest = post.getPost().getSignedDigest().getPeerIdentifier();
            }
            if (lpn.PostNumber + 1L < post.getPost().getPostNumber()) {
                PostHoles ph = new PostHoles(lpn.PostNumber + 1L, post.getPost().getPostNumber() - 1L);
                ph.setPeerId(post.getPost().getSignedDigest().getPeerIdentifier());
                this.DB.store((Object)ph);
                this.DB.commit();
            }
            if (post.getPost().getPostNumber() > lpn.PostNumber) {
                lpn.PostNumber = post.getPost().getPostNumber();
                this.DB.store((Object)lpn);
                this.DB.commit();
            }
            this.DB.store((Object)post);
            this.DB.commit();
            List<PostHoles> phl = this.getPeerPostHoles(post.getPost().getSignedDigest().getPeerIdentifier());
            for (PostHoles ph : phl) {
                ph.newPostReceived(post.getPost().getPostNumber());
                if (ph.isDone()) {
                    this.DB.delete((Object)ph);
                } else {
                    this.DB.store((Object)ph);
                }
                this.DB.commit();
            }
        }
    }

    @Override
    public synchronized List<LocalPost> getPeerPosts(final Peer p, int page, int pagesize) {
        if (p == null) {
            return null;
        }
        if (p.getPeerKeysAndIdentity() == null) {
            return null;
        }
        if (p.getPeerKeysAndIdentity().getSignature() == null) {
            return null;
        }
        if (p.getPeerKeysAndIdentity().getSignature().getDigest() == null) {
            return null;
        }
        ObjectSet os = this.DB.query((Predicate)new Predicate<LocalPost>(){

            public boolean match(LocalPost ep) {
                return ep.getPost().getSignedDigest().getPeerIdentifier().equals(p.getPeerKeysAndIdentity().getSignature().getDigest());
            }
        });
        HashSet<LocalPost> h = new HashSet<LocalPost>();
        int idx = page * pagesize;
        while (idx < (page + 1) * pagesize && idx < os.size()) {
            h.add((LocalPost)os.get(idx));
            ++idx;
        }
        LinkedList<LocalPost> r = new LinkedList<LocalPost>();
        r.addAll(h);
        return r;
    }

    @Override
    public synchronized List<LocalPost> getPeerPosts(final Peer p, final long start, final long end) {
        if (p == null) {
            return null;
        }
        if (p.getPeerKeysAndIdentity() == null) {
            return null;
        }
        if (p.getPeerKeysAndIdentity().getSignature() == null) {
            return null;
        }
        if (p.getPeerKeysAndIdentity().getSignature().getDigest() == null) {
            return null;
        }
        ObjectSet os = this.DB.query((Predicate)new Predicate<LocalPost>(){

            public boolean match(LocalPost ep) {
                return ep.getPost().getSignedDigest().getPeerIdentifier().equals(p.getPeerKeysAndIdentity().getSignature().getDigest()) && start <= ep.getPost().getPostNumber() && ep.getPost().getPostNumber() <= end;
            }
        });
        HashSet h = new HashSet();
        h.addAll(os);
        LinkedList<LocalPost> r = new LinkedList<LocalPost>();
        r.addAll(h);
        return r;
    }

    @Override
    public synchronized List<LocalPost> getFilePosts(final Object dig, int page, int pagesize) {
        if (dig == null) {
            return null;
        }
        ObjectSet os = this.DB.query((Predicate)new Predicate<LocalPost>(){

            public boolean match(LocalPost ep) {
                Object ed = ep.getPost().getFileReferenceDigest();
                if (ed != null) {
                    return ed.equals(dig);
                }
                return false;
            }
        });
        HashSet<LocalPost> h = new HashSet<LocalPost>();
        int idx = page * pagesize;
        while (idx < os.size() && idx < (page + 1) * pagesize) {
            h.add((LocalPost)os.get(idx));
            ++idx;
        }
        LinkedList<LocalPost> r = new LinkedList<LocalPost>();
        r.addAll(h);
        return r;
    }

    @Override
    public synchronized List<LocalPost> getPosts(final Date fromdate) {
        if (fromdate == null) {
            return null;
        }
        ObjectSet os = this.DB.query((Predicate)new Predicate<LocalPost>(){

            public boolean match(LocalPost ep) {
                Date td = ep.getLocalDate();
                if (td != null) {
                    return fromdate.compareTo(td) <= 0;
                }
                return false;
            }
        });
        HashSet h = new HashSet();
        h.addAll(os);
        LinkedList<LocalPost> r = new LinkedList<LocalPost>();
        r.addAll(h);
        return r;
    }

    private File dirFromDig(BBytes b, String basedir) {
        byte[] bt = b.getBytes();
        ByteBuffer buf = ByteBuffer.wrap(bt);
        int d0n = buf.getInt() & 0x3FFF;
        int d1n = 0;
        if (buf.remaining() >= 4) {
            d1n = buf.getInt() & 0x3FFF;
        }
        int d2n = 0;
        if (buf.remaining() >= 4) {
            d2n = buf.getInt() & 0x3FFF;
        }
        int val = 0;
        File d = new File(String.valueOf(basedir) + File.separator + d0n + File.separator + d1n + File.separator + d2n + File.separator + val);
        while (d.exists()) {
            d = new File(String.valueOf(basedir) + File.separator + d0n + File.separator + d1n + File.separator + d2n + File.separator + ++val);
        }
        d.mkdirs();
        return d;
    }

    @Override
    public synchronized void saveFile(final LocalFileReference ref) {
        if (ref == null) {
            System.out.println("ERROR: Ref is null.");
            return;
        }
        if (ref.getFileReference() == null) {
            System.out.println("ERROR: file ref is null.");
            return;
        }
        if (ref.getFileReference().getUnsignedDigest() == null) {
            System.out.println("ERROR: file digest is null.");
            return;
        }
        if (ref.getFileReference().getFile() == null) {
            System.out.println("ERROR: There is no file.");
            return;
        }
        if (!ref.getFileReference().getFile().exists()) {
            System.out.println("ERROR: The file does not exist.");
            return;
        }
        ObjectSet os = this.DB.query((Predicate)new Predicate<LocalFileReference>(){

            public boolean match(LocalFileReference ep) {
                return ep.getFileReference().getUnsignedDigest().equals(ref.getFileReference().getUnsignedDigest());
            }
        });
        if (os.size() == 0) {
            File f = ref.getFileReference().getFile();
            if (f != null && f.exists() && f.length() <= MAXFILESIZE) {
                File dir = this.dirFromDig((BBytes)ref.getFileReference().getUnsignedDigest(), String.valueOf(this.BaseDir.getPath()) + File.separator + "files");
                File sf = new File(String.valueOf(dir.getPath()) + File.separator + "file.dat");
                try {
                    FileUtils.copyFile(f, sf, true);
                    ref.getFileReference().setFile(sf);
                    this.DB.store((Object)ref);
                    this.DB.commit();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (f != null && f.exists()) {
                f.delete();
            }
        }
    }

    @Override
    public synchronized LocalFileReference getFileReference(final Object dig) {
        if (dig == null) {
            return null;
        }
        ObjectSet os = this.DB.query((Predicate)new Predicate<LocalFileReference>(){

            public boolean match(LocalFileReference ep) {
                return ep.getFileReference().getUnsignedDigest().equals(dig);
            }
        });
        Iterator i = os.iterator();
        if (i.hasNext()) {
            LocalFileReference lfr = (LocalFileReference)i.next();
            return lfr;
        }
        return null;
    }

    @Override
    public synchronized List<LocalFileReference> getFileReferences(int page, int pagesize) {
        Query q = this.DB.query();
        q.constrain(LocalFileReference.class);
        ObjectSet os = q.execute();
        LinkedList<LocalFileReference> r = new LinkedList<LocalFileReference>();
        int idx = page * pagesize;
        while (idx < (page + 1) * pagesize && idx < os.size()) {
            r.add((LocalFileReference)os.get(idx));
            ++idx;
        }
        return r;
    }

    @Override
    public synchronized List<LocalFileReference> getFileReferences(final Date fromdate) {
        ObjectSet os = this.DB.query((Predicate)new Predicate<LocalFileReference>(){

            public boolean match(LocalFileReference ep) {
                return ep.getLocalDate().compareTo(fromdate) >= 0;
            }
        });
        LinkedList<LocalFileReference> r = new LinkedList<LocalFileReference>();
        r.addAll((Collection<LocalFileReference>)os);
        return r;
    }

    @Override
    public synchronized void close() {
        this.DB.close();
    }

    private LastPostNumber getLast(final Object dig) {
        ObjectSet os = this.DB.query((Predicate)new Predicate<LastPostNumber>(){

            public boolean match(LastPostNumber lp) {
                return lp.Digest.equals(dig);
            }
        });
        Iterator i = os.iterator();
        if (i.hasNext()) {
            return (LastPostNumber)i.next();
        }
        return null;
    }

    @Override
    public synchronized Long getLastPostNumber(Peer p) {
        LastPostNumber lpn = this.getLast(p.getPeerKeysAndIdentity().getSignature().getDigest());
        if (lpn != null) {
            return lpn.PostNumber;
        }
        return null;
    }

    @Override
    public synchronized List<PostHoles> getPostHoles(Peer p) {
        if (p == null) {
            return null;
        }
        if (p.getPeerKeysAndIdentity() == null) {
            return null;
        }
        if (p.getPeerKeysAndIdentity().getSignature() == null) {
            return null;
        }
        if (p.getPeerKeysAndIdentity().getSignature().getDigest() == null) {
            return null;
        }
        return this.getPeerPostHoles(p.getPeerKeysAndIdentity().getSignature().getDigest());
    }

    private synchronized List<PostHoles> getPeerPostHoles(final Object dig) {
        LinkedList<PostHoles> r = new LinkedList<PostHoles>();
        if (dig == null) {
            return r;
        }
        ObjectSet os = this.DB.query((Predicate)new Predicate<PostHoles>(){

            public boolean match(PostHoles lp) {
                return dig.equals(lp.getPeerId());
            }
        });
        r.addAll((Collection<PostHoles>)os);
        return r;
    }

    @Override
    public synchronized void saveBadPeer(final Peer p) {
        if (p == null) {
            return;
        }
        if (p.getPeerKeysAndIdentity() == null) {
            return;
        }
        if (p.getPeerKeysAndIdentity().getSignature().getDigest() == null) {
            return;
        }
        ObjectSet osa = this.DB.query((Predicate)new Predicate<BadPeer>(){

            public boolean match(BadPeer ep) {
                return ep.Digest.equals(p.getPeerKeysAndIdentity().getSignature().getDigest());
            }
        });
        if (osa.size() == 0) {
            BadPeer bp = new BadPeer();
            bp.Digest = p.getPeerKeysAndIdentity().getSignature().getDigest();
            this.DB.store((Object)bp);
            this.DB.commit();
            this.savePeer(p);
        }
    }

    @Override
    public synchronized List<Peer> listBadPeers() {
        Query q = this.DB.query();
        q.constrain(Peer.class);
        ObjectSet os = q.execute();
        q = this.DB.query();
        q.constrain(BadPeer.class);
        ObjectSet osa = q.execute();
        LinkedList<Peer> r = new LinkedList<Peer>();
        for (Peer p : os) {
            boolean found = false;
            Iterator i2 = osa.iterator();
            while (i2.hasNext() && !found) {
                BadPeer bp = (BadPeer)i2.next();
                if (!p.getPeerKeysAndIdentity().getSignature().getDigest().equals(bp.Digest)) continue;
                found = true;
            }
            if (!found) continue;
            r.add(p);
        }
        return r;
    }

    @Override
    public synchronized boolean isBadPeer(final Object peerid) {
        ObjectSet osa = this.DB.query((Predicate)new Predicate<BadPeer>(){

            public boolean match(BadPeer ep) {
                return ep.Digest.equals(peerid);
            }
        });
        return osa.size() > 0;
    }

    @Override
    public synchronized void removeBadPeer(final Object peerid) {
        ObjectSet osa = this.DB.query((Predicate)new Predicate<BadPeer>(){

            public boolean match(BadPeer ep) {
                return ep.Digest.equals(peerid);
            }
        });
        for (BadPeer bp : osa) {
            this.DB.delete((Object)bp);
        }
    }

    @Override
    public synchronized void removePeer(Peer peer) {
        this.saveBadPeer(peer);
    }

    public class BadPeer {
        public Object Digest;
    }

    public class LastPostNumber {
        public Object Digest;
        public long PostNumber;
    }

    public class MyPeerData {
        public Peer Peer;
    }
}

