/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.ourfilesystem.db.FileReference;
import org.ourfilesystem.db.LocalFileReference;
import org.ourfilesystem.db.LocalPost;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.db.PeerPostHoleList;
import org.ourfilesystem.db.Post;
import org.ourfilesystem.db.PostHoles;
import org.ourfilesystem.db.StorageInterface;
import org.ourfilesystem.filehander.FileHandler;
import org.ourfilesystem.postcodec.Codec;
import org.ourfilesystem.postcodec.PostDecoded;
import org.ourfilesystem.security.KeySet;
import org.ourfilesystem.security.SecurityTools;
import org.ourfilesystem.utilities.BBytes;
import org.ourfilesystem.utilities.Cloning;
import org.ourfilesystem.utilities.FileDigestIndex;
import org.ourfilesystem.utilities.FileLongIndex;
import org.ourfilesystem.utilities.FileUtils;

public class StorageImpl
implements StorageInterface {
    public static int CUR_FILE_VERSION = 51;
    public static int CUR_POST_VERSION = 68;
    public static int MAXPOSTDIFF = 100;
    public static long MAXPOSTSIZE = 10240L;
    public static long MaxFileSize = 0x200000L;
    private String BaseDir;
    private String PeerDir;
    private String FileDir;
    private Peer MyPeerData;
    private KeySet MyKeySet;
    private HashMap<BBytes, Peer> PeerCache;
    private HashMap<BBytes, PeerPostHoleList> PostHoles = new HashMap();
    private FileDigestIndex PeerIndex;
    private FileDigestIndex FileIndex;
    private FileLongIndex PostDateIndex;
    private FileLongIndex FileDateIndex;

    public static void writePost(LocalPost pst, OutputStream os) throws IOException {
        os.write(CUR_POST_VERSION);
        FileUtils.writeLong(pst.getLocalDate().getTime(), os);
        if (pst.getPost().getFileReferenceDigest() == null) {
            os.write(2);
        } else {
            os.write(1);
            FileUtils.writeBytes(os, ((BBytes)pst.getPost().getFileReferenceDigest()).getBytes());
        }
        FileUtils.writeString(((File)pst.getPost().getMessage()).getPath(), os);
        FileUtils.writeLong(pst.getPost().getPostNumber(), os);
        if (pst.getPost().isPosterHasFile()) {
            os.write(1);
        } else {
            os.write(0);
        }
        SecurityTools.writeSignedDigest(pst.getPost().getSignedDigest(), os);
    }

    public static LocalPost readPost(InputStream is) throws IOException {
        LocalPost lp = new LocalPost();
        Post p = new Post();
        lp.setPost(p);
        int v = is.read();
        if (v == CUR_POST_VERSION) {
            lp.setLocalDate(new Date(FileUtils.readLong(is)));
            int v2 = is.read();
            if (v2 == 2) {
                p.setFileReferenceDigest(null);
            } else {
                p.setFileReferenceDigest(new BBytes(FileUtils.readBytes(is)));
            }
            p.setMessage(new File(FileUtils.readString(is)));
            p.setPostNumber(FileUtils.readLong(is));
            int hf = is.read();
            p.setPosterHasFile(hf == 1);
            p.setSignedDigest(SecurityTools.readSignedDigest(is));
        }
        return lp;
    }

    public static void writeFileReference(LocalFileReference ref, OutputStream os) throws IOException {
        os.write(CUR_FILE_VERSION);
        FileUtils.writeLong(ref.getLocalDate().getTime(), os);
        FileUtils.writeBytes(os, ((BBytes)ref.getFileReference().getUnsignedDigest()).getBytes());
        FileUtils.writeString(ref.getFileReference().getFile().getPath(), os);
    }

    public static LocalFileReference readFileReference(InputStream is) throws IOException {
        LocalFileReference lf = new LocalFileReference();
        FileReference fr = new FileReference();
        lf.setFileReference(fr);
        int v = is.read();
        if (v == CUR_FILE_VERSION) {
            lf.setLocalDate(new Date(FileUtils.readLong(is)));
            fr.setUnsignedDigest(new BBytes(FileUtils.readBytes(is)));
            fr.setFile(new File(FileUtils.readString(is)));
        }
        return lf;
    }

    public StorageImpl(String basedir) {
        File bd = new File(basedir);
        if (bd.exists()) {
            if (!bd.isDirectory()) {
                throw new RuntimeException("File found instead of directory: " + basedir);
            }
        } else if (!bd.mkdirs()) {
            throw new RuntimeException("Could not create base directory: " + basedir);
        }
        this.BaseDir = basedir;
        this.PeerDir = String.valueOf(this.BaseDir) + File.separator + "peers";
        this.FileDir = String.valueOf(this.BaseDir) + File.separator + "files";
        this.PeerIndex = new FileDigestIndex(this.PeerDir, String.valueOf(this.PeerDir) + File.separator + "peers.idx");
        this.FileIndex = new FileDigestIndex(this.FileDir, String.valueOf(this.FileDir) + File.separator + "file.idx");
        this.PostDateIndex = new FileLongIndex(this.PeerDir, String.valueOf(this.PeerDir) + File.separator + "date.idx");
        this.FileDateIndex = new FileLongIndex(this.FileDir, String.valueOf(this.FileDir) + File.separator + "date.idx");
        try {
            this.loadPeers();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private synchronized void loadPeers() throws IOException {
        this.PeerCache = new HashMap();
        Set<Object> lst = this.PeerIndex.list();
        for (BBytes bBytes : lst) {
            File f = this.PeerIndex.get(bBytes);
            if (!f.exists()) continue;
            FileInputStream fis = new FileInputStream(f);
            Peer p = FileUtils.readPeer(fis);
            fis.close();
            this.PeerCache.put(bBytes, p);
        }
    }

    @Override
    public synchronized void saveMyPeerData(Peer peer) {
        this.MyPeerData = Cloning.clonePeer(peer);
        this.savePeer(this.MyPeerData);
        File f = new File(String.valueOf(this.BaseDir) + File.separator + "mypeer.dat");
        try {
            FileOutputStream fos = new FileOutputStream(f);
            FileUtils.writePeer(fos, peer);
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized Peer getMyPeerData() {
        if (this.MyPeerData == null) {
            File f = new File(String.valueOf(this.BaseDir) + File.separator + "mypeer.dat");
            try {
                FileInputStream fis = new FileInputStream(f);
                this.MyPeerData = FileUtils.readPeer(fis);
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.MyPeerData;
    }

    @Override
    public synchronized void saveMyKeySet(KeySet keyset) {
        this.MyKeySet = keyset;
        File f = new File(String.valueOf(this.BaseDir) + File.separator + "mykey.dat");
        try {
            FileOutputStream fos = new FileOutputStream(f);
            SecurityTools.writeKeySet(keyset, fos);
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized KeySet getMyKeySet() {
        if (this.MyKeySet == null) {
            File f = new File(String.valueOf(this.BaseDir) + File.separator + "mykey.dat");
            try {
                FileInputStream fis = new FileInputStream(f);
                this.MyKeySet = SecurityTools.readKeySet(fis);
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.MyKeySet;
    }

    @Override
    public synchronized void savePeer(Peer peer) {
        File f = this.PeerIndex.get(peer.getPeerKeysAndIdentity().getSignature().getDigest());
        if (f == null || !f.exists()) {
            long dirnum = this.PeerCache.size();
            File dirfile = new File(String.valueOf(this.PeerDir) + File.separator + dirnum);
            while (dirfile.exists()) {
                dirfile = new File(String.valueOf(this.PeerDir) + File.separator + ++dirnum);
            }
            dirfile.mkdirs();
            f = new File(String.valueOf(dirfile.getPath()) + File.separator + "peer.dat");
        }
        try {
            FileOutputStream fos = new FileOutputStream(f);
            FileUtils.writePeer(fos, peer);
            fos.close();
            this.PeerIndex.put(peer.getPeerKeysAndIdentity().getSignature().getDigest(), f);
            this.PeerCache.put((BBytes)peer.getPeerKeysAndIdentity().getSignature().getDigest(), peer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized Peer getPeer(Object peerid) {
        Peer p = this.PeerCache.get(peerid);
        return p;
    }

    @Override
    public synchronized List<Peer> getPeerList() {
        LinkedList<Peer> pl = new LinkedList<Peer>();
        pl.addAll(this.PeerCache.values());
        return pl;
    }

    private File getFilePostIndex(BBytes b) {
        File file = this.FileIndex.get(b);
        if (file == null) {
            byte[] bt = b.getBytes();
            ByteBuffer buf = ByteBuffer.wrap(bt);
            int d0n = buf.getInt() & 0x3FFF;
            int d1n = 0;
            if (buf.remaining() >= 4) {
                d1n = buf.getInt() & 0x3FFF;
            }
            int d2n = 0;
            if (buf.remaining() >= 4) {
                d2n = buf.getInt() & 0x3FFF;
            }
            int val = 0;
            File d = new File(String.valueOf(this.FileDir) + File.separator + d0n + File.separator + d1n + File.separator + d2n + File.separator + val);
            while (d.exists()) {
                d = new File(String.valueOf(this.FileDir) + File.separator + d0n + File.separator + d1n + File.separator + d2n + File.separator + ++val);
            }
            d.mkdirs();
            file = new File(String.valueOf(d.getPath()) + File.separator + "post.idx");
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.FileIndex.put(b, file);
            return file;
        }
        return file;
    }

    private File getPeerDir(BBytes b) {
        File peerdir;
        File peerfile = this.PeerIndex.get(b);
        if (peerfile != null && peerfile.exists() && (peerdir = new File(peerfile.getParent())).exists()) {
            if (peerdir.isDirectory()) {
                return peerdir;
            }
            System.out.println("Something went wrong!  This should be a directory: " + peerdir.getPath());
        }
        return null;
    }

    @Override
    public synchronized void savePost(LocalPost post) {
        File peerdir = this.getPeerDir((BBytes)post.getPost().getSignedDigest().getPeerIdentifier());
        if (peerdir != null) {
            FileLongIndex idx = new FileLongIndex(peerdir.getPath(), String.valueOf(peerdir.getPath()) + File.separator + "post.idx");
            PeerPostHoleList phl = new PeerPostHoleList(idx);
            phl.newPostNumber(post.getPost().getPostNumber());
            this.PostHoles.put((BBytes)post.getPost().getSignedDigest().getPeerIdentifier(), phl);
            File pf = idx.get(post.getPost().getPostNumber());
            if (pf == null || !pf.exists()) {
                long subnum = post.getPost().getPostNumber() % 10240L;
                File postdir = new File(peerdir + File.separator + subnum);
                if (!postdir.exists()) {
                    postdir.mkdirs();
                }
                if (postdir.isDirectory()) {
                    try {
                        File messagefile = File.createTempFile("message", ".dat", postdir);
                        File mfile = (File)post.getPost().getMessage();
                        boolean ok = true;
                        if (mfile != null && mfile.exists()) {
                            if (mfile.length() > MAXPOSTSIZE) {
                                ok = false;
                                System.out.println("ERROR: Message file is too large.");
                                mfile.delete();
                                messagefile.delete();
                            } else {
                                messagefile.delete();
                                ok = mfile.renameTo(messagefile);
                                if (!ok) {
                                    System.out.println("ERROR: Failed to rename message file.");
                                }
                            }
                        }
                        if (ok) {
                            post.getPost().setMessage(messagefile);
                            File postfile = File.createTempFile("postfile", ".dat", postdir);
                            FileOutputStream fos = new FileOutputStream(postfile);
                            StorageImpl.writePost(post, fos);
                            fos.close();
                            idx.put(post.getPost().getPostNumber(), postfile);
                            BBytes fbd = (BBytes)post.getPost().getFileReferenceDigest();
                            if (fbd != null) {
                                File fp = this.getFilePostIndex(fbd);
                                FileDigestIndex fidx = new FileDigestIndex(this.PeerDir, fp.getPath());
                                fidx.put(post.getPost().getSignedDigest().getDigest(), postfile);
                                fidx.close();
                            }
                            long dateval = post.getLocalDate().getTime();
                            File df = this.PostDateIndex.get(dateval);
                            while (df != null) {
                                df = this.PostDateIndex.get(++dateval);
                            }
                            this.PostDateIndex.put(dateval, postfile);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            idx.close();
        }
    }

    @Override
    public synchronized List<LocalPost> getPeerPosts(Peer p, int page, int pagesize) {
        LinkedList<LocalPost> r = new LinkedList<LocalPost>();
        File peerdir = this.getPeerDir((BBytes)p.getPeerKeysAndIdentity().getSignature().getDigest());
        if (peerdir != null) {
            FileLongIndex idx = new FileLongIndex(peerdir.getPath(), String.valueOf(peerdir.getPath()) + File.separator + "post.idx");
            this.PostHoles.put((BBytes)p.getPeerKeysAndIdentity().getSignature().getDigest(), new PeerPostHoleList(idx));
            Set<Object> pl = idx.list();
            if (page * pagesize < pl.size()) {
                Object[] ary = pl.toArray();
                Arrays.sort(ary);
                int cnt = page * pagesize;
                while (cnt < (page + 1) * pagesize && cnt < ary.length) {
                    File f = idx.get(ary[cnt]);
                    if (f != null && f.exists()) {
                        try {
                            FileInputStream fis = new FileInputStream(f);
                            LocalPost lp = StorageImpl.readPost(fis);
                            fis.close();
                            r.add(lp);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    ++cnt;
                }
            }
            idx.close();
        }
        return r;
    }

    @Override
    public synchronized List<LocalPost> getPeerPosts(Peer p, long start, long end) {
        end = Math.min(end, start + (long)MAXPOSTDIFF);
        LinkedList<LocalPost> r = new LinkedList<LocalPost>();
        File peerdir = this.getPeerDir((BBytes)p.getPeerKeysAndIdentity().getSignature().getDigest());
        if (peerdir != null) {
            FileLongIndex idx = new FileLongIndex(peerdir.getPath(), String.valueOf(peerdir.getPath()) + File.separator + "post.idx");
            this.PostHoles.put((BBytes)p.getPeerKeysAndIdentity().getSignature().getDigest(), new PeerPostHoleList(idx));
            long cnt = start;
            while (cnt <= end) {
                File f = idx.get(cnt);
                if (f != null && f.exists()) {
                    try {
                        FileInputStream fis = new FileInputStream(f);
                        LocalPost lp = StorageImpl.readPost(fis);
                        fis.close();
                        r.add(lp);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++cnt;
            }
            idx.close();
        }
        return r;
    }

    public synchronized void printFileIndexes() {
        Peer myp = this.getMyPeerData();
        Set<Object> s = this.FileIndex.list();
        for (BBytes bBytes : s) {
            System.out.println("FILE: " + bBytes.toString().substring(0, 10));
            File f = this.FileIndex.get(bBytes);
            if (f == null || !f.exists()) continue;
            FileDigestIndex fidx = new FileDigestIndex(this.PeerDir, f.getPath());
            Set<Object> rs = fidx.list();
            Iterator<Object> i2 = rs.iterator();
            while (i2.hasNext()) {
                System.out.println("      ------------------------------");
                File postfile = fidx.get(i2.next());
                if (postfile == null || !postfile.exists()) continue;
                try {
                    FileInputStream fis = new FileInputStream(postfile);
                    LocalPost lp = StorageImpl.readPost(fis);
                    fis.close();
                    File mf = new File(lp.getPost().getMessage().toString());
                    if (mf.length() > 0L) {
                        System.out.println("      **************************************************************************************");
                        try {
                            PostDecoded pd = Codec.decode(lp);
                            System.out.println("       BIG FILE: " + pd.getStringValues().get(FileHandler.FILENAME));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    System.out.println("     My id: " + myp.getPeerKeysAndIdentity().getSignature().getDigest().toString().substring(0, 10));
                    System.out.println("     D: " + lp.getLocalDate());
                    System.out.println("     N: " + lp.getPost().getPostNumber());
                    System.out.println("     F: " + lp.getPost().getSignedDigest().getPeerIdentifier().toString().substring(0, 10));
                    System.out.println("     M: " + mf);
                    System.out.println("     H: " + lp.getPost().isPosterHasFile());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public synchronized List<LocalPost> getFilePosts(Object dig, int page, int pagesize) {
        LinkedList<LocalPost> r = new LinkedList<LocalPost>();
        File file = this.FileIndex.get((BBytes)dig);
        if (file != null && file.exists()) {
            FileDigestIndex fidx = new FileDigestIndex(this.PeerDir, file.getPath());
            Set<Object> rs = fidx.list();
            if (rs.size() > page * pagesize) {
                Object[] ra = rs.toArray();
                int cnt = page * pagesize;
                while (cnt < ra.length && cnt < (page + 1) * pagesize) {
                    File f = fidx.get(ra[cnt]);
                    if (f != null && f.exists()) {
                        try {
                            FileInputStream fis = new FileInputStream(f);
                            LocalPost lp = StorageImpl.readPost(fis);
                            fis.close();
                            r.add(lp);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    ++cnt;
                }
            }
            fidx.close();
        }
        return r;
    }

    @Override
    public synchronized List<LocalPost> getPosts(Date fromdate) {
        long time = fromdate.getTime();
        LinkedList<LocalPost> r = new LinkedList<LocalPost>();
        Set<Object> s = this.PostDateIndex.list();
        Iterator<Object> i = s.iterator();
        while (i.hasNext()) {
            File f;
            long v = (Long)i.next();
            if (time > v || (f = this.PostDateIndex.get(v)) == null || !f.exists()) continue;
            try {
                FileInputStream fis = new FileInputStream(f);
                LocalPost lp = StorageImpl.readPost(fis);
                fis.close();
                r.add(lp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return r;
    }

    @Override
    public synchronized void saveFile(LocalFileReference ref) {
        File f = this.getFilePostIndex((BBytes)ref.getFileReference().getUnsignedDigest());
        if (f != null && f.exists() && f.length() <= MaxFileSize) {
            try {
                boolean mv;
                File p = f.getParentFile();
                File mfile = new File(String.valueOf(p.getPath()) + File.separator + "file.dat");
                File mf = ref.getFileReference().getFile();
                if (mf != null && mf.exists() && (mv = mf.renameTo(mfile))) {
                    ref.getFileReference().setFile(mfile);
                    File ffile = new File(String.valueOf(p.getPath()) + File.separator + "ref.dat");
                    FileOutputStream fos = new FileOutputStream(ffile);
                    StorageImpl.writeFileReference(ref, fos);
                    fos.close();
                    long time = ref.getLocalDate().getTime();
                    File tf = this.FileDateIndex.get(time);
                    while (tf != null) {
                        tf = this.FileDateIndex.get(++time);
                    }
                    this.FileDateIndex.put(time, ffile);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private synchronized File getFileReferenceFile(Object dig) {
        File f = this.FileIndex.get((BBytes)dig);
        if (f != null && f.exists()) {
            File p = f.getParentFile();
            File ffile = new File(String.valueOf(p.getPath()) + File.separator + "ref.dat");
            return ffile;
        }
        return null;
    }

    @Override
    public synchronized LocalFileReference getFileReference(Object dig) {
        File ffile = this.getFileReferenceFile(dig);
        if (ffile != null && ffile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(ffile);
                LocalFileReference l = StorageImpl.readFileReference(fis);
                fis.close();
                return l;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public synchronized List<LocalFileReference> getFileReferences(int page, int pagesize) {
        LinkedList<LocalFileReference> r = new LinkedList<LocalFileReference>();
        Set<Object> s = this.FileDateIndex.list();
        Object[] ary = s.toArray();
        Arrays.sort(ary);
        int cnt = page * pagesize;
        while (cnt < ary.length && cnt < (page + 1) * pagesize) {
            try {
                File f = this.FileDateIndex.get(ary[cnt]);
                FileInputStream fis = new FileInputStream(f);
                LocalFileReference l = StorageImpl.readFileReference(fis);
                fis.close();
                r.add(l);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++cnt;
        }
        return r;
    }

    @Override
    public synchronized List<LocalFileReference> getFileReferences(Date fromdate) {
        LinkedList<LocalFileReference> r = new LinkedList<LocalFileReference>();
        long time = fromdate.getTime();
        Set<Object> s = this.FileDateIndex.list();
        Iterator<Object> i = s.iterator();
        while (i.hasNext()) {
            long val = (Long)i.next();
            if (time > val) continue;
            try {
                File f = this.FileDateIndex.get(val);
                FileInputStream fis = new FileInputStream(f);
                LocalFileReference l = StorageImpl.readFileReference(fis);
                fis.close();
                r.add(l);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return r;
    }

    @Override
    public void close() {
        this.PeerIndex.close();
        this.FileIndex.close();
        this.PostDateIndex.close();
        this.FileDateIndex.close();
    }

    @Override
    public synchronized Long getLastPostNumber(Peer p) {
        File peerdir = this.getPeerDir((BBytes)p.getPeerKeysAndIdentity().getSignature().getDigest());
        if (peerdir != null) {
            FileLongIndex idx = new FileLongIndex(peerdir.getPath(), String.valueOf(peerdir.getPath()) + File.separator + "post.idx");
            this.PostHoles.put((BBytes)p.getPeerKeysAndIdentity().getSignature().getDigest(), new PeerPostHoleList(idx));
            long v = idx.getMaxValue();
            idx.close();
            return v;
        }
        return null;
    }

    @Override
    public List<PostHoles> getPostHoles(Peer p) {
        PeerPostHoleList phl = this.PostHoles.get(p.getPeerKeysAndIdentity().getSignature().getDigest());
        if (phl != null) {
            return phl.getHoles();
        }
        return null;
    }

    @Override
    public void saveBadPeer(Peer p) {
    }

    @Override
    public List<Peer> listBadPeers() {
        return null;
    }

    @Override
    public boolean isBadPeer(Object id) {
        return false;
    }

    @Override
    public void removeBadPeer(Object id) {
    }

    @Override
    public void removePeer(Peer peer) {
    }
}

