/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.db;

import org.ourfilesystem.db.Peer;
import org.ourfilesystem.db.StorageInterface;
import org.ourfilesystem.security.CryptoDataBaseInterface;
import org.ourfilesystem.security.PublicKeySetSigned;
import org.ourfilesystem.security.SignedDigest;

public class DataBaseTools {
    public static boolean verifyPeerSignature(Peer p, StorageInterface store, CryptoDataBaseInterface security) {
        SignedDigest sg;
        PublicKeySetSigned s = p.getPeerKeysAndIdentity();
        if (s != null && (sg = s.getSignature()) != null) {
            if (store.isBadPeer(sg.getDigest())) {
                return false;
            }
            Object signid = sg.getPeerIdentifier();
            if (store.isBadPeer(signid)) {
                return false;
            }
            Peer signpeer = store.getPeer(signid);
            if (signpeer != null && security.verifyPeer(s, signpeer.getPeerKeysAndIdentity().getPublicSigningKey())) {
                Peer mp = store.getMyPeerData();
                if (security.digEquals(mp.getPeerKeysAndIdentity().getSignature().getDigest(), signid)) {
                    return true;
                }
                return DataBaseTools.verifyPeerSignature(signpeer, store, security);
            }
        }
        return false;
    }
}

