/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.core;

import java.util.Date;
import org.ourfilesystem.core.CoreUserInterface;

public class AutoUpdater
implements Runnable {
    private boolean Run;
    private CoreUserInterface Core;
    private boolean AutoPeerUpdate;
    private int PeerUpdatePeriod;
    private boolean AutoPostUpdate;
    private int PostUpdatePeriod;
    private long LastPostUpdate = 0L;
    private long LastPeerUpdate = 0L;

    public AutoUpdater(CoreUserInterface core, boolean peerup, int peermin, boolean postup, int postmin) {
        this.Core = core;
        this.Run = true;
        this.AutoPeerUpdate = peerup;
        this.AutoPostUpdate = postup;
        this.PeerUpdatePeriod = peermin;
        this.PostUpdatePeriod = postmin;
        Thread t = new Thread(this);
        t.start();
    }

    public synchronized void Close() {
        this.Run = false;
        this.notifyAll();
    }

    private long min2ms(int min) {
        return (long)min * 60L * 1000L;
    }

    private synchronized void Wait() {
        if (this.AutoPeerUpdate || this.AutoPostUpdate) {
            long wt = 0L;
            if (this.AutoPeerUpdate) {
                wt = this.min2ms(this.PeerUpdatePeriod);
            }
            if (this.AutoPostUpdate) {
                wt = this.min2ms(this.PostUpdatePeriod);
            }
            if (this.AutoPeerUpdate && this.AutoPostUpdate) {
                int m = Math.min(this.PostUpdatePeriod, this.PeerUpdatePeriod);
                wt = this.min2ms(m);
            }
            if (wt == 0L) {
                wt = 1800000L;
            }
            try {
                this.wait(wt);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void Process() {
        long tdiff;
        long curtime = new Date().getTime();
        if (this.AutoPeerUpdate && (tdiff = curtime - this.LastPeerUpdate) >= this.min2ms(this.PeerUpdatePeriod)) {
            this.LastPeerUpdate = curtime;
            this.Core.updatePeers();
        }
        if (this.AutoPostUpdate && (tdiff = curtime - this.LastPostUpdate) >= this.min2ms(this.PostUpdatePeriod)) {
            this.LastPostUpdate = curtime;
            this.Core.updatePosts();
        }
    }

    public synchronized void setAutoPeerUpdate(boolean val) {
        this.AutoPeerUpdate = val;
        this.notifyAll();
    }

    public synchronized void setAutoPostUpdate(boolean val) {
        this.AutoPostUpdate = val;
        this.notifyAll();
    }

    public synchronized void setPeerUpdatePeriod(int min) {
        this.PeerUpdatePeriod = min;
        this.notifyAll();
    }

    public synchronized void setPostUpdatePeriod(int min) {
        this.PostUpdatePeriod = min;
        this.notifyAll();
    }

    @Override
    public void run() {
        while (this.Run) {
            this.Process();
            this.Wait();
        }
    }
}

