package org.ourfilesystem.test.utilities;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import static org.junit.Assert.*;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;

import org.junit.Test;
import org.ourfilesystem.utilities.FileUtils;

public class FileUtilsTest {

	@Test
	public void test() {
		try {
			Random r = new Random();
			byte b[] = new byte[4];
			r.nextBytes(b);
			long l = r.nextLong();
			String s = "this is a new test string.";
			
			File f = new File("test.tmp");
			FileOutputStream fos = new FileOutputStream(f);
			FileUtils.writeBytes(fos, b);
			FileUtils.writeLong(l, fos);
			FileUtils.writeString(s, fos);
			fos.close();
			
			FileInputStream fis = new FileInputStream(f);
			byte nb[] = FileUtils.readBytes(fis);
			long nl = FileUtils.readLong(fis);
			String ns = FileUtils.readString(fis);
			fis.close();
			
			assertTrue(Arrays.equals(b, nb));
			assertEquals(l, nl);
			assertEquals(s, ns);
			
			
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

}
