package org.ourfilesystem.test.utilities;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import static org.junit.Assert.*;

import java.io.File;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;

import org.junit.Test;
import org.ourfilesystem.utilities.BBytes;
import org.ourfilesystem.utilities.FileDigestIndex;
import org.ourfilesystem.utilities.FileLongIndex;

public class FileIndexTest {

	@Test
	public void testDig() {
		try {
			File f = new File("dig.idx");
			if (f.exists()) {
				f.delete();
			}
			FileDigestIndex di = new FileDigestIndex("digdata", "dig.idx");
			Random r = new Random();
			byte b0[] = new byte[10]; r.nextBytes(b0); BBytes bb0 = new BBytes(b0);
			byte b1[] = new byte[10]; r.nextBytes(b1); BBytes bb1 = new BBytes(b1);
			byte b2[] = new byte[10]; r.nextBytes(b2); BBytes bb2 = new BBytes(b2);

			File d = new File("digdata");
			d.mkdirs();
			File f0 = File.createTempFile("testing", ".dat", d);
			File f1 = File.createTempFile("testing", ".dat", d);
			File f2 = File.createTempFile("testing", ".dat", d);
			
			di.put(bb0, f0);
			di.put(bb1, f1);
			di.put(bb2, f2);
			
			di.close();
			
			di = new FileDigestIndex("digdata", "dig.idx");
			
			boolean t0 = false;
			boolean t1 = false;
			boolean t2 = false;
			Set<Object> ks = di.list();
			Iterator<Object> i = ks.iterator();
			while (i.hasNext()) {
				Object k = i.next();
				if (k.equals(bb0)) { 
					t0 = true;
					File tf = di.get(k);
					assertTrue(tf.equals(f0));
				}
				if (k.equals(bb1)) { 
					t1 = true;
					File tf = di.get(k);
					assertTrue(tf.equals(f1));
				}
				if (k.equals(bb2)) {
					t2 = true;
					File tf = di.get(k);
					assertTrue(tf.equals(f2));
				}
			}
			assertTrue(t0);
			assertTrue(t1);
			assertTrue(t2);
			
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Test
	public void testLong() {
		try {
			File f = new File("long.idx");
			if (f.exists()) {
				f.delete();
			}
			FileLongIndex di = new FileLongIndex("longdata", "long.idx");
			Random r = new Random();
			long bb0 = r.nextLong();
			long bb1 = r.nextLong();
			long bb2 = r.nextLong();
			
			File d = new File("longdata");
			d.mkdirs();
			File f0 = File.createTempFile("testing", ".dat", d);
			File f1 = File.createTempFile("testing", ".dat", d);
			File f2 = File.createTempFile("testing", ".dat", d);
			
			di.put(bb0, f0);
			di.put(bb1, f1);
			di.put(bb2, f2);
			
			di.close();
			
			di = new FileLongIndex("longdata", "long.idx");
			boolean t0 = false;
			boolean t1 = false;
			boolean t2 = false;
			Set<Object> ks = di.list();
			Iterator<Object> i = ks.iterator();
			while (i.hasNext()) {
				Object k = i.next();
				if (k.equals(bb0)) { 
					t0 = true;
					File tf = di.get(k);
					assertTrue(tf.equals(f0));
				}
				if (k.equals(bb1)) { 
					t1 = true;
					File tf = di.get(k);
					assertTrue(tf.equals(f1));
				}
				if (k.equals(bb2)) {
					t2 = true;
					File tf = di.get(k);
					assertTrue(tf.equals(f2));
				}
			}
			assertTrue(t0);
			assertTrue(t1);
			assertTrue(t2);			
			
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

}
