package org.ourfilesystem.test.core;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import org.ourfilesystem.com.ConnectionUpdateInterface;
import org.ourfilesystem.com.SignatureRequestInterface;
import org.ourfilesystem.core.EventInterface;
import org.ourfilesystem.db.LocalFileReference;
import org.ourfilesystem.db.LocalPost;
import org.ourfilesystem.db.Peer;

public class CoreTestListener implements EventInterface, SignatureRequestInterface {

	@Override
	public void SignatureRequest(Peer p) {
		System.out.println("---------------------------------------------------------");
		System.out.println("Peer requested a signature: " + p.getIntroduction() +
				" @ " + p.getLocation());
		System.out.println("---------------------------------------------------------");
	}

	@Override
	public void newPostReceived(LocalPost postlist) {
		System.out.println("---------------------------------------------------------");
		System.out.println("New post received: " + postlist.getLocalDate() + " :: N" + postlist.getPost().getPostNumber());
		System.out.println("Linked to file? " + (postlist.getPost().getFileReferenceDigest() != null));
		File mf = (File) postlist.getPost().getMessage();
		try {
			byte buf[] = new byte[1024];
			FileInputStream fis = new FileInputStream(mf);
			int numread = fis.read(buf);
			while (numread != -1) {
				System.out.write(buf, 0, numread);
				numread = fis.read(buf);
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
		System.out.println("---------------------------------------------------------");
	}

	@Override
	public void newPeerReceived(Peer peerlist) {
		System.out.println("---------------------------------------------------------");
		System.out.println("Peer received: " + peerlist.getIntroduction() +
				" @ " + peerlist.getLocation());		
		System.out.println("---------------------------------------------------------");		
	}

	@Override
	public void newFileDownloaded(LocalFileReference filelist) {
		System.out.println("---------------------------------------------------------");
		System.out.println("File downloaded: " + filelist.getLocalDate() + " :: " + filelist.getFileReference().getFile());
		System.out.println("---------------------------------------------------------");		
	}

	@Override
	public void downloadFailed(Object dig) {
		System.out.println("---------------------------------------------------------");
		System.out.println("Download failed: " + dig);
		System.out.println("---------------------------------------------------------");
	}

	@Override
	public void connectionFailure(Peer p) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void connectionEvent(ConnectionUpdateInterface con) {
		// TODO Auto-generated method stub
		
	}

}
