package org.ourfilesystem.simpleui;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import java.awt.BorderLayout;
import java.awt.FlowLayout;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.WindowConstants;
import javax.swing.border.EmptyBorder;

import org.ourfilesystem.db.Peer;
import org.ourfilesystem.core.Core;
import javax.swing.JLabel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import net.miginfocom.swing.MigLayout;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JScrollPane;

public class SignRequestDialog extends JDialog {

	private static final long serialVersionUID = 1L;

	private final JPanel contentPanel = new JPanel();
	
	private Peer Peer;
	private Core Core;
	private JTextField textField;

	/**
	 * Create the dialog.
	 */
	public SignRequestDialog(Core c, Peer p) {
		setTitle("Signature Request");
		setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		Core = c;
		Peer = p;
		setBounds(100, 100, 450, 300);
		getContentPane().setLayout(new BorderLayout());
		contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
		getContentPane().add(contentPanel, BorderLayout.CENTER);
		contentPanel.setLayout(new MigLayout("", "[][grow]", "[][grow,top]"));
		{
			JLabel lblPeerLocation = new JLabel("Peer Location");
			contentPanel.add(lblPeerLocation, "cell 0 0,alignx trailing");
		}
		{
			textField = new JTextField();
			contentPanel.add(textField, "cell 1 0,growx");
			textField.setColumns(10);
			textField.setText((String)Peer.getLocation());
			textField.setEditable(false);
		}
		{
			JLabel lblPeerLocation = new JLabel("Nickname");
			contentPanel.add(lblPeerLocation, "cell 0 1,alignx trailing");
		}
		{
			textField = new JTextField();
			contentPanel.add(textField, "cell 1 1,growx");
			textField.setColumns(10);
			textField.setText((String)Peer.getNickSig());
			textField.setEditable(false);
		}
		{
			JLabel lblIntroduction = new JLabel("Introduction");
			contentPanel.add(lblIntroduction, "cell 0 2");
		}
		{
			JScrollPane scrollPane = new JScrollPane();
			contentPanel.add(scrollPane, "cell 1 2,grow");
			{
				JTextPane textPane = new JTextPane();
				scrollPane.setViewportView(textPane);
				textPane.setText(Peer.getIntroduction());
				textPane.setEditable(false);
			}
		}
		{
			JPanel buttonPane = new JPanel();
			buttonPane.setLayout(new FlowLayout(FlowLayout.RIGHT));
			getContentPane().add(buttonPane, BorderLayout.SOUTH);
			{
				JButton okButton = new JButton("Sign");
				okButton.setActionCommand("SIGN");
				okButton.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent arg0) {
						if (arg0.getActionCommand().equals("SIGN")) {
							Core.signPeer(Peer);
						}
						dispose();
					}
				});
				buttonPane.add(okButton);
			}
			{
				JButton cancelButton = new JButton("Do NOT Sign");
				cancelButton.setActionCommand("Cancel");
				buttonPane.add(cancelButton);
				getRootPane().setDefaultButton(cancelButton);
				cancelButton.addActionListener(new ActionListener() {
					@Override
					public void actionPerformed(ActionEvent arg0) {
						dispose();
					}
				});
			}
		}
	}

}
