package org.ourfilesystem.simpleui;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Locale;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

import org.ourfilesystem.db.LocalPost;
import org.ourfilesystem.utilities.FileUtils;
import org.ourfilesystem.core.Core;

public class PostDialog extends JDialog {
	private static final long serialVersionUID = 1L;

	private final JPanel contentPanel = new JPanel();
	private JTextField textField;
	private JTextPane textPane;
	private JLabel lblDate;
	private JLabel lblFrom;
	private JLabel lblAttachedFile;
	
	private LocalPost Post;
	private Core Core;
	
	public void setPost(LocalPost post) {
		Post = post;
		if (Post != null) {
			DateFormat df = DateFormat.getDateInstance(DateFormat.DEFAULT, Locale.getDefault());
			lblDate.setText(df.format(Post.getLocalDate()));
			lblFrom.setText(Post.getPost().getSignedDigest().getPeerIdentifier().toString().substring(0, 10));
			if (Post.getPost().getFileReferenceDigest() != null) {
				lblAttachedFile.setText(Post.getPost().getFileReferenceDigest().toString().substring(0, 10));
			}
			else {
				lblAttachedFile.setText("No file.");
			}
			readFile();
		}
	}
	
	private void readFile() {
		if (Post != null) {
			File f = (File)Post.getPost().getMessage();
			if (f != null) {
				try {
					FileInputStream fis = new FileInputStream(f);
					String subject = FileUtils.readString(fis);
					String body = FileUtils.readString(fis);
					textField.setText(subject);
					textPane.setText(body);
					fis.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			else {
				textField.setText("Empty");
				textPane.setText("Empty");
			}
		}
	}

	/**
	 * Create the dialog.
	 */
	public PostDialog(Core core) {
		Core = core;
		setDefaultCloseOperation(JDialog.HIDE_ON_CLOSE);
		setBounds(100, 100, 450, 300);
		getContentPane().setLayout(new BorderLayout());
		contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
		getContentPane().add(contentPanel, BorderLayout.CENTER);
		contentPanel.setLayout(new MigLayout("", "[grow]", "[][][][][][grow]"));
		{
			JLabel lblSubject = new JLabel("Subject");
			contentPanel.add(lblSubject, "cell 0 0,alignx left");
		}
		{
			textField = new JTextField();
			textField.setEditable(false);
			contentPanel.add(textField, "cell 0 1,growx");
			textField.setColumns(10);
		}
		{
			lblDate = new JLabel("Date");
			contentPanel.add(lblDate, "cell 0 2");
		}
		{
			lblFrom = new JLabel("From");
			contentPanel.add(lblFrom, "cell 0 3");
		}
		{
			JButton btnDownloadFile = new JButton("Download File");
			contentPanel.add(btnDownloadFile, "flowx,cell 0 4");
			btnDownloadFile.setActionCommand("DOWNLOAD");
			btnDownloadFile.addActionListener(new ActionListener() {
				@Override
				public void actionPerformed(ActionEvent e) {
					if (e.getActionCommand().equals("DOWNLOAD")) {
						if (Post.getPost().getFileReferenceDigest() != null) {
							Core.downloadFile(Post.getPost().getFileReferenceDigest());
						}
					}
				}
			});
		}
		{
			lblAttachedFile = new JLabel("No file attached");
			contentPanel.add(lblAttachedFile, "cell 0 4");
		}
		{
			JScrollPane scrollPane = new JScrollPane();
			contentPanel.add(scrollPane, "cell 0 5,grow");
			{
				textPane = new JTextPane();
				textPane.setEditable(false);
				scrollPane.setViewportView(textPane);
			}
		}
		{
			JPanel buttonPane = new JPanel();
			buttonPane.setLayout(new FlowLayout(FlowLayout.RIGHT));
			getContentPane().add(buttonPane, BorderLayout.SOUTH);
			{
				JButton okButton = new JButton("OK");
				okButton.setActionCommand("OK");
				buttonPane.add(okButton);
				getRootPane().setDefaultButton(okButton);
				okButton.addActionListener(new ActionListener() {
					@Override
					public void actionPerformed(ActionEvent e) {
						setVisible(false);						
					}
				});
			}
		}
	}

}
