package org.ourfilesystem.simpleui;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import java.util.Date;
import java.util.Set;

import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

import org.ourfilesystem.db.Peer;
import org.ourfilesystem.filehander.FileHandler;
import org.ourfilesystem.postcodec.PostDecoded;
import org.ourfilesystem.ui.db.DBInterface;
import org.ourfilesystem.ui.db.QueryResultsInterface;
import org.ourfilesystem.utilities.HumReadFileSize;

public class ExpandedPostTableModel extends AbstractTableModel {
	private static final long serialVersionUID = 1L;

	private QueryResultsInterface Data;
	private DBInterface DB;
	
	private String columns[] = {
			"Receive Date",
			"Post Date",
			"Poster",
			"Subject",
			"Rating",
			"File",
			"Size"
	};
	
	public class DateCellRenderer extends DefaultTableCellRenderer {
		private static final long serialVersionUID = 1L;
		public DateCellRenderer() {
			super();
		}
		public void setValue(Object value) {
			if (value == null) {
				setText("");
			}
			else if (value instanceof Date) {
				Date d = (Date)value;
				setText(d.toString());
			}
		}
	}
	
	public ExpandedPostTableModel(DBInterface db) {
		DB = db;
	}
	
	public synchronized void setQueryResults(QueryResultsInterface data) {
		Data = data;
		
		System.out.println("ExpandedPostTable received new data: " + Data);
		fireTableDataChanged();
	}
	
	@Override
	public String getColumnName(int col) {
		return columns[col];
	}
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	@Override
	public Class getColumnClass(int col) {
		if (col == 0 || col == 1) {
			return Date.class;
		}
		if (col == 4) {
			return Long.class;
		}
		return String.class;
	}
	
	@Override
	public synchronized int getRowCount() {
		QueryResultsInterface qr = Data;
		if (qr != null) {
			return qr.size();
		}
		return 0;
	}

	@Override
	public int getColumnCount() {
		return columns.length;
	}

	public synchronized PostDecoded getPost(int rowIndex) {
		QueryResultsInterface qr = Data;
		if (qr != null) {
			PostDecoded dec = qr.get(rowIndex);
			return dec;
		}
		return null;
	}
	
	@Override
	public synchronized Object getValueAt(int rowIndex, int columnIndex) {
		PostDecoded dec = getPost(rowIndex);
		if (dec != null) {
			if (columnIndex == 0) {
				return dec.getPost().getLocalDate();
			}
			if (columnIndex == 1) {
				Long v = dec.getNumberValues().get(NewExpandedPostDialog.POSTER_DATE);
				if (v != null) {
					return new Date(v);
				}
				return null;
			}
			if (columnIndex == 2) {
				Peer p = DB.searchPeer(dec.getPost().getPost().getSignedDigest().getPeerIdentifier());
				if (p != null) {
					return p.getNickSig();
				}
			}
			if (columnIndex == 3) {
				Set<String> l = dec.getStringKeySet("SUBJECT");
				if (l != null && l.size() > 0) {
					return l.iterator().next();
				}
			}
			if (columnIndex == 4) {
				Long r = dec.getNumberValues().get("RATING");
				if (r != null) {
					return r;
				}
				else {
					return 0L;
				}
			}
			if (columnIndex == 5) {
				Set<String> l = dec.getStringKeySet(FileHandler.FILENAME);
				if (l != null && l.size() > 0) {
					return l.iterator().next();
				}
			}
			if (columnIndex == 6) {
				Long v = dec.getNumberValues().get(FileHandler.FILESIZE);
				if (v != null) {
					return HumReadFileSize.fileSize(v);
				}
				else {
					return "";
				}
			}
		}
		return null;
	}

}
