package org.ourfilesystem.simpleui;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Iterator;
import java.util.Map.Entry;
import java.util.Set;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

import org.ourfilesystem.filehander.FileHandler;
import org.ourfilesystem.postcodec.PostDecoded;
import org.ourfilesystem.utilities.BBytes;
import org.ourfilesystem.utilities.HumReadFileSize;

public class ExpandedPostDialog extends JDialog {
	private static final long serialVersionUID = 1L;

	private final JPanel contentPanel = new JPanel();
	private JTextField Subject;
	private JTextField FileReference;
	private JTextPane Comment;
	private JTextPane Strings;
	private JTextPane Numbers;
	private JTextPane References;
	private JButton BtnDownload;
	
	private PostDecoded Post;
	private SimpleGUI GUI;
	private JTextField PDateField;
	private JTextField DateField;
	private JTextField FileSize;
	private JTextField FromPeer;
	
	public void setPost(PostDecoded p, String nickname) {
		Post = p;
		if (Post != null) {
			FromPeer.setText(nickname);
			if (Post.getPost().getPost().getFileReferenceDigest() != null) {
				BtnDownload.setEnabled(true);
			}
			else {
				BtnDownload.setEnabled(false);
			}
			DateField.setText(Post.getPost().getLocalDate().toString());
			Long pdv = Post.getNumberValues().get(NewExpandedPostDialog.POSTER_DATE);
			if (pdv != null) {
				PDateField.setText((new Date(pdv)).toString());
			}
			else {
				PDateField.setText("<none>");
			}
			Long v = Post.getNumberValues().get(FileHandler.FILESIZE);
			if (v != null) {
				FileSize.setText(HumReadFileSize.fileSize(v));
			}
			else {
				FileSize.setText("");
			}
			Set<String> subject = Post.getStringKeySet("SUBJECT");
			if (subject != null && subject.size() > 0) {
				Subject.setText(subject.iterator().next());
			}
			else {
				Subject.setText("");
			}
			Set<String> filename = Post.getStringKeySet(FileHandler.FILENAME);
			if (filename != null && filename.size() > 0) {
				FileReference.setText(filename.iterator().next());
			}
			else {
				FileReference.setText("");
			}
			boolean comshown = false;
			Set<String> comlist = Post.getStringKeySet(NewExpandedPostDialog.COMMENT);
			if (comlist != null) {
				if (comlist.size() > 0) {
					Comment.setText(comlist.iterator().next());
					comshown = true;
				}
			}
			if (!comshown) {
				Comment.setText(Post.getComment());
			}
			
			StringBuilder sb = new StringBuilder();
			Iterator<Entry<String,Set<String>>> i = Post.getStringValues().entrySet().iterator();
			while (i.hasNext()) {
				Entry<String,Set<String>> e = i.next();
				if (!e.getKey().equals("SUBJECT") &&
							!e.getKey().equals(FileHandler.FILENAME) &&
							!e.getKey().equals(NewExpandedPostDialog.COMMENT)) {
					sb.append(e.getKey());
					sb.append("  ::  ");
					sb.append(e.getValue());
					sb.append("\n");
				}
			}
			Strings.setText(sb.toString());
			
			sb = new StringBuilder();
			Iterator<Entry<String,Long>> i2 = Post.getNumberValues().entrySet().iterator();
			while (i2.hasNext()) {
				Entry<String,Long> e = i2.next();
				if (!e.getKey().equals(FileHandler.LARGEFILEKEY) &&
							!e.getKey().equals(FileHandler.FILESIZE) &&
							!e.getKey().equals(NewExpandedPostDialog.POSTER_DATE)) {
					sb.append(e.getKey());
					sb.append("  ::  ");
					sb.append(e.getValue());
					sb.append("\n");
				}
			}
			Numbers.setText(sb.toString());
			
			sb = new StringBuilder();
			Iterator<Entry<String,Set<Object>>> i3 = Post.getOtherReferences().entrySet().iterator();
			while (i3.hasNext()) {
				Entry<String,Set<Object>> e = i3.next();
				sb.append(e.getKey());
				sb.append("  ::  ");
				Iterator<Object> i4 = e.getValue().iterator();
				while (i4.hasNext()) {
					BBytes b = (BBytes)i4.next();
					sb.append(b.toString().substring(0, 10));
					sb.append(" ");
				}
				sb.append("\n");
			}
			References.setText(sb.toString());
		}
	}

	/**
	 * Create the dialog.
	 */
	public ExpandedPostDialog(SimpleGUI gui) {
		GUI = gui;
		setTitle("Post");
		setBounds(100, 100, 516, 585);
		getContentPane().setLayout(new BorderLayout());
		contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
		getContentPane().add(contentPanel, BorderLayout.CENTER);
		contentPanel.setLayout(new MigLayout("", "[][grow]", "[][][][][grow][grow][grow][grow]"));
		{
			JLabel lblFrom = new JLabel("From");
			contentPanel.add(lblFrom, "cell 0 0,alignx trailing");
		}
		{
			FromPeer = new JTextField();
			FromPeer.setEditable(false);
			contentPanel.add(FromPeer, "cell 1 0,growx");
			FromPeer.setColumns(10);
		}
		{
			JLabel lblDate = new JLabel("Date posted");
			contentPanel.add(lblDate, "cell 0 1,alignx trailing");
		}
		{
			PDateField = new JTextField();
			contentPanel.add(PDateField, "cell 1 1,growx");
			PDateField.setEditable(false);
			PDateField.setColumns(10);
		}
		{
			JLabel lblDate = new JLabel("Date received");
			contentPanel.add(lblDate, "cell 0 2,alignx trailing");
		}
		{
			DateField = new JTextField();
			contentPanel.add(DateField, "cell 1 2,growx");
			DateField.setEditable(false);
			DateField.setColumns(10);
		}
		{
			JLabel lblSubject = new JLabel("Subject");
			contentPanel.add(lblSubject, "cell 0 3,alignx trailing");
		}
		{
			Subject = new JTextField();
			contentPanel.add(Subject, "cell 1 3,growx");
			Subject.setEditable(false);
			Subject.setColumns(10);
		}
		{
			JLabel lblFile = new JLabel("File");
			contentPanel.add(lblFile, "cell 0 4,alignx trailing");
		}
		{
			FileReference = new JTextField();
			contentPanel.add(FileReference, "flowx,cell 1 4,growx");
			FileReference.setColumns(10);
			FileReference.setEditable(false);
		}
		{
			JLabel lblComment = new JLabel("Comment");
			contentPanel.add(lblComment, "cell 0 5");
		}
		{
			JScrollPane scrollPane = new JScrollPane();
			contentPanel.add(scrollPane, "cell 1 5,grow");
			{
				Comment = new JTextPane();
				Comment.setEditable(false);
				scrollPane.setMinimumSize(new Dimension(0, 200));
				scrollPane.setViewportView(Comment);
			}
		}
		{
			JLabel lblStrings = new JLabel("Strings");
			contentPanel.add(lblStrings, "cell 0 6");
		}
		{
			JScrollPane scrollPane = new JScrollPane();
			contentPanel.add(scrollPane, "cell 1 6,grow");
			{
				Strings = new JTextPane();
				Strings.setEditable(false);
				scrollPane.setViewportView(Strings);
			}
		}
		{
			JLabel lblNumbers = new JLabel("Numbers");
			contentPanel.add(lblNumbers, "cell 0 7");
		}
		{
			JScrollPane scrollPane = new JScrollPane();
			contentPanel.add(scrollPane, "cell 1 7,grow");
			{
				Numbers = new JTextPane();
				Numbers.setEditable(false);
				scrollPane.setViewportView(Numbers);
			}
		}
		{
			FileSize = new JTextField();
			contentPanel.add(FileSize, "cell 1 4");
			FileSize.setColumns(10);
			FileSize.setEditable(false);
		}
		{
			BtnDownload = new JButton("Download");
			contentPanel.add(BtnDownload, "cell 1 4");
			BtnDownload.addActionListener(new ActionListener() {
				@Override
				public void actionPerformed(ActionEvent a) {
					GUI.requestDownload(Post);
				}
			});
		}
		{
			JLabel lblReferences = new JLabel("References");
			contentPanel.add(lblReferences, "cell 0 8");
		}
		{
			JScrollPane scrollPane = new JScrollPane();
			contentPanel.add(scrollPane, "cell 1 8,grow");
			{
				References = new JTextPane();
				References.setEditable(false);
				scrollPane.setViewportView(References);
			}
		}
		{
			JPanel buttonPane = new JPanel();
			buttonPane.setLayout(new FlowLayout(FlowLayout.RIGHT));
			getContentPane().add(buttonPane, BorderLayout.SOUTH);
			{
				JButton cancelButton = new JButton("Dismiss");
				cancelButton.setActionCommand("Dismiss");
				buttonPane.add(cancelButton);
				cancelButton.addActionListener(new ActionListener() {
					@Override
					public void actionPerformed(ActionEvent arg0) {
						setVisible(false);
					}
				});
			}
		}
	}

	public JTextField getSubject() {
		return Subject;
	}
	public JTextField getFileReference() {
		return FileReference;
	}
	public JTextPane getComment() {
		return Comment;
	}
	public JTextPane getStrings() {
		return Strings;
	}
	public JTextPane getNumbers() {
		return Numbers;
	}
	public JTextPane getReferences() {
		return References;
	}
	public JTextField getDateField() {
		return DateField;
	}
	public JTextField getFileSize() {
		return FileSize;
	}
	public JTextField getFromPeer() {
		return FromPeer;
	}
}
