package org.ourfilesystem.filehander;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import java.io.File;
import java.io.IOException;

import org.ourfilesystem.db.LocalFileReference;
import org.ourfilesystem.utilities.BBytes;
import org.ourfilesystem.utilities.FileUtils;

public class PendingSingleDownload {
	
	private BBytes Digest;
	private boolean Requested;
	private boolean Complete;
	private File SaveAs;
	
	private boolean Paused;
	
	private int Priority;
	
	public void Init(File sa, BBytes primary, int priority, boolean paused) {
		Priority = priority;
		Paused = paused;
		SaveAs = sa;
		Digest = primary;
	}
	
	public String getDig() {
		return Digest.toString().substring(0, 6);
	}
	
	public int getNumberRequested() {
		if (Complete) {
			return 0;
		}
		if (Requested) {
			return 1;
		}
		return 0;
	}
	
	public long getAmountComplete() {
		if (Complete) {
			return 1024L * 1024L;
		}
		return 0L;
	}
	
	public long getTotalSize() {
		return 1024L * 1024L;
	}

	public void ResetRequests() {
		Requested = false;
	}
	
	public BBytes getRequest() {
		if (!Requested) {
			Requested = true;
			return Digest;
		}
		return null;
	}
	
	public boolean isInProgress() {
		return (!Complete) && Requested;
	}
	
	public boolean isComplete() {
		return Complete;
	}
	
	public boolean ProcessPiece(LocalFileReference ref) {
		if (ref.getFileReference().getUnsignedDigest().equals(Digest)) {
			try {
				FileUtils.copyFile(ref.getFileReference().getFile(), SaveAs, false);
				Complete = true;
				return true;
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return false;
	}

	public BBytes getDigest() {
		return Digest;
	}

	public void setDigest(BBytes digest) {
		Digest = digest;
	}

	public boolean isRequested() {
		return Requested;
	}

	public void setRequested(boolean requested) {
		Requested = requested;
	}

	public File getSaveAs() {
		return SaveAs;
	}

	public void setSaveAs(File saveAs) {
		SaveAs = saveAs;
	}

	public boolean isPaused() {
		return Paused;
	}

	public void setPaused(boolean paused) {
		Paused = paused;
	}

	public int getPriority() {
		return Priority;
	}

	public void setPriority(int priority) {
		Priority = priority;
	}

	public void setComplete(boolean complete) {
		Complete = complete;
	}

}
