package org.ourfilesystem.db;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import java.util.Date;
import java.util.List;

import org.ourfilesystem.security.KeySet;

public interface StorageInterface {
	
	public void saveMyPeerData(Peer peer);
	
	public Peer getMyPeerData();
	
	public void saveMyKeySet(KeySet keyset);
	
	public KeySet getMyKeySet();
	
	public void savePeer(Peer peer);
	
	public void removePeer(Peer peer);
	
	public Peer getPeer(Object peerid);
	
	public List<Peer> getPeerList();

	public void savePost(LocalPost post);
	
	public List<LocalPost> getPeerPosts(Peer p, int page, int pagesize);

	public List<LocalPost> getPeerPosts(Peer p, long start, long end);

	public List<LocalPost> getFilePosts(Object dig, int page, int pagesize);
	
	public List<LocalPost> getPosts(Date fromdate);
	
	public Long getLastPostNumber(Peer p);
	
	public List<PostHoles> getPostHoles(Peer p);
	
	public void saveFile(LocalFileReference ref);
	
	public LocalFileReference getFileReference(Object dig);
	
	public List<LocalFileReference> getFileReferences(int page, int pagesize);

	public List<LocalFileReference> getFileReferences(Date fromdate);
	
	public void saveBadPeer(Peer p);
	
	public List<Peer> listBadPeers();
	
	public boolean isBadPeer(Object id);
	
	public void removeBadPeer(Object id);

	public void close();
	
}
